/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.task.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.utils.UuidUtil;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.dcm.collection.dao.DgsDcmCollectionDao;
import xyz.yuanjilu.dgs.dcm.collection.entity.DgsDcmCollectionEntity;
import xyz.yuanjilu.dgs.filling.audit.dao.DgsFillingAuditRecordDao;
import xyz.yuanjilu.dgs.filling.common.dao.CustomDao;
import xyz.yuanjilu.dgs.filling.common.entity.DgsFillingTaskInfoBo;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgTreeNode;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgUtil;
import xyz.yuanjilu.dgs.filling.form.dao.DgsFillingFormInfoDao;
import xyz.yuanjilu.dgs.filling.listener.FillingEventNotification;
import xyz.yuanjilu.dgs.filling.rule.dao.DgsFillingRuleInfoDao;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskAgentDao;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskExpandDao;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskInfoDao;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskAgentEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.dgs.filling.task.entity.vo.AddTaskVo;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskInfoService;
import xyz.yuanjilu.system.sysorg.entity.SysOrgEntity;
import xyz.yuanjilu.system.sysuser.dao.SysUserDao;
import xyz.yuanjilu.system.sysuser.entity.SysUserEntity;
import xyz.yuanjilu.system.utils.ShiroUtils;

@Service(value="dgsFillingTaskInfoService")
public class DgsFillingTaskInfoServiceImpl
implements IDgsFillingTaskInfoService {
    @Autowired
    private DgsFillingTaskInfoDao dgsFillingTaskInfoDao;
    @Autowired
    private DgsFillingRuleInfoDao dgsFillingRuleInfoDao;
    @Autowired
    private DgsDcmCollectionDao dgsDcmCollectionDao;
    @Autowired
    private CustomDao customDao;
    @Autowired
    private SysUserDao sysUserDao;
    @Autowired
    private DgsFillingTaskAgentDao dgsFillingTaskAgentDao;
    @Autowired
    private DgsFillingFormInfoDao dgsFillingFormInfoDao;
    @Autowired
    private DgsFillingAuditRecordDao dgsFillingAuditRecordDao;
    @Autowired
    private DgsFillingTaskExpandDao dgsFillingTaskExpandDao;

    @Override
    public DgsFillingTaskInfoEntity queryObject(String id) {
        return (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(id);
    }

    @Override
    public List<DgsFillingTaskInfoEntity> queryList(Map<String, Object> map) {
        return this.dgsFillingTaskInfoDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return this.dgsFillingTaskInfoDao.queryTotal(map);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void save(DgsFillingTaskInfoEntity dgsFillingTaskInfo) {
        if (StrUtil.isBlank((CharSequence)dgsFillingTaskInfo.getId())) {
            dgsFillingTaskInfo.setId(UuidUtil.get32UUID());
        }
        dgsFillingTaskInfo.setCreatedTime(new Date());
        dgsFillingTaskInfo.setDataStatus(Long.valueOf("0"));
        this.dgsFillingTaskInfoDao.save(dgsFillingTaskInfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void update(DgsFillingTaskInfoEntity dgsFillingTaskInfo) {
        this.dgsFillingTaskInfoDao.update(dgsFillingTaskInfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void updateDelStatusBatch(String[] ids) {
        this.dgsFillingTaskInfoDao.updateDelStatusBatch(ids);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void deleteBatch(String[] ids) {
        this.dgsFillingTaskInfoDao.deleteBatch(ids);
    }

    @Override
    public List<DgsFillingTaskInfoBo> queryPagelist(Map<String, Object> map) {
        String userId = ShiroUtils.getUserId();
        SysUserEntity sysUser = (SysUserEntity)this.sysUserDao.queryObject((Object)userId);
        String status = MapUtil.getStr(map, (Object)"status");
        if (StrUtil.equals((CharSequence)"0", (CharSequence)status)) {
            if (!ShiroUtils.hasPermission((String)"dgs:filling:taskInfo:allList")) {
                map.put("sysOrgId", sysUser.getCompanyId());
            }
        } else {
            map.put("sysOrgId", sysUser.getCompanyId());
        }
        Integer page = MapUtil.getInt(map, (Object)"page");
        Integer pageSize = MapUtil.getInt(map, (Object)"limit");
        Integer startRow = (page - 1) * pageSize;
        Integer endRow = page * pageSize;
        map.put("startRow", startRow);
        map.put("endRow", endRow);
        List<DgsFillingTaskInfoBo> dgsFillingTaskInfoBos = this.dgsFillingTaskInfoDao.queryPagelist(map);
        MapUtil.removeAny(map, (Object[])new String[]{"startRow", "endRow"});
        return dgsFillingTaskInfoBos;
    }

    @Override
    public List<DgsFillingTaskInfoBo> querySubTasklist(Map<String, Object> map) {
        String pTaskId = MapUtil.getStr(map, (Object)"pTaskId");
        Assert.isBlank((String)pTaskId, (String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        map.put("orTaskInfoId", pTaskId);
        Integer page = MapUtil.getInt(map, (Object)"page");
        Integer pageSize = MapUtil.getInt(map, (Object)"limit");
        Integer startRow = (page - 1) * pageSize;
        Integer endRow = page * pageSize;
        map.put("startRow", startRow);
        map.put("endRow", endRow);
        List<DgsFillingTaskInfoBo> dgsFillingTaskInfoBos = this.dgsFillingTaskInfoDao.querySubTasklist(map);
        MapUtil.removeAny(map, (Object[])new String[]{"startRow", "endRow"});
        return dgsFillingTaskInfoBos;
    }

    @Override
    public int queryPageTotal(Map<String, Object> map) {
        return this.dgsFillingTaskInfoDao.queryPageTotal(map);
    }

    @Override
    public Map<String, Object> filingAssistantData(Map<String, Object> params) {
        String taskInfoId = MapUtil.getStr(params, (Object)"taskInfoId", (String)"");
        String fieldCode = MapUtil.getStr(params, (Object)"fieldCode", (String)"");
        DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(taskInfoId);
        DgsFillingTaskAgentEntity dgsFillingTaskAgentEntity = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(taskInfoId);
        String orgId = dgsFillingTaskAgentEntity.getFillingOrg();
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
        FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)dgsFillingRuleInfoEntity.getFillingConfig(), FillingConfigBo.class);
        DgsDcmCollectionEntity dgsDcmCollectionEntity = (DgsDcmCollectionEntity)this.dgsDcmCollectionDao.queryObject((Object)fillingConfigBo.getSummaryConfig().getCollectionId());
        String tableCode = dgsDcmCollectionEntity.getTableCode();
        StringBuffer batchNo = new StringBuffer();
        batchNo.append("select (select SYS_ORG_NAME from SYS_ORG where ID=d.FILLING_ORG) NAME,c.TASK_CODE as CODE,NVL(a.").append(fieldCode).append(",0) ").append("as NUM FROM ").append("DGS_T_").append(tableCode).append(" ").append("a left join DGS_FILLING_TASK_EXPAND b on a.ID=b.COLLECTION_ID ").append("left join DGS_FILLING_TASK_INFO c on b.TASK_INFO_ID=c.ID ").append("left join DGS_FILLING_TASK_AGENT d on c.ID=d.TASK_INFO_ID ").append("left join SYS_ORG o on d.FILLING_ORG=o.ID ").append("where c.P_TASK_ID='").append(taskInfoId).append("' and d.STATUS IN ('1','3')").append(" order by o.SYS_ORG_SORT asc");
        List<Map<String, Object>> batchNoList = this.customDao.executeCustomSelect(batchNo.toString());
        BigDecimal batchNoTotal = BigDecimal.ZERO;
        for (Map<String, Object> map : batchNoList) {
            Object fieldValue = map.get("NUM");
            batchNoTotal = batchNoTotal.add(new BigDecimal(fieldValue.toString()));
        }
        StringBuffer hisBatch = new StringBuffer();
        hisBatch.append("select (select SYS_ORG_NAME from SYS_ORG where ID=d.FILLING_ORG) NAME,c.TASK_CODE as CODE,a.").append(fieldCode).append(" ").append("as NUM,c.BATCH_DATE as batchDate FROM ").append("DGS_T_").append(tableCode).append(" ").append("a left join DGS_FILLING_TASK_EXPAND b on a.ID=b.COLLECTION_ID ").append("left join DGS_FILLING_TASK_INFO c on b.TASK_INFO_ID=c.ID ").append("left join DGS_FILLING_TASK_AGENT d on c.ID=d.TASK_INFO_ID ").append("left join SYS_ORG o on d.FILLING_ORG=o.ID ").append("where d.FILLING_ORG='").append(orgId).append("' and d.STATUS IN ('1','3')").append(" and TO_DATE(c.BATCH_DATE, 'YYYY-MM-DD')< TO_DATE('").append(dgsFillingTaskInfoEntity.getBatchDate()).append("', 'YYYY-MM-DD') order by o.SYS_ORG_SORT asc,TO_DATE(c.BATCH_DATE, 'YYYY-MM-DD') DESC");
        List<Map<String, Object>> hisBatchList = this.customDao.executeCustomSelect(hisBatch.toString());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("batchNoList", batchNoList);
        result.put("batchNoTotal", batchNoTotal);
        result.put("hisBatchList", hisBatchList);
        return result;
    }

    @Override
    public List<DgsFillingTaskInfoBo> pageList(Map<String, Object> map) {
        Assert.isBlank((String)MapUtil.getStr(map, (Object)"status"), (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u4efb\u52a1\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isBlank((String)MapUtil.getStr(map, (Object)"sysOrgId"), (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u6240\u5c5e\u5355\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
        return this.dgsFillingTaskInfoDao.queryPagelist(map);
    }

    @Override
    public void addTask(AddTaskVo addTaskVo) {
        List<DgsFillingTaskInfoEntity> ruleBatchTaskList;
        FillingOrgTreeNode parentOrg;
        DgsFillingRuleInfoEntity ruleInfo = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(addTaskVo.getRuleInfoId());
        Assert.isNull((Object)ruleInfo, (String)"\u89c4\u5219\u4fe1\u606f\u4e0d\u5b58\u5728");
        String infoId = UUID.randomUUID().toString().replace("-", "");
        String taskCode = "TB" + UUID.randomUUID().toString().replace("-", "");
        DgsFillingTaskInfoEntity info = new DgsFillingTaskInfoEntity();
        info.setId(infoId);
        info.setRuleInfoId(ruleInfo.getId());
        info.setTaskCode(taskCode);
        info.setBatchDate(addTaskVo.getBatchDate());
        FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)ruleInfo.getFillingConfig(), FillingConfigBo.class);
        String parentOrgId = null;
        if (ObjUtil.isNotNull((Object)fillingConfigBo) && ObjectUtil.isNotNull((Object)(parentOrg = FillingOrgUtil.getParentOrg(fillingConfigBo.getProcessConfig().getOrgTree(), addTaskVo.getFillingOrg())))) {
            parentOrgId = parentOrg.getOrgId();
            DgsFillingTaskInfoEntity supTaskInfo = this.dgsFillingTaskInfoDao.getRuleOrgBatchTaskInfo(addTaskVo.getRuleInfoId(), addTaskVo.getBatchDate(), parentOrgId);
            if (ObjUtil.isNotNull((Object)supTaskInfo)) {
                info.setpTaskId(supTaskInfo.getId());
            } else {
                throw new RRException("\u672a\u627e\u5230\u89c4\u5219\u914d\u7f6e\u4e2d\u8be5\u5355\u4f4d\u7684\u4e0a\u7ea7\u5355\u4f4d\u4efb\u52a1\uff0c\u8bf7\u5148\u751f\u6210\u3010" + parentOrg.getOrgName() + "\u3011\u5355\u4f4d\u4efb\u52a1");
            }
        }
        if (!CollUtil.isEmpty(ruleBatchTaskList = this.dgsFillingTaskInfoDao.queryRuleBatchTaskList(addTaskVo.getRuleInfoId(), addTaskVo.getBatchDate()))) {
            DgsFillingTaskInfoEntity one = ruleBatchTaskList.get(0);
            info.setPlanStartTime(one.getPlanStartTime());
            info.setPlanEndTime(one.getPlanEndTime());
        }
        info.setCreatedTime(new Date());
        info.setDataStatus(Long.valueOf("0"));
        this.dgsFillingTaskInfoDao.save(info);
        String agentId = UUID.randomUUID().toString().replace("-", "");
        DgsFillingTaskAgentEntity agent = new DgsFillingTaskAgentEntity();
        agent.setId(agentId);
        agent.setTaskInfoId(infoId);
        agent.setFillingOrg(addTaskVo.getFillingOrg());
        agent.setAuditOrg(parentOrgId);
        agent.setStatus(0L);
        agent.setTaskStartTime(new Date());
        agent.setCreatedTime(new Date());
        agent.setDataStatus(Long.valueOf("0"));
        this.dgsFillingTaskAgentDao.save(agent);
    }

    @Override
    public void delTask(Map<String, Object> params) {
        String taskInfoIds = MapUtil.getStr(params, (Object)"taskInfoIds");
        String ruleInfoId = MapUtil.getStr(params, (Object)"ruleInfoId");
        String isNode = MapUtil.getStr(params, (Object)"isNode");
        String orgId = MapUtil.getStr(params, (Object)"orgId");
        if (StrUtil.equals((CharSequence)isNode, (CharSequence)"1") && StrUtil.isNotBlank((CharSequence)orgId)) {
            DgsFillingRuleInfoEntity ruleInfo = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(ruleInfoId);
            Assert.isNull((Object)ruleInfo, (String)"\u89c4\u5219\u4e0d\u5b58\u5728");
            FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)ruleInfo.getFillingConfig(), FillingConfigBo.class);
            Assert.isNull((Object)fillingConfigBo, (String)"\u5f53\u524d\u89c4\u5219\uff0c\u672a\u8bbe\u7f6e\u586b\u62a5\u914d\u7f6e");
            Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)fillingConfigBo.getProcessConfig().getOrgTree()), (String)"\u5f53\u524d\u89c4\u5219\uff0c\u672a\u8bbe\u7f6e\u586b\u62a5\u5355\u4f4d");
            List<FillingOrgTreeNode> fillingOrgNodes = FillingOrgUtil.getFillingOrgNodes(fillingConfigBo.getProcessConfig().getOrgTree());
            fillingOrgNodes = fillingOrgNodes.stream().filter(f -> !StrUtil.equals((CharSequence)orgId, (CharSequence)f.getOrgId())).collect(Collectors.toList());
            List<FillingOrgTreeNode> treeData = FillingOrgUtil.getTreeData(fillingOrgNodes);
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)fillingConfigBo));
            JSONObject processConfig = jsonObject.getJSONObject("processConfig");
            processConfig.put("orgTree", (Object)JSONArray.parseArray((String)JSON.toJSONString(treeData)));
            String jsonString = jsonObject.toJSONString();
            this.dgsFillingRuleInfoDao.updateFillingConfig(ruleInfoId, jsonString);
        }
        this.dgsFillingFormInfoDao.delByTaskInfoId(taskInfoIds);
        this.dgsFillingTaskAgentDao.delByTaskInfoId(taskInfoIds);
        this.dgsFillingAuditRecordDao.delByTaskInfoId(taskInfoIds);
        for (String taskInfoId : taskInfoIds.split(",")) {
            DgsFillingRuleInfoEntity ruleInfo = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
            if (ObjUtil.isNull((Object)ruleInfo)) continue;
            FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)ruleInfo.getFillingConfig(), FillingConfigBo.class);
            FillingConfigBo.SummaryConfig summaryConfig = fillingConfigBo.getSummaryConfig();
            String collectionId = summaryConfig.getCollectionId();
            DgsDcmCollectionEntity dcmCollection = (DgsDcmCollectionEntity)this.dgsDcmCollectionDao.queryObject((Object)collectionId);
            String customDeleteSql = "DELETE FROM DGS_T_" + dcmCollection.getTableCode() + " WHERE ID IN (SELECT COLLECTION_ID FROM DGS_FILLING_TASK_EXPAND WHERE TASK_INFO_ID='" + taskInfoId + "')";
            this.customDao.executeCustomDelete(customDeleteSql);
        }
        this.dgsFillingTaskExpandDao.delByTaskInfoId(taskInfoIds);
        this.dgsFillingTaskInfoDao.delById(taskInfoIds);
    }

    @Override
    public List<String> getBatchDateList(String ruleInfoId) {
        return this.dgsFillingTaskInfoDao.getBatchDateList(ruleInfoId);
    }

    @Override
    public List<SysOrgEntity> getNotTaskOrgList(Map<String, Object> params) {
        String ruleInfoId = MapUtil.getStr(params, (Object)"ruleInfoId");
        DgsFillingRuleInfoEntity ruleInfo = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(ruleInfoId);
        Assert.isNull((Object)ruleInfo, (String)"\u89c4\u5219\u4e0d\u5b58\u5728");
        FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)ruleInfo.getFillingConfig(), FillingConfigBo.class);
        Assert.isNull((Object)fillingConfigBo, (String)"\u5f53\u524d\u89c4\u5219\uff0c\u672a\u8bbe\u7f6e\u586b\u62a5\u914d\u7f6e");
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)fillingConfigBo.getProcessConfig().getOrgTree()), (String)"\u5f53\u524d\u89c4\u5219\uff0c\u672a\u8bbe\u7f6e\u586b\u62a5\u5355\u4f4d");
        List<FillingOrgTreeNode> fillingOrgNodes = FillingOrgUtil.getFillingOrgNodes(fillingConfigBo.getProcessConfig().getOrgTree());
        List orgIds = fillingOrgNodes.stream().map(FillingOrgTreeNode::getOrgId).collect(Collectors.toList());
        params.put("orgIds", orgIds);
        return this.dgsFillingTaskInfoDao.getNotTaskOrgList(params);
    }

    @Override
    public Map<String, Object> orgTaskData(String orgId) {
        List<DgsFillingTaskAgentEntity> agentEntities = this.dgsFillingTaskAgentDao.getByFillingOrg(orgId);
        if (CollUtil.isEmpty(agentEntities)) {
            return null;
        }
        List<Long> check = Arrays.asList(0L, 2L, 4L);
        long incompleteNum = agentEntities.stream().filter(f -> check.contains(f.getStatus())).count();
        long completeNum = agentEntities.stream().filter(f -> !check.contains(f.getStatus())).count();
        List taskInfoIds = agentEntities.stream().filter(f -> check.contains(f.getStatus())).collect(Collectors.toList()).stream().map(DgsFillingTaskAgentEntity::getTaskInfoId).collect(Collectors.toList());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("incompleteNum", incompleteNum);
        result.put("completeNum", completeNum);
        result.put("taskInfoIds", taskInfoIds);
        return result;
    }

    @Override
    public List<Map<String, String>> getTaskListenerDic() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        Map<String, String> map = FillingEventNotification.getFillingProcessListenerEntrySet();
        map.forEach((key, value) -> {
            HashMap<String, String> objMap = new HashMap<String, String>();
            objMap.put("id", (String)key);
            objMap.put("name", (String)value);
            result.add(objMap);
        });
        return result;
    }

    @Override
    public List<DgsFillingTaskInfoEntity> getQuarterNotFillMonthData(String fillingOrg, String batchDate, String ruleCode) {
        return this.dgsFillingTaskInfoDao.getQuarterNotFillMonthData(fillingOrg, batchDate, ruleCode);
    }

    @Override
    public List<DgsFillingTaskInfoEntity> getHisNotFillData(String fillingOrg, String batchDate, String ruleCode) {
        return this.dgsFillingTaskInfoDao.getHisNotFillData(fillingOrg, batchDate, ruleCode);
    }

    @Override
    public DgsFillingTaskInfoEntity getRuleBatchDate(String fillingOrg, String batchDate, String ruleCode) {
        return this.dgsFillingTaskInfoDao.getRuleBatchDate(fillingOrg, batchDate, ruleCode);
    }

    @Override
    public Map<String, Object> getExpandDataByTaskInfoId(String taskInfoId) {
        DgsFillingRuleInfoEntity ruleInfo = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
        if (ObjectUtil.isNotNull((Object)ruleInfo)) {
            FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)ruleInfo.getFillingConfig(), FillingConfigBo.class);
            Assert.isNull((Object)fillingConfigBo, (String)String.format("\u4efb\u52a1\u586b\u62a5\u89c4\u5219\u3010%s\u3011\uff0c\u6ca1\u6709\u8fdb\u884c\u586b\u62a5\u914d\u7f6e", ruleInfo.getRuleName()));
            String collectionId = fillingConfigBo.getSummaryConfig().getCollectionId();
            DgsDcmCollectionEntity dgsDcmCollectionEntity = (DgsDcmCollectionEntity)this.dgsDcmCollectionDao.queryObject((Object)collectionId);
            Assert.isNull((Object)dgsDcmCollectionEntity, (String)String.format("\u672a\u627e\u5230\u4efb\u52a1\u586b\u62a5\u89c4\u5219\u3010%s\u3011\u5173\u8054\u6570\u636e\u96c6\uff0c\u6570\u636e\u96c6ID\u4e3a\u3010%s\u3011", ruleInfo.getRuleName(), collectionId));
            String tableName = "DGS_T_" + dgsDcmCollectionEntity.getTableCode();
            StringBuffer buffer = new StringBuffer();
            buffer.append("select x.* from DGS_FILLING_TASK_INFO i,DGS_FILLING_TASK_EXPAND e,").append(tableName).append(" x where i.ID=e.TASK_INFO_ID and e.COLLECTION_ID=x.ID and i.ID='").append(taskInfoId).append("'");
            return this.customDao.queryMap(buffer.toString());
        }
        return null;
    }

    @Override
    public List<DgsFillingTaskInfoEntity> queryByAuditStatus(String auditStatus) {
        return this.dgsFillingTaskInfoDao.queryByAuditStatus(auditStatus);
    }

    @Override
    public Object fetchYearEndArchive(Map<String, Object> params) {
        String taskInfoId = MapUtil.getStr(params, (Object)"taskInfoId", (String)"");
        DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(taskInfoId);
        String year = null;
        try {
            String batchDate = dgsFillingTaskInfoEntity.getBatchDate();
            String[] split = batchDate.split("-");
            year = Integer.parseInt(split[0]) - 1 + "-12";
        }
        catch (NumberFormatException e) {
            return null;
        }
        DgsFillingTaskAgentEntity dgsFillingTaskAgentEntity = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(taskInfoId);
        String orgId = dgsFillingTaskAgentEntity.getFillingOrg();
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
        FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)dgsFillingRuleInfoEntity.getFillingConfig(), FillingConfigBo.class);
        DgsDcmCollectionEntity dgsDcmCollectionEntity = (DgsDcmCollectionEntity)this.dgsDcmCollectionDao.queryObject((Object)fillingConfigBo.getSummaryConfig().getCollectionId());
        String tableCode = dgsDcmCollectionEntity.getTableCode();
        StringBuffer hisBatch = new StringBuffer();
        hisBatch.append("select a.* FROM").append(" ").append("DGS_T_").append(tableCode).append(" ").append("a left join DGS_FILLING_TASK_EXPAND b on a.ID=b.COLLECTION_ID ").append("left join DGS_FILLING_TASK_INFO c on b.TASK_INFO_ID=c.ID ").append("left join DGS_FILLING_TASK_AGENT d on c.ID=d.TASK_INFO_ID ").append("left join SYS_ORG o on d.FILLING_ORG=o.ID ").append("where d.FILLING_ORG='").append(orgId).append("' and d.STATUS IN ('1','3')").append(" and TO_CHAR(TO_DATE(c.BATCH_DATE, 'YYYY-MM-DD'),'YYYY-MM')='").append(year).append("' order by o.SYS_ORG_SORT asc,TO_DATE(c.BATCH_DATE, 'YYYY-MM-DD') DESC");
        List<Map<String, Object>> hisYearBatchList = this.customDao.executeCustomSelect(hisBatch.toString());
        if (CollUtil.isNotEmpty(hisYearBatchList)) {
            return hisYearBatchList.get(0);
        }
        return null;
    }

    @Override
    public Object fetchPastArchive(Map<String, Object> params) {
        String taskInfoId = MapUtil.getStr(params, (Object)"taskInfoId", (String)"");
        DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(taskInfoId);
        DgsFillingTaskAgentEntity dgsFillingTaskAgentEntity = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(taskInfoId);
        String orgId = dgsFillingTaskAgentEntity.getFillingOrg();
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
        FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)dgsFillingRuleInfoEntity.getFillingConfig(), FillingConfigBo.class);
        DgsDcmCollectionEntity dgsDcmCollectionEntity = (DgsDcmCollectionEntity)this.dgsDcmCollectionDao.queryObject((Object)fillingConfigBo.getSummaryConfig().getCollectionId());
        String tableCode = dgsDcmCollectionEntity.getTableCode();
        StringBuffer hisBatch = new StringBuffer();
        hisBatch.append("select a.* FROM").append(" ").append("DGS_T_").append(tableCode).append(" ").append("a left join DGS_FILLING_TASK_EXPAND b on a.ID=b.COLLECTION_ID ").append("left join DGS_FILLING_TASK_INFO c on b.TASK_INFO_ID=c.ID ").append("left join DGS_FILLING_TASK_AGENT d on c.ID=d.TASK_INFO_ID ").append("left join SYS_ORG o on d.FILLING_ORG=o.ID ").append("where d.FILLING_ORG='").append(orgId).append("' and d.STATUS IN ('1','3')").append(" and TO_DATE(c.BATCH_DATE, 'YYYY-MM-DD')< TO_DATE('").append(dgsFillingTaskInfoEntity.getBatchDate()).append("', 'YYYY-MM-DD') order by TO_DATE(c.BATCH_DATE, 'YYYY-MM-DD') DESC,o.SYS_ORG_SORT asc");
        List<Map<String, Object>> hisBatchList = this.customDao.executeCustomSelect(hisBatch.toString());
        if (CollUtil.isNotEmpty(hisBatchList)) {
            return hisBatchList.get(0);
        }
        return null;
    }
}

