/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.task.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.utils.UuidUtil;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskAgentDao;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskAgentEntity;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskAgentService;

@Service(value="dgsFillingTaskAgentService")
public class DgsFillingTaskAgentServiceImpl
implements IDgsFillingTaskAgentService {
    @Autowired
    private DgsFillingTaskAgentDao dgsFillingTaskAgentDao;

    @Override
    public DgsFillingTaskAgentEntity queryObject(String id) {
        return (DgsFillingTaskAgentEntity)this.dgsFillingTaskAgentDao.queryObject(id);
    }

    @Override
    public List<DgsFillingTaskAgentEntity> queryList(Map<String, Object> map) {
        return this.dgsFillingTaskAgentDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return this.dgsFillingTaskAgentDao.queryTotal(map);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void save(DgsFillingTaskAgentEntity dgsFillingTaskAgent) {
        dgsFillingTaskAgent.setId(UuidUtil.get32UUID());
        dgsFillingTaskAgent.setStatus(0L);
        dgsFillingTaskAgent.setTaskStartTime(new Date());
        dgsFillingTaskAgent.setCreatedTime(new Date());
        dgsFillingTaskAgent.setDataStatus(Long.valueOf("0"));
        this.dgsFillingTaskAgentDao.save(dgsFillingTaskAgent);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void update(DgsFillingTaskAgentEntity dgsFillingTaskAgent) {
        this.dgsFillingTaskAgentDao.update(dgsFillingTaskAgent);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void updateDelStatusBatch(String[] ids) {
        this.dgsFillingTaskAgentDao.updateDelStatusBatch(ids);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void deleteBatch(String[] ids) {
        this.dgsFillingTaskAgentDao.deleteBatch(ids);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void updateStatusByTaskInfoId(String taskInfoId, Long status) {
        this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, status);
    }

    @Override
    public String getTaskStatus(String taskInfoId) {
        return this.dgsFillingTaskAgentDao.getTaskStatus(taskInfoId);
    }

    @Override
    public DgsFillingTaskAgentEntity getAgentInfoByTaskInfoId(String taskInfoId) {
        return this.dgsFillingTaskAgentDao.getAgentInfoByTaskInfoId(taskInfoId);
    }
}

