/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.task.controller;

import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.dgs.filling.common.entity.DgsFillingTaskInfoBo;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.dgs.filling.task.entity.vo.AddTaskVo;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskAgentService;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskInfoService;

@RestController
@RequestMapping(value={"dgs/filling/taskInfo"})
public class DgsFillingTaskInfoController {
    @Autowired
    private IDgsFillingTaskInfoService dgsFillingTaskInfoService;
    @Autowired
    private IDgsFillingTaskAgentService dgsFillingTaskAgentService;

    @RequestMapping(value={"/queryPagelist"})
    @RequiresPermissions(value={"dgs:filling:taskInfo:list"})
    public R queryPagelist(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        List<DgsFillingTaskInfoBo> dgsFillingTaskInfoBoList = this.dgsFillingTaskInfoService.queryPagelist((Map<String, Object>)query);
        int total = this.dgsFillingTaskInfoService.queryPageTotal((Map<String, Object>)query);
        PageUtils pageUtil = new PageUtils(dgsFillingTaskInfoBoList, total, query.getLimit(), query.getPage());
        return R.ok().put("page", (Object)pageUtil);
    }

    @RequestMapping(value={"/querySubTasklist"})
    public R querySubTasklist(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        List<DgsFillingTaskInfoBo> dgsFillingTaskInfoBoList = this.dgsFillingTaskInfoService.querySubTasklist((Map<String, Object>)query);
        int total = this.dgsFillingTaskInfoService.queryPageTotal((Map<String, Object>)query);
        PageUtils pageUtil = new PageUtils(dgsFillingTaskInfoBoList, total, query.getLimit(), query.getPage());
        return R.ok().put("page", (Object)pageUtil);
    }

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"dgs:filling:taskInfo:list"})
    public R list(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        List<DgsFillingTaskInfoEntity> dgsFillingTaskInfoList = this.dgsFillingTaskInfoService.queryList((Map<String, Object>)query);
        int total = this.dgsFillingTaskInfoService.queryTotal((Map<String, Object>)query);
        PageUtils pageUtil = new PageUtils(dgsFillingTaskInfoList, total, query.getLimit(), query.getPage());
        return R.ok().put("page", (Object)pageUtil);
    }

    @GetMapping(value={"/info/{id}"})
    @RequiresPermissions(value={"dgs:filling:taskInfo:info"})
    public R info(@PathVariable(value="id") String id) {
        DgsFillingTaskInfoEntity dgsFillingTaskInfo = this.dgsFillingTaskInfoService.queryObject(id);
        return R.ok().put("dgsFillingTaskInfo", (Object)dgsFillingTaskInfo);
    }

    @SysLog(value="\u4fdd\u5b58\u6570\u636e\u586b\u62a5-\u4efb\u52a1\u4fe1\u606f")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"dgs:filling:taskInfo:save"})
    public R save(@RequestBody DgsFillingTaskInfoEntity dgsFillingTaskInfo) {
        this.dgsFillingTaskInfoService.save(dgsFillingTaskInfo);
        return R.ok();
    }

    @SysLog(value="\u4fee\u6539\u6570\u636e\u586b\u62a5-\u4efb\u52a1\u4fe1\u606f")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"dgs:filling:taskInfo:update"})
    public R update(@RequestBody DgsFillingTaskInfoEntity dgsFillingTaskInfo) {
        this.dgsFillingTaskInfoService.update(dgsFillingTaskInfo);
        return R.ok();
    }

    @SysLog(value="\u903b\u8f91\u5220\u9664\u6570\u636e\u586b\u62a5-\u4efb\u52a1\u4fe1\u606f")
    @PostMapping(value={"/updateDelStatusBatch"})
    @RequiresPermissions(value={"dgs:filling:taskInfo:delete"})
    public R updateDelStatusBatch(@RequestBody String[] ids) {
        this.dgsFillingTaskInfoService.updateDelStatusBatch(ids);
        return R.ok();
    }

    @SysLog(value="\u7269\u7406\u5220\u9664\u6570\u636e\u586b\u62a5-\u4efb\u52a1\u4fe1\u606f")
    @PostMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"dgs:filling:taskInfo:delete"})
    public R deleteBatch(@RequestBody String[] ids) {
        this.dgsFillingTaskInfoService.deleteBatch(ids);
        return R.ok();
    }

    @RequestMapping(value={"/filingAssistantData"})
    public R filingAssistantData(@RequestParam Map<String, Object> params) {
        Map<String, Object> result = this.dgsFillingTaskInfoService.filingAssistantData(params);
        return R.ok().put("data", result);
    }

    @GetMapping(value={"/getTaskStatus"})
    public R getTaskStatus(@RequestParam(value="taskInfoId") String taskInfoId) {
        String status = this.dgsFillingTaskAgentService.getTaskStatus(taskInfoId);
        return R.ok().put("data", (Object)status);
    }

    @PostMapping(value={"/addTask"})
    @RequiresPermissions(value={"dgs:filling:taskInfo:save"})
    public R addTask(@RequestBody AddTaskVo addTaskVo) {
        this.dgsFillingTaskInfoService.addTask(addTaskVo);
        return R.ok();
    }

    @PostMapping(value={"/delTask"})
    @RequiresPermissions(value={"dgs:filling:taskInfo:delete"})
    public R delTask(@RequestBody Map<String, Object> params) {
        this.dgsFillingTaskInfoService.delTask(params);
        return R.ok();
    }

    @GetMapping(value={"/getBatchDateList"})
    public R getBatchDateList(@RequestParam(value="ruleInfoId") String ruleInfoId) {
        return R.ok().put("data", this.dgsFillingTaskInfoService.getBatchDateList(ruleInfoId));
    }

    @PostMapping(value={"/getNotTaskOrgList"})
    public R getNotTaskOrgList(@RequestBody Map<String, Object> params) {
        return R.ok().put("data", this.dgsFillingTaskInfoService.getNotTaskOrgList(params));
    }

    @GetMapping(value={"/orgTaskData"})
    public R orgTaskData(@RequestParam(value="orgId") String orgId) {
        return R.ok().put("data", this.dgsFillingTaskInfoService.orgTaskData(orgId));
    }

    @GetMapping(value={"/getTaskListenerDic"})
    public R getTaskListenerDic() {
        return R.ok().put("data", this.dgsFillingTaskInfoService.getTaskListenerDic());
    }

    @PostMapping(value={"/fetchYearEndArchive"})
    public R fetchYearEndArchive(@RequestBody Map<String, Object> params) {
        return R.ok().put("data", this.dgsFillingTaskInfoService.fetchYearEndArchive(params));
    }

    @PostMapping(value={"/fetchPastArchive"})
    public R fetchPastArchive(@RequestBody Map<String, Object> params) {
        return R.ok().put("data", this.dgsFillingTaskInfoService.fetchPastArchive(params));
    }
}

