/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.task;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgTreeNode;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.rule.service.IDgsFillingRuleInfoService;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskAgentEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskAgentService;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskInfoService;

@Component(value="fillingInspectionPlanTask")
public class FillingInspectionPlanTask {
    private static final Logger logger = Logger.getLogger(FillingInspectionPlanTask.class);
    @Autowired
    private IDgsFillingRuleInfoService dgsFillingRuleInfoService;
    @Autowired
    private IDgsFillingTaskInfoService dgsFillingTaskInfoService;
    @Autowired
    private IDgsFillingTaskAgentService dgsFillingTaskAgentService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void releaseInspectionTask() {
        logger.info((Object)"\u586b\u62a5\u4efb\u52a1\u8ba1\u5212\u53d1\u5e03\u586b\u62a5\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb----------");
        LocalDateTime now = LocalDateTime.now();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("status", String.valueOf(1L));
        List<DgsFillingRuleInfoEntity> dgsFillingRuleInfoEntities = this.dgsFillingRuleInfoService.queryList(queryParams);
        Assert.isNull(dgsFillingRuleInfoEntities, (String)"\u5de1\u68c0\u8ba1\u5212\u53d1\u5e03\u5de1\u68c0\u4efb\u52a1\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f----------");
        if (dgsFillingRuleInfoEntities.size() > 0) {
            for (DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity : dgsFillingRuleInfoEntities) {
                List fillingOrgTreeNodes;
                boolean checkCycle;
                String fillingTimeEnd;
                String fillingTimeStart;
                boolean checkDate;
                FillingConfigBo fillingConfigBo;
                String startStopDate;
                String fillingConfig = dgsFillingRuleInfoEntity.getFillingConfig();
                if (StrUtil.isBlank((CharSequence)fillingConfig) || StrUtil.equals((CharSequence)(startStopDate = (fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)fillingConfig, FillingConfigBo.class)).getCycleConfig().getStartStopDate()), (CharSequence)"2") && !(checkDate = this.isCheckDate(fillingTimeStart = fillingConfigBo.getCycleConfig().getFillingTimeStart(), fillingTimeEnd = fillingConfigBo.getCycleConfig().getFillingTimeEnd(), new SimpleDateFormat("yyyy-MM-dd").format(new Date()))) || !(checkCycle = this.isCheckCycle(fillingConfigBo.getCycleConfig(), now)) || ObjectUtil.isNull((Object)(fillingOrgTreeNodes = JSON.parseArray((String)fillingConfigBo.getProcessConfig().getOrgTree(), FillingOrgTreeNode.class))) || fillingOrgTreeNodes.size() <= 0) continue;
                for (FillingOrgTreeNode fillingOrgTreeNode : fillingOrgTreeNodes) {
                    Date date;
                    String id = UUID.randomUUID().toString().replace("-", "");
                    String ruleInfoId = dgsFillingRuleInfoEntity.getId();
                    String batchDate = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    String taskCode = "TB" + UUID.randomUUID().toString().replace("-", "");
                    Date planStartTime = date = new Date();
                    DateTime planEndTime = DateUtil.offsetDay((Date)date, (int)(Integer.valueOf(fillingConfigBo.getCycleConfig().getLotDayNum()) - 1));
                    DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = new DgsFillingTaskInfoEntity();
                    dgsFillingTaskInfoEntity.setId(id);
                    dgsFillingTaskInfoEntity.setRuleInfoId(ruleInfoId);
                    dgsFillingTaskInfoEntity.setTaskCode(taskCode);
                    dgsFillingTaskInfoEntity.setBatchDate(batchDate);
                    dgsFillingTaskInfoEntity.setpTaskId("");
                    dgsFillingTaskInfoEntity.setPlanStartTime(planStartTime);
                    dgsFillingTaskInfoEntity.setPlanEndTime((Date)planEndTime);
                    this.dgsFillingTaskInfoService.save(dgsFillingTaskInfoEntity);
                    DgsFillingTaskAgentEntity dgsFillingTaskAgentEntity = new DgsFillingTaskAgentEntity();
                    dgsFillingTaskAgentEntity.setTaskInfoId(id);
                    dgsFillingTaskAgentEntity.setFillingOrg(fillingOrgTreeNode.getOrgId());
                    this.dgsFillingTaskAgentService.save(dgsFillingTaskAgentEntity);
                    List<DgsFillingTaskInfoEntity> dgsFillingTaskInfoEntityChild = this.getDgsFillingTaskInfoEntityChild(dgsFillingTaskInfoEntity, fillingOrgTreeNode, new ArrayList<DgsFillingTaskInfoEntity>());
                    if (!ObjectUtil.isNotNull(dgsFillingTaskInfoEntityChild) || dgsFillingTaskInfoEntityChild.size() <= 0) continue;
                    for (DgsFillingTaskInfoEntity fillingTaskInfoEntity : dgsFillingTaskInfoEntityChild) {
                        String childTaskCode = "TB" + UUID.randomUUID().toString().replace("-", "");
                        fillingTaskInfoEntity.setTaskCode(childTaskCode);
                        this.dgsFillingTaskInfoService.save(fillingTaskInfoEntity);
                        DgsFillingTaskAgentEntity fillingTaskAgentEntity = new DgsFillingTaskAgentEntity();
                        fillingTaskAgentEntity.setTaskInfoId(fillingTaskInfoEntity.getId());
                        fillingTaskAgentEntity.setFillingOrg(fillingTaskInfoEntity.getOrgId());
                        fillingTaskAgentEntity.setAuditOrg(fillingTaskInfoEntity.getAuditOrg());
                        this.dgsFillingTaskAgentService.save(fillingTaskAgentEntity);
                    }
                }
            }
        }
    }

    private boolean isCheckDate(String startDateStr, String endDateStr, String checkDateStr) {
        long startDate = DateUtil.parseDate((CharSequence)startDateStr).getTime();
        long endDate = DateUtil.parseDate((CharSequence)endDateStr).getTime();
        long checkDate = DateUtil.parseDate((CharSequence)checkDateStr).getTime();
        return checkDate >= startDate && checkDate <= endDate;
    }

    private boolean isCheckCycle(FillingConfigBo.CycleConfig cycleConfig, LocalDateTime now) {
        String cycleType;
        boolean bol = false;
        switch (cycleType = cycleConfig.getCycleType()) {
            case "1": {
                List numberTime = cycleConfig.getNumberTime();
                if (!numberTime.contains(now.getHour())) break;
                bol = true;
                break;
            }
            case "2": {
                String dateTimeWeek = cycleConfig.getDateTimeWeek();
                String weekTime = cycleConfig.getWeekTime();
                if (!StrUtil.equals((CharSequence)dateTimeWeek, (CharSequence)String.valueOf(now.getDayOfWeek().getValue())) || !StrUtil.equals((CharSequence)weekTime, (CharSequence)String.valueOf(now.getHour()))) break;
                bol = true;
                break;
            }
            case "3": {
                String dateTimeMonth = cycleConfig.getDateTimeMonth();
                String monthTime = cycleConfig.getMonthTime();
                if (!StrUtil.equals((CharSequence)dateTimeMonth, (CharSequence)String.valueOf(now.getDayOfMonth())) || !StrUtil.equals((CharSequence)monthTime, (CharSequence)String.valueOf(now.getHour()))) break;
                bol = true;
                break;
            }
            case "4": {
                String dateTimeQuarter = cycleConfig.getDateTimeQuarter();
                String quarterDayTime = cycleConfig.getQuarterDayTime();
                String quarterTime = cycleConfig.getQuarterTime();
                if (!StrUtil.equals((CharSequence)dateTimeQuarter, (CharSequence)String.valueOf((now.getMonthValue() - 1) % 3 + 1)) || !StrUtil.equals((CharSequence)quarterDayTime, (CharSequence)String.valueOf(now.getDayOfMonth())) || !StrUtil.equals((CharSequence)quarterTime, (CharSequence)String.valueOf(now.getHour()))) break;
                bol = true;
                break;
            }
            case "5": {
                String dateTimeYearMonth = cycleConfig.getDateTimeYearMonth();
                String yearDayTime = cycleConfig.getYearDayTime();
                String yearTime = cycleConfig.getYearTime();
                if (!StrUtil.equals((CharSequence)dateTimeYearMonth, (CharSequence)String.valueOf(now.getMonthValue())) || !StrUtil.equals((CharSequence)yearDayTime, (CharSequence)String.valueOf(now.getDayOfMonth())) || !StrUtil.equals((CharSequence)yearTime, (CharSequence)String.valueOf(now.getHour()))) break;
                bol = true;
                break;
            }
            case "6": {
                String dateTimeSpecify = cycleConfig.getDateTimeSpecify();
                String specifyTime = cycleConfig.getSpecifyTime();
                if (!StrUtil.equals((CharSequence)dateTimeSpecify, (CharSequence)now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))) || !StrUtil.equals((CharSequence)specifyTime, (CharSequence)String.valueOf(now.getHour()))) break;
                bol = true;
                break;
            }
            default: {
                bol = false;
            }
        }
        return bol;
    }

    private List<DgsFillingTaskInfoEntity> getDgsFillingTaskInfoEntityChild(DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity, FillingOrgTreeNode fillingOrgTreeNode, List<DgsFillingTaskInfoEntity> dgsFillingTaskInfoEntities) {
        String orgId = StrUtil.isNotBlank((CharSequence)fillingOrgTreeNode.getOrgId()) ? fillingOrgTreeNode.getOrgId() : "";
        List<FillingOrgTreeNode> child = fillingOrgTreeNode.getChild();
        if (ObjectUtil.isNotNull(child) && child.size() > 0) {
            for (FillingOrgTreeNode orgTreeNode : child) {
                DgsFillingTaskInfoEntity ord = (DgsFillingTaskInfoEntity)JSON.parseObject((String)JSON.toJSONString((Object)dgsFillingTaskInfoEntity), DgsFillingTaskInfoEntity.class);
                ord.setId(UUID.randomUUID().toString().replace("-", ""));
                ord.setpTaskId(dgsFillingTaskInfoEntity.getId());
                ord.setOrgId(orgTreeNode.getOrgId());
                ord.setOrgId(orgTreeNode.getOrgId());
                ord.setAuditOrg(orgId);
                dgsFillingTaskInfoEntities.add(ord);
                if (!ObjectUtil.isNotNull(orgTreeNode.getChild()) || orgTreeNode.getChild().size() <= 0) continue;
                this.getDgsFillingTaskInfoEntityChild(ord, orgTreeNode, dgsFillingTaskInfoEntities);
            }
        }
        return dgsFillingTaskInfoEntities;
    }
}

