/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.rule.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.utils.UuidUtil;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgTreeNode;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgUtil;
import xyz.yuanjilu.dgs.filling.rule.dao.DgsFillingRuleInfoDao;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.rule.service.IDgsFillingRuleInfoService;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskInfoDao;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.system.utils.ShiroUtils;

@Service(value="dgsFillingRuleInfoService")
public class DgsFillingRuleInfoServiceImpl
implements IDgsFillingRuleInfoService {
    private static final Logger logger = LoggerFactory.getLogger(DgsFillingRuleInfoServiceImpl.class);
    @Autowired
    private DgsFillingRuleInfoDao dgsFillingRuleInfoDao;
    @Autowired
    private DgsFillingTaskInfoDao dgsFillingTaskInfoDao;

    @Override
    public DgsFillingRuleInfoEntity queryObject(String id) {
        return (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(id);
    }

    @Override
    public List<DgsFillingRuleInfoEntity> queryList(Map<String, Object> map) {
        return this.dgsFillingRuleInfoDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return this.dgsFillingRuleInfoDao.queryTotal(map);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void save(DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
        dgsFillingRuleInfo.setId(UuidUtil.get32UUID());
        dgsFillingRuleInfo.setRuleCode(this.generateRuleCode());
        dgsFillingRuleInfo.setCreatedTime(new Date());
        dgsFillingRuleInfo.setCreatedUserId(ShiroUtils.getUserId());
        dgsFillingRuleInfo.setStatus(0L);
        dgsFillingRuleInfo.setDataStatus(Long.valueOf("0"));
        this.dgsFillingRuleInfoDao.save(dgsFillingRuleInfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void update(DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
        this.dgsFillingRuleInfoDao.update(dgsFillingRuleInfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void updateDelStatusBatch(String[] ids) {
        this.dgsFillingRuleInfoDao.updateDelStatusBatch(ids);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void deleteBatch(String[] ids) {
        this.dgsFillingRuleInfoDao.deleteBatch(ids);
    }

    @Override
    public void release(String id) {
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(id);
        if (ObjectUtil.isNotNull((Object)dgsFillingRuleInfoEntity)) {
            dgsFillingRuleInfoEntity.setStatus(1L);
            dgsFillingRuleInfoEntity.setUpdatedTime(new Date());
            dgsFillingRuleInfoEntity.setUpdatedUserId(ShiroUtils.getUserId());
            dgsFillingRuleInfoEntity.setReleaseTime(new Date());
            this.dgsFillingRuleInfoDao.update(dgsFillingRuleInfoEntity);
        }
    }

    @Override
    public void deactivate(String id) {
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(id);
        if (ObjectUtil.isNotNull((Object)dgsFillingRuleInfoEntity)) {
            dgsFillingRuleInfoEntity.setStatus(2L);
            dgsFillingRuleInfoEntity.setUpdatedTime(new Date());
            dgsFillingRuleInfoEntity.setUpdatedUserId(ShiroUtils.getUserId());
            this.dgsFillingRuleInfoDao.update(dgsFillingRuleInfoEntity);
        }
    }

    @Override
    public String generateRuleCode() {
        List dgsFillingRuleInfoEntities = this.dgsFillingRuleInfoDao.queryList(new HashMap());
        if (ObjectUtil.isNull((Object)dgsFillingRuleInfoEntities) || dgsFillingRuleInfoEntities.size() <= 0) {
            return "SQ102010100";
        }
        Collections.sort(dgsFillingRuleInfoEntities, Comparator.comparing(DgsFillingRuleInfoEntity::getRuleCode).reversed());
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = (DgsFillingRuleInfoEntity)dgsFillingRuleInfoEntities.get(0);
        String ruleCode = dgsFillingRuleInfoEntity.getRuleCode();
        Long aLong = Long.valueOf(ruleCode.substring(2, ruleCode.length())) + 1L;
        return "SQ" + aLong.toString();
    }

    @Override
    public List<Map<String, Object>> getDefaultDataList() {
        try {
            String jsonStr = "[{\"id\":\"TASK_CREATION_TIME\",\"name\":\"\u4efb\u52a1\u521b\u5efa\u65f6\u95f4\"},{\"id\":\"TASK_START_TIME\",\"name\":\"\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\"},{\"id\":\"TASK_OPERATOR_NAME\",\"name\":\"\u4efb\u52a1\u64cd\u4f5c\u4eba\u5458\u540d\u79f0\"},{\"id\":\"TASK_ORG_NAME\",\"name\":\"\u4efb\u52a1\u6240\u5c5e\u5355\u4f4d\u540d\u79f0\"},{\"id\":\"TASK_OPERATION_TIME\",\"name\":\"\u4efb\u52a1\u64cd\u4f5c\u65f6\u95f4\"}]";
            ObjectMapper objectMapper = new ObjectMapper();
            List list = (List)objectMapper.readValue(jsonStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            return list;
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<Map<String, Object>>();
        }
    }

    @Override
    public DgsFillingRuleInfoEntity queryObjectByTaskInfoId(String taskInfoId) {
        return this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
    }

    @Override
    public Map<String, Object> getSupOrgData(Map<String, Object> params) {
        String ruleInfoId = MapUtil.getStr(params, (Object)"ruleInfoId");
        String orgId = MapUtil.getStr(params, (Object)"orgId");
        String batchDate = MapUtil.getStr(params, (Object)"batchDate");
        Assert.isBlank((String)ruleInfoId, (String)"\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isBlank((String)orgId, (String)"\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isBlank((String)batchDate, (String)"\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u586b\u62a5\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        DgsFillingRuleInfoEntity ruleInfo = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(ruleInfoId);
        Assert.isNull((Object)ruleInfo, (String)"\u89c4\u5219\u4e0d\u5b58\u5728");
        FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)ruleInfo.getFillingConfig(), FillingConfigBo.class);
        Assert.isNull((Object)fillingConfigBo, (String)"\u5f53\u524d\u89c4\u5219\uff0c\u672a\u8bbe\u7f6e\u586b\u62a5\u914d\u7f6e");
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)fillingConfigBo.getProcessConfig().getOrgTree()), (String)"\u5f53\u524d\u89c4\u5219\uff0c\u672a\u8bbe\u7f6e\u586b\u62a5\u5355\u4f4d");
        FillingOrgTreeNode parentOrg = FillingOrgUtil.getParentOrg(fillingConfigBo.getProcessConfig().getOrgTree(), orgId);
        if (ObjUtil.isNull((Object)parentOrg)) {
            return null;
        }
        DgsFillingTaskInfoEntity taskInfo = this.dgsFillingTaskInfoDao.getRuleOrgBatchTaskInfo(ruleInfoId, batchDate, parentOrg.getOrgId());
        Assert.isNull((Object)taskInfo, (String)("\u672a\u627e\u5230\u8be5\u6279\u6b21\u5355\u4f4d\u7684\u4e0a\u7ea7\u5355\u4f4d\u4efb\u52a1\u4fe1\u606f\uff0c\u4e0a\u7ea7\u5355\u4f4d\u4e3a\uff1a" + parentOrg.getOrgName()));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("org", parentOrg);
        result.put("taskInfo", taskInfo);
        return result;
    }

    @Override
    public boolean isMiddleNode(String ruleInfoId, String orgId) {
        try {
            DgsFillingRuleInfoEntity ruleInfo = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(ruleInfoId);
            FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)ruleInfo.getFillingConfig(), FillingConfigBo.class);
            List<FillingOrgTreeNode> childOrg = FillingOrgUtil.getChildOrg(fillingConfigBo.getProcessConfig().getOrgTree(), orgId);
            return !CollUtil.isEmpty(childOrg);
        }
        catch (Exception e) {
            return false;
        }
    }
}

