/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.rule.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.dgs.dcm.collection.service.DgsDcmCollectionFieldService;
import xyz.yuanjilu.dgs.dcm.collection.service.DgsDcmCollectionService;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.rule.service.IDgsFillingRuleInfoService;

@RestController
@RequestMapping(value={"dgs/filling/rule"})
public class DgsFillingRuleInfoController {
    @Autowired
    private IDgsFillingRuleInfoService dgsFillingRuleInfoService;
    @Autowired
    private DgsDcmCollectionFieldService dgsDcmCollectionFieldService;
    @Autowired
    private DgsDcmCollectionService dgsDcmCollectionService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"dgs:filling:rule:list"})
    public R list(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        List<DgsFillingRuleInfoEntity> dgsFillingRuleInfoList = this.dgsFillingRuleInfoService.queryList((Map<String, Object>)query);
        int total = this.dgsFillingRuleInfoService.queryTotal((Map<String, Object>)query);
        PageUtils pageUtil = new PageUtils(dgsFillingRuleInfoList, total, query.getLimit(), query.getPage());
        return R.ok().put("page", (Object)pageUtil);
    }

    @GetMapping(value={"/info/{id}"})
    @RequiresPermissions(value={"dgs:filling:rule:info"})
    public R info(@PathVariable(value="id") String id) {
        DgsFillingRuleInfoEntity dgsFillingRuleInfo = this.dgsFillingRuleInfoService.queryObject(id);
        return R.ok().put("dgsFillingRuleInfo", (Object)dgsFillingRuleInfo);
    }

    @SysLog(value="\u4fdd\u5b58\u6570\u636e\u586b\u62a5-\u89c4\u5219\u4fe1\u606f\u8868")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"dgs:filling:rule:save"})
    public R save(@RequestBody DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
        this.dgsFillingRuleInfoService.save(dgsFillingRuleInfo);
        return R.ok();
    }

    @SysLog(value="\u4fee\u6539\u6570\u636e\u586b\u62a5-\u89c4\u5219\u4fe1\u606f\u8868")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"dgs:filling:rule:update"})
    public R update(@RequestBody DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
        this.dgsFillingRuleInfoService.update(dgsFillingRuleInfo);
        return R.ok();
    }

    @SysLog(value="\u903b\u8f91\u5220\u9664\u6570\u636e\u586b\u62a5-\u89c4\u5219\u4fe1\u606f\u8868")
    @PostMapping(value={"/updateDelStatusBatch"})
    @RequiresPermissions(value={"dgs:filling:rule:delete"})
    public R updateDelStatusBatch(@RequestBody String[] ids) {
        this.dgsFillingRuleInfoService.updateDelStatusBatch(ids);
        return R.ok();
    }

    @SysLog(value="\u7269\u7406\u5220\u9664\u6570\u636e\u586b\u62a5-\u89c4\u5219\u4fe1\u606f\u8868")
    @PostMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"dgs:filling:rule:delete"})
    public R deleteBatch(@RequestBody String[] ids) {
        this.dgsFillingRuleInfoService.deleteBatch(ids);
        return R.ok();
    }

    @SysLog(value="\u53d1\u5e03\u6570\u636e\u586b\u62a5-\u89c4\u5219\u4fe1\u606f\u8868")
    @GetMapping(value={"/release/{id}"})
    @RequiresPermissions(value={"dgs:filling:rule:release"})
    public R release(@PathVariable(value="id") String id) {
        this.dgsFillingRuleInfoService.release(id);
        return R.ok();
    }

    @SysLog(value="\u505c\u7528\u6570\u636e\u586b\u62a5-\u89c4\u5219\u4fe1\u606f\u8868")
    @GetMapping(value={"/deactivate/{id}"})
    @RequiresPermissions(value={"dgs:filling:rule:deactivate"})
    public R deactivate(@PathVariable(value="id") String id) {
        this.dgsFillingRuleInfoService.deactivate(id);
        return R.ok();
    }

    @GetMapping(value={"/generateRuleCode"})
    public R generateRuleCode() {
        return R.ok().put("data", (Object)this.dgsFillingRuleInfoService.generateRuleCode());
    }

    @GetMapping(value={"/getDefaultDataList"})
    public R getDefaultDataList() {
        return R.ok().put("data", this.dgsFillingRuleInfoService.getDefaultDataList());
    }

    @GetMapping(value={"/getList"})
    public R getList() {
        return R.ok().put("data", this.dgsFillingRuleInfoService.queryList(new HashMap<String, Object>()));
    }

    @PostMapping(value={"/getSupOrgData"})
    public R getSupOrgData(@RequestBody Map<String, Object> params) {
        return R.ok().put("data", this.dgsFillingRuleInfoService.getSupOrgData(params));
    }

    @GetMapping(value={"/isMiddleNode"})
    public R isMiddleNode(@RequestParam(value="ruleInfoId") String ruleInfoId, @RequestParam(value="orgId") String orgId) {
        return R.ok().put("data", (Object)this.dgsFillingRuleInfoService.isMiddleNode(ruleInfoId, orgId));
    }

    @RequestMapping(value={"/queryFieldList"})
    public R queryFieldList(@RequestParam Map<String, Object> params) {
        List dgsDcmCollectionFieldEntity = this.dgsDcmCollectionFieldService.queryAll(params);
        return R.ok().put("list", (Object)dgsDcmCollectionFieldEntity);
    }

    @RequestMapping(value={"/queryDcmList"})
    public R queryDcmList(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        List dgsDcmCollectionList = this.dgsDcmCollectionService.queryList((Map)query);
        int total = this.dgsDcmCollectionService.queryTotal((Map)query);
        PageUtils pageUtil = new PageUtils(dgsDcmCollectionList, total, query.getLimit(), query.getPage());
        return R.ok().put("page", (Object)pageUtil);
    }
}

