/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.listener;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo;
import xyz.yuanjilu.dgs.filling.listener.FillingProcessDrivenManager;
import xyz.yuanjilu.dgs.filling.listener.FillingProcessListener;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;

@Component
public class FillingEventNotification {
    private static final Logger log = LoggerFactory.getLogger(FillingEventNotification.class);
    private static final String DEFAULT_PROCESS_LISTENER = "defaultFillingProcessListener";
    private static Map<String, FillingProcessListener> fillingProcessListenerList;

    @Resource
    public void setProcessListenerList(Map<String, FillingProcessListener> fillingProcessListenerList) {
        FillingEventNotification.fillingProcessListenerList = fillingProcessListenerList;
    }

    public static void notice(FillingProcessDrivenManager fillingProcessDrivenManager, ListenerType listenerType) {
        DgsFillingTaskInfoEntity taskInfoEntity = fillingProcessDrivenManager.getTaskInfoEntity();
        String info = String.format("\u586b\u62a5\u4efb\u52a1\u7f16\u53f7\u3010%s\u3011", ObjectUtil.isNull((Object)taskInfoEntity) ? "" : taskInfoEntity.getTaskCode());
        String listenerBean = "";
        DgsFillingRuleInfoEntity ruleInfo = fillingProcessDrivenManager.getRuleInfoEntity();
        if (ObjectUtil.isNotNull((Object)ruleInfo) && StrUtil.isNotBlank((CharSequence)ruleInfo.getFillingConfig())) {
            FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)ruleInfo.getFillingConfig(), FillingConfigBo.class);
            String string = listenerBean = ObjectUtil.isNotNull((Object)fillingConfigBo.getExtendConfig()) ? fillingConfigBo.getExtendConfig().getExtendBean() : "";
        }
        if (StrUtil.isBlank((CharSequence)listenerBean)) {
            listenerBean = DEFAULT_PROCESS_LISTENER;
        }
        FillingProcessListener listener = fillingProcessListenerList.get(listenerBean);
        Assert.notNull((Object)listener, (String)String.format("%s,\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u7684bean,\u53c2\u6570[%s]", info, listenerBean));
        switch (listenerType) {
            case beforePageRender: {
                listener.beforePageRender(fillingProcessDrivenManager);
                break;
            }
            case beforeTaskFilling: {
                listener.beforeTaskFilling(fillingProcessDrivenManager);
                break;
            }
            case beforeTaskAuditing: {
                listener.beforeTaskAuditing(fillingProcessDrivenManager);
                break;
            }
            case behindTaskAuditing: {
                listener.behindTaskAuditing(fillingProcessDrivenManager);
                break;
            }
            case beforeTaskReject: {
                listener.beforeTaskReject(fillingProcessDrivenManager);
                break;
            }
            case behindTaskReject: {
                listener.behindTaskReject(fillingProcessDrivenManager);
            }
        }
    }

    public static String valueTaking(FillingProcessDrivenManager fillingProcessDrivenManager, ListenerType listenerType) {
        DgsFillingTaskInfoEntity taskInfoEntity = fillingProcessDrivenManager.getTaskInfoEntity();
        String info = String.format("\u586b\u62a5\u4efb\u52a1\u7f16\u53f7\u3010%s\u3011", ObjectUtil.isNull((Object)taskInfoEntity) ? "" : taskInfoEntity.getTaskCode());
        String listenerBean = "";
        DgsFillingRuleInfoEntity ruleInfo = fillingProcessDrivenManager.getRuleInfoEntity();
        if (ObjectUtil.isNotNull((Object)ruleInfo) && StrUtil.isNotBlank((CharSequence)ruleInfo.getFillingConfig())) {
            FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)ruleInfo.getFillingConfig(), FillingConfigBo.class);
            String string = listenerBean = ObjectUtil.isNotNull((Object)fillingConfigBo.getExtendConfig()) ? fillingConfigBo.getExtendConfig().getExtendBean() : "";
        }
        if (StrUtil.isBlank((CharSequence)listenerBean)) {
            listenerBean = DEFAULT_PROCESS_LISTENER;
        }
        FillingProcessListener listener = fillingProcessListenerList.get(listenerBean);
        Assert.notNull((Object)listener, (String)String.format("%s,\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u7684bean,\u53c2\u6570[%s]", info, listenerBean));
        switch (listenerType) {
            case getQuarterlyReportRuleCode: {
                return listener.getQuarterlyReportRuleCode();
            }
            case getMonthlyReportRuleCode: {
                return listener.getMonthlyReportRuleCode();
            }
        }
        return "";
    }

    public static Map<String, String> getFillingProcessListenerEntrySet() {
        return fillingProcessListenerList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FillingProcessListener)entry.getValue()).getBeanName()));
    }

    public static enum ListenerType {
        beforePageRender,
        beforeTaskFilling,
        getQuarterlyReportRuleCode,
        getMonthlyReportRuleCode,
        beforeTaskAuditing,
        behindTaskAuditing,
        beforeTaskReject,
        behindTaskReject;

    }
}

