/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.form.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.utils.UuidUtil;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.common.validator.ValidatorUtils;
import xyz.yuanjilu.dgs.dcm.collection.dao.DgsDcmCollectionDao;
import xyz.yuanjilu.dgs.dcm.collection.entity.DgsDcmCollectionEntity;
import xyz.yuanjilu.dgs.filling.audit.dao.DgsFillingAuditRecordDao;
import xyz.yuanjilu.dgs.filling.audit.entity.DgsFillingAuditRecordEntity;
import xyz.yuanjilu.dgs.filling.common.dao.CustomDao;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo;
import xyz.yuanjilu.dgs.filling.form.dao.DgsFillingFormInfoDao;
import xyz.yuanjilu.dgs.filling.form.entity.DgsFillingFormInfoEntity;
import xyz.yuanjilu.dgs.filling.form.entity.bo.DgsFillingFormInfoBo;
import xyz.yuanjilu.dgs.filling.form.entity.bo.DgsRsaUserInfo;
import xyz.yuanjilu.dgs.filling.form.service.IDgsFillingFormInfoService;
import xyz.yuanjilu.dgs.filling.listener.FillingEventNotification;
import xyz.yuanjilu.dgs.filling.listener.FillingProcessDrivenManager;
import xyz.yuanjilu.dgs.filling.rule.dao.DgsFillingRuleInfoDao;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskAgentDao;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskExpandDao;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskInfoDao;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskAgentEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskAuditingEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskExpandEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.system.sysorg.entity.SysOrgEntity;
import xyz.yuanjilu.system.sysorg.service.ISysOrgService;
import xyz.yuanjilu.system.sysorg.service.ISysOrgUserService;
import xyz.yuanjilu.system.sysuser.entity.SysUserEntity;
import xyz.yuanjilu.system.sysuser.service.SysUserService;

@Service(value="dgsFillingFormInfoService")
public class DgsFillingFormInfoServiceImpl
implements IDgsFillingFormInfoService {
    @Autowired
    private DgsFillingFormInfoDao dgsFillingFormInfoDao;
    @Autowired
    private DgsFillingRuleInfoDao dgsFillingRuleInfoDao;
    @Autowired
    private DgsFillingTaskAgentDao dgsFillingTaskAgentDao;
    @Autowired
    private DgsFillingAuditRecordDao dgsFillingAuditRecordDao;
    @Autowired
    private DgsDcmCollectionDao dgsDcmCollectionDao;
    @Autowired
    private DgsFillingTaskExpandDao dgsFillingTaskExpandDao;
    @Autowired
    private DgsFillingTaskInfoDao dgsFillingTaskInfoDao;
    @Autowired
    private CustomDao customDao;
    @Autowired
    private ISysOrgService sysOrgService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private ISysOrgUserService sysOrgUserService;
    private static final ConcurrentHashMap<String, ReentrantLock> taskLocks = new ConcurrentHashMap();

    @Override
    public DgsFillingFormInfoEntity queryObject(String id) {
        return (DgsFillingFormInfoEntity)this.dgsFillingFormInfoDao.queryObject(id);
    }

    @Override
    public List<DgsFillingFormInfoEntity> queryList(Map<String, Object> map) {
        return this.dgsFillingFormInfoDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return this.dgsFillingFormInfoDao.queryTotal(map);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void save(DgsFillingFormInfoEntity dgsFillingFormInfo, String userId) {
        dgsFillingFormInfo.setId(UuidUtil.get32UUID());
        dgsFillingFormInfo.setFillingUserId(userId);
        this.dgsFillingFormInfoDao.save(dgsFillingFormInfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void update(DgsFillingFormInfoEntity dgsFillingFormInfo, String userId) {
        dgsFillingFormInfo.setFillingUserId(userId);
        this.dgsFillingFormInfoDao.update(dgsFillingFormInfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void updateDelStatusBatch(String[] ids) {
        this.dgsFillingFormInfoDao.updateDelStatusBatch(ids);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void deleteBatch(String[] ids) {
        this.dgsFillingFormInfoDao.deleteBatch(ids);
    }

    @Override
    public DgsFillingFormInfoEntity queryObjectByTaskInfoId(String taskInfoId) {
        return this.dgsFillingFormInfoDao.queryObjectByTaskInfoId(taskInfoId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={RRException.class})
    public void saveOrUpdate(DgsFillingFormInfoEntity dgsFillingFormInfo, String userId) {
        if (StrUtil.isNotBlank((CharSequence)dgsFillingFormInfo.getTaskInfoId())) {
            String taskInfoId = dgsFillingFormInfo.getTaskInfoId();
            ReentrantLock lock = taskLocks.computeIfAbsent(taskInfoId, id -> new ReentrantLock());
            lock.lock();
            try {
                DgsFillingFormInfoEntity dgsFillingFormInfoEntity = this.dgsFillingFormInfoDao.queryObjectByTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
                if (ObjectUtil.isNotNull((Object)dgsFillingFormInfoEntity) && StrUtil.isNotBlank((CharSequence)dgsFillingFormInfoEntity.getId())) {
                    dgsFillingFormInfo.setId(dgsFillingFormInfoEntity.getId());
                    this.update(dgsFillingFormInfo, userId);
                } else {
                    this.save(dgsFillingFormInfo, userId);
                }
                if (dgsFillingFormInfo.getStatus() == 1L) {
                    JSONArray jsonArray;
                    List collect;
                    DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
                    FillingProcessDrivenManager fillingProcessDrivenManager = FillingProcessDrivenManager.build((DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(dgsFillingFormInfo.getTaskInfoId()), dgsFillingRuleInfoEntity, dgsFillingFormInfo);
                    FillingEventNotification.notice(fillingProcessDrivenManager, FillingEventNotification.ListenerType.beforeTaskFilling);
                    String fillingConfig = dgsFillingRuleInfoEntity.getFillingConfig();
                    FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)fillingConfig, FillingConfigBo.class);
                    String completionMode = fillingConfigBo.getProcessConfig().getCompletionMode();
                    if (StrUtil.equals((CharSequence)completionMode, (CharSequence)"1")) {
                        this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfo.getTaskInfoId(), 1L);
                        this.auditRecord(userId, dgsFillingFormInfo.getTaskInfoId(), "0", "", "");
                    } else {
                        DgsFillingTaskAgentEntity fillingTaskAgentEntity = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
                        if (ObjectUtil.isNotNull((Object)fillingTaskAgentEntity.getAuditOrg())) {
                            this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfo.getTaskInfoId(), 2L);
                            this.auditRecord(userId, dgsFillingFormInfo.getTaskInfoId(), "1", "", "");
                        } else {
                            this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfo.getTaskInfoId(), 1L);
                            this.auditRecord(userId, dgsFillingFormInfo.getTaskInfoId(), "0", "", "");
                        }
                    }
                    if (StrUtil.isNotBlank((CharSequence)dgsFillingFormInfo.getFormData()) && ObjectUtil.isNotNull(collect = (jsonArray = JSON.parseArray((String)dgsFillingFormInfo.getFormData())).stream().filter(e -> {
                        JSONObject jsonObject = (JSONObject)e;
                        boolean dataCollection = jsonObject.containsKey((Object)"dataCollection");
                        return dataCollection;
                    }).collect(Collectors.toList())) && collect.size() > 0) {
                        String collectionId = fillingConfigBo.getSummaryConfig().getCollectionId();
                        DgsDcmCollectionEntity dgsDcmCollectionEntity = (DgsDcmCollectionEntity)this.dgsDcmCollectionDao.queryObject((Object)collectionId);
                        String tableName = "DGS_T_" + dgsDcmCollectionEntity.getTableCode();
                        DgsFillingTaskExpandEntity dgsFillingTaskExpandEntity = this.dgsFillingTaskExpandDao.queryByTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
                        List fieldTypes = collect.stream().map(e -> {
                            JSONObject jsonObject = (JSONObject)e;
                            String column = jsonObject.getJSONObject("dataCollection").getString("fieldType");
                            return column;
                        }).collect(Collectors.toList());
                        if (ObjectUtil.isNull((Object)dgsFillingTaskExpandEntity)) {
                            List columns = collect.stream().map(e -> {
                                JSONObject jsonObject = (JSONObject)e;
                                String column = jsonObject.getJSONObject("dataCollection").getString("fieldCode");
                                return column;
                            }).collect(Collectors.toList());
                            List values = collect.stream().map(e -> {
                                JSONObject jsonObject = (JSONObject)e;
                                String value = jsonObject.getString("cellData");
                                return value;
                            }).collect(Collectors.toList());
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("INSERT INTO ").append(tableName).append(" (");
                            buffer.append("ID,");
                            for (int i = 0; i < columns.size(); ++i) {
                                buffer.append((String)columns.get(i)).append(",");
                            }
                            String collectionUuId = UUID.randomUUID().toString().replace("-", "");
                            buffer.append("CREATED_TIME, UPDATED_TIME, DATA_STATUS, QUALITY_DATA_STATUS, BUSINESS_DATA_STATUS) VALUES ('").append(collectionUuId).append("',");
                            for (int i = 0; i < values.size(); ++i) {
                                String fieldType = (String)fieldTypes.get(i);
                                if (StrUtil.equals((CharSequence)"date", (CharSequence)fieldType)) {
                                    String value = (String)values.get(i);
                                    if (this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2}")) {
                                        value = value + " 00:00:00";
                                    }
                                    if (!this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
                                        throw new RRException("\u65f6\u95f4\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                                    }
                                    buffer.append("to_date('").append(value).append("','YYYY-MM-DD HH24:MI:SS')").append(",");
                                    continue;
                                }
                                buffer.append("'").append((String)values.get(i)).append("'").append(",");
                            }
                            buffer.append("SYSDATE,null,'0','2','0')");
                            this.customDao.executeCustomInsert(buffer.toString());
                            DgsFillingTaskExpandEntity taskExpandEntity = new DgsFillingTaskExpandEntity();
                            taskExpandEntity.setId(UUID.randomUUID().toString().replace("-", ""));
                            taskExpandEntity.setTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
                            taskExpandEntity.setCollectionId(collectionUuId);
                            taskExpandEntity.setCreatedTime(new Date());
                            this.dgsFillingTaskExpandDao.save(taskExpandEntity);
                        } else {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("UPDATE ").append(tableName).append(" SET ");
                            for (int i = 0; i < collect.size(); ++i) {
                                String fieldType = (String)fieldTypes.get(i);
                                JSONObject jsonObject = (JSONObject)collect.get(i);
                                String column = jsonObject.getJSONObject("dataCollection").getString("fieldCode");
                                String value = jsonObject.getString("cellData");
                                buffer.append(column).append("=");
                                if (StrUtil.equals((CharSequence)"date", (CharSequence)fieldType)) {
                                    if (this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2}")) {
                                        value = value + " 00:00:00";
                                    }
                                    if (!this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
                                        throw new RRException("\u65f6\u95f4\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                                    }
                                    buffer.append("to_date('").append(value).append("','YYYY-MM-DD HH24:MI:SS')").append(",");
                                    continue;
                                }
                                buffer.append("'").append(value).append("'").append(",");
                            }
                            buffer.append("UPDATED_TIME=SYSDATE").append(" WHERE ID='").append(dgsFillingTaskExpandEntity.getCollectionId()).append("'");
                            this.customDao.executeCustomUpdate(buffer.toString());
                        }
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void formReview(Map<String, Object> params) {
        String taskInfoId = MapUtil.getStr(params, (Object)"taskInfoId");
        String status = MapUtil.getStr(params, (Object)"status");
        String operatorContent = MapUtil.getStr(params, (Object)"operatorContent");
        String opinionContent = MapUtil.getStr(params, (Object)"opinionContent");
        String userId = MapUtil.getStr(params, (Object)"userId");
        DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(taskInfoId);
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
        DgsFillingTaskAuditingEntity dgsFillingTaskAuditingEntity = new DgsFillingTaskAuditingEntity(taskInfoId, status, operatorContent, opinionContent, userId);
        FillingProcessDrivenManager build = FillingProcessDrivenManager.build(dgsFillingTaskInfoEntity, dgsFillingRuleInfoEntity, dgsFillingTaskAuditingEntity);
        FillingEventNotification.notice(build, FillingEventNotification.ListenerType.beforeTaskAuditing);
        if (StrUtil.equals((CharSequence)status, (CharSequence)"1")) {
            this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, 3L);
            this.auditRecord(userId, taskInfoId, "2", operatorContent, opinionContent);
        } else {
            this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, 4L);
            this.auditRecord(userId, taskInfoId, "3", operatorContent, opinionContent);
        }
        FillingEventNotification.notice(build, FillingEventNotification.ListenerType.behindTaskAuditing);
    }

    @Override
    public R infoByTaskInfoId(String taskInfoId, SysUserEntity userEntity) {
        DgsFillingFormInfoEntity dgsFillingFormInfo = this.queryObjectByTaskInfoId(taskInfoId);
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
        DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(taskInfoId);
        DgsFillingTaskAgentEntity dgsFillingTaskAgentEntity = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(taskInfoId);
        FillingProcessDrivenManager fillingProcessDrivenManager = FillingProcessDrivenManager.build(dgsFillingTaskInfoEntity, dgsFillingRuleInfoEntity, dgsFillingFormInfo, dgsFillingTaskAgentEntity);
        FillingEventNotification.notice(fillingProcessDrivenManager, FillingEventNotification.ListenerType.beforePageRender);
        R ok = R.ok();
        ok.put("fillingConfig", (Object)(ObjectUtil.isNotNull((Object)dgsFillingRuleInfoEntity) ? dgsFillingRuleInfoEntity.getFillingConfig() : null));
        if (ObjectUtil.isNotNull((Object)dgsFillingFormInfo) && StrUtil.isNotBlank((CharSequence)dgsFillingFormInfo.getFormData())) {
            ok.put("formConfig", (Object)(ObjectUtil.isNotNull((Object)dgsFillingRuleInfoEntity) ? dgsFillingRuleInfoEntity.getFormConfig() : null));
            ok.put("formData", (Object)dgsFillingFormInfo.getFormData());
        } else {
            if (ObjectUtil.isNotNull((Object)dgsFillingRuleInfoEntity) && StrUtil.isNotBlank((CharSequence)dgsFillingRuleInfoEntity.getFormConfig())) {
                String formConfig = dgsFillingRuleInfoEntity.getFormConfig();
                JSONObject jsonObject = JSON.parseObject((String)formConfig);
                if (jsonObject.containsKey((Object)"fillCell")) {
                    JSONArray cellArr = jsonObject.getJSONArray("fillCell");
                    for (Object o : cellArr) {
                        JSONObject cellObj = (JSONObject)o;
                        if (!cellObj.containsKey((Object)"defaultValue")) continue;
                        String defaultValue = cellObj.getString("defaultValue");
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        switch (defaultValue) {
                            case "TASK_CREATION_TIME": {
                                cellObj.put("cellData", (Object)(ObjectUtil.isNotNull((Object)dgsFillingTaskInfoEntity) && ObjectUtil.isNotNull((Object)dgsFillingTaskInfoEntity.getCreatedTime()) ? dateFormat.format(dgsFillingTaskInfoEntity.getCreatedTime()) : ""));
                                break;
                            }
                            case "TASK_START_TIME": {
                                cellObj.put("cellData", (Object)(ObjectUtil.isNotNull((Object)dgsFillingTaskAgentEntity) && ObjectUtil.isNotNull((Object)dgsFillingTaskAgentEntity.getTaskStartTime()) ? dateFormat.format(dgsFillingTaskAgentEntity.getTaskStartTime()) : ""));
                                break;
                            }
                            case "TASK_OPERATOR_NAME": {
                                cellObj.put("cellData", (Object)userEntity.getUsernickname());
                                break;
                            }
                            case "TASK_ORG_NAME": {
                                SysOrgEntity sysOrgEntity;
                                String orgName = "";
                                if (ObjectUtil.isNotNull((Object)dgsFillingTaskAgentEntity) && StrUtil.isNotBlank((CharSequence)dgsFillingTaskAgentEntity.getFillingOrg()) && ObjectUtil.isNotNull((Object)(sysOrgEntity = this.sysOrgService.queryObject(dgsFillingTaskAgentEntity.getFillingOrg()))) && StrUtil.isNotBlank((CharSequence)sysOrgEntity.getSysOrgName())) {
                                    orgName = sysOrgEntity.getSysOrgName();
                                }
                                cellObj.put("cellData", (Object)orgName);
                                break;
                            }
                            case "TASK_OPERATION_TIME": {
                                cellObj.put("cellData", (Object)dateFormat.format(new Date()));
                                break;
                            }
                        }
                    }
                }
                ok.put("formConfig", (Object)jsonObject.toJSONString());
            } else {
                ok.put("formConfig", null);
            }
            ok.put("formData", null);
        }
        return ok;
    }

    @Override
    public void report(Map<String, Object> params) throws Exception {
        String orgCode = MapUtil.getStr(params, (Object)"orgCode");
        String periodType = MapUtil.getStr(params, (Object)"periodType");
        String batchDate = MapUtil.getStr(params, (Object)"batchDate");
        String companyType = MapUtil.getStr(params, (Object)"companyType");
        String userName = MapUtil.getStr(params, (Object)"userName");
        String telephone = MapUtil.getStr(params, (Object)"telephone");
        Map formDataMap = (Map)MapUtil.get(params, (Object)"formData", Map.class);
        Assert.isBlank((String)orgCode, (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u5355\u4f4d\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isBlank((String)periodType, (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u586b\u62a5\u5468\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isBlank((String)batchDate, (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u586b\u62a5\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNull((Object)formDataMap, (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u586b\u62a5\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        SysOrgEntity sysOrgEntity = this.sysOrgService.queryByCode(orgCode);
        Assert.isNull((Object)sysOrgEntity, (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u5355\u4f4d\u673a\u6784\u7f16\u53f7\u9519\u8bef");
        List<DgsFillingTaskInfoEntity> taskInfoList = this.dgsFillingTaskInfoDao.getListByOrgCodeAndBatchDate(orgCode, batchDate);
        if (CollUtil.isEmpty(taskInfoList)) {
            Assert.isFalse((boolean)false, (String)("\u5f53\u524d\u673a\u6784\u3010" + orgCode + "\u3011\u3010" + sysOrgEntity.getSysOrgName() + "\u3011\u6279\u6b21\u3010" + batchDate + "\u3011\u6ca1\u6709\u586b\u62a5\u4efb\u52a1"));
        }
        FillingProcessDrivenManager fillingProcessDrivenManager = FillingProcessDrivenManager.build(taskInfoList.get(0), this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoList.get(0).getId()));
        String rouleCode = "";
        String periodTypeName = "";
        if (StrUtil.equals((CharSequence)"1", (CharSequence)periodType)) {
            periodTypeName = "\u5b63\u62a5";
            rouleCode = FillingEventNotification.valueTaking(fillingProcessDrivenManager, FillingEventNotification.ListenerType.getQuarterlyReportRuleCode);
        } else if (StrUtil.equals((CharSequence)"2", (CharSequence)periodType)) {
            periodTypeName = "\u6708\u62a5";
            rouleCode = FillingEventNotification.valueTaking(fillingProcessDrivenManager, FillingEventNotification.ListenerType.getMonthlyReportRuleCode);
        } else {
            Assert.isFalse((boolean)false, (String)"\u586b\u62a5\u5468\u671f\u7c7b\u578b\u53c2\u6570\u5f02\u5e38\uff0c\u65e0\u6cd5\u8bc6\u522b");
        }
        DgsFillingTaskInfoEntity dgsFillingTaskInfo = this.dgsFillingTaskInfoDao.getInfoByOrgCodeAndRuleCode(orgCode, rouleCode, batchDate);
        Assert.isNull((Object)dgsFillingTaskInfo, (String)("\u5f53\u524d\u673a\u6784\u3010" + orgCode + "\u3011\u3010" + sysOrgEntity.getSysOrgName() + "\u3011\u586b\u62a5\u7c7b\u578b\u3010" + periodTypeName + "\u3011\u6279\u6b21\u3010" + batchDate + "\u3011\u6ca1\u6709\u586b\u62a5\u4efb\u52a1"));
        DgsFillingTaskAgentEntity dgsFillingTaskAgentEntity = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(dgsFillingTaskInfo.getId());
        Long status = dgsFillingTaskAgentEntity.getStatus();
        if (status != 0L && status != 4L) {
            Assert.isFalse((boolean)false, (String)("\u5f53\u524d\u673a\u6784\u3010" + orgCode + "\u3011\u3010" + sysOrgEntity.getSysOrgName() + "\u3011\u586b\u62a5\u7c7b\u578b\u3010" + periodTypeName + "\u3011\u6279\u6b21\u3010" + batchDate + "\u3011\u4efb\u52a1\u5df2\u586b\u62a5\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4"));
        }
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(dgsFillingTaskInfo.getId());
        Assert.isNull((Object)dgsFillingRuleInfoEntity, (String)("\u5f53\u524d\u586b\u62a5\u7c7b\u578b\u3010" + periodTypeName + "\u3011\u6279\u6b21\u3010" + batchDate + "\u3011\u4efb\u52a1\u672a\u8bbe\u7f6e\u586b\u62a5\u89c4\u5219\uff0c\u4efb\u52a1ID\u4e3a\uff1a" + dgsFillingTaskInfo.getId()));
        String formConfig = dgsFillingRuleInfoEntity.getFormConfig();
        String formData = this.getFormData(formConfig, formDataMap);
        DgsFillingFormInfoBo dgsFillingFormInfoBo = new DgsFillingFormInfoBo();
        dgsFillingFormInfoBo.setTaskInfoId(dgsFillingTaskInfo.getId());
        dgsFillingFormInfoBo.setStatus(1L);
        dgsFillingFormInfoBo.setFormData(formData);
        dgsFillingFormInfoBo.setPeriodType(periodType);
        dgsFillingFormInfoBo.setBatchDate(batchDate);
        dgsFillingFormInfoBo.setOrgCode(orgCode);
        dgsFillingFormInfoBo.setCompanyType(companyType);
        if (StrUtil.isNotBlank((CharSequence)userName)) {
            dgsFillingFormInfoBo.setUserName(userName);
        }
        dgsFillingFormInfoBo.setTelephone(telephone);
        DgsFillingFormInfoEntity dgsFillingFormInfoEntity = this.dgsFillingFormInfoDao.queryObjectByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId());
        if (ObjectUtil.isNotNull((Object)dgsFillingFormInfoEntity) && StrUtil.isNotBlank((CharSequence)dgsFillingFormInfoEntity.getId())) {
            dgsFillingFormInfoBo.setId(dgsFillingFormInfoEntity.getId());
            this.update(dgsFillingFormInfoBo);
        } else {
            this.save(dgsFillingFormInfoBo);
        }
        DgsFillingFormInfoEntity dgsFillingFormInfo = new DgsFillingFormInfoEntity();
        BeanUtil.copyProperties((Object)dgsFillingFormInfoBo, (Object)dgsFillingFormInfo, (String[])new String[0]);
        FillingProcessDrivenManager manager = FillingProcessDrivenManager.build(dgsFillingTaskInfo, dgsFillingRuleInfoEntity, dgsFillingFormInfo, dgsFillingTaskAgentEntity);
        FillingEventNotification.notice(manager, FillingEventNotification.ListenerType.beforePageRender);
        FillingEventNotification.notice(manager, FillingEventNotification.ListenerType.beforeTaskFilling);
        String fillingConfig = dgsFillingRuleInfoEntity.getFillingConfig();
        FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject((String)fillingConfig, FillingConfigBo.class);
        String completionMode = fillingConfigBo.getProcessConfig().getCompletionMode();
        if (StrUtil.equals((CharSequence)completionMode, (CharSequence)"1")) {
            this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId(), 1L);
            this.auditRecord(dgsFillingFormInfoBo.getTaskInfoId(), "0", dgsFillingFormInfoBo.getTelephone());
        } else {
            DgsFillingTaskAgentEntity fillingTaskAgentEntity = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId());
            if (ObjectUtil.isNotNull((Object)fillingTaskAgentEntity.getAuditOrg())) {
                this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId(), 2L);
                this.auditRecord(dgsFillingFormInfoBo.getTaskInfoId(), "1", dgsFillingFormInfoBo.getTelephone());
            } else {
                this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId(), 1L);
                this.auditRecord(dgsFillingFormInfoBo.getTaskInfoId(), "0", dgsFillingFormInfoBo.getTelephone());
            }
        }
        JSONArray jsonArray = JSON.parseArray((String)dgsFillingFormInfoBo.getFormData());
        List collect = jsonArray.stream().filter(e -> {
            JSONObject jsonObject = (JSONObject)e;
            boolean dataCollection = jsonObject.containsKey((Object)"dataCollection");
            return dataCollection;
        }).collect(Collectors.toList());
        if (ObjectUtil.isNotNull(collect) && collect.size() > 0) {
            String collectionId = fillingConfigBo.getSummaryConfig().getCollectionId();
            DgsDcmCollectionEntity dgsDcmCollectionEntity = (DgsDcmCollectionEntity)this.dgsDcmCollectionDao.queryObject((Object)collectionId);
            String tableName = "DGS_T_" + dgsDcmCollectionEntity.getTableCode();
            DgsFillingTaskExpandEntity dgsFillingTaskExpandEntity = this.dgsFillingTaskExpandDao.queryByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId());
            List fieldTypes = collect.stream().map(e -> {
                JSONObject jsonObject = (JSONObject)e;
                String column = jsonObject.getJSONObject("dataCollection").getString("fieldType");
                return column;
            }).collect(Collectors.toList());
            if (ObjectUtil.isNull((Object)dgsFillingTaskExpandEntity)) {
                List columns = collect.stream().map(e -> {
                    JSONObject jsonObject = (JSONObject)e;
                    String column = jsonObject.getJSONObject("dataCollection").getString("fieldCode");
                    return column;
                }).collect(Collectors.toList());
                List values = collect.stream().map(e -> {
                    JSONObject jsonObject = (JSONObject)e;
                    String value = jsonObject.getString("cellData");
                    return value;
                }).collect(Collectors.toList());
                StringBuffer buffer = new StringBuffer();
                buffer.append("INSERT INTO ").append(tableName).append(" (");
                buffer.append("ID,");
                for (int i = 0; i < columns.size(); ++i) {
                    buffer.append((String)columns.get(i)).append(",");
                }
                String collectionUuId = UUID.randomUUID().toString().replace("-", "");
                buffer.append("CREATED_TIME, UPDATED_TIME, DATA_STATUS, QUALITY_DATA_STATUS, BUSINESS_DATA_STATUS) VALUES ('").append(collectionUuId).append("',");
                for (int i = 0; i < values.size(); ++i) {
                    String fieldType = (String)fieldTypes.get(i);
                    if (StrUtil.equals((CharSequence)"date", (CharSequence)fieldType)) {
                        String value = (String)values.get(i);
                        if (this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2}")) {
                            value = value + " 00:00:00";
                        }
                        Assert.isFalse((boolean)this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}"), (String)("\u65f6\u95f4\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5b57\u6bb5\u4e3a\uff1a" + (String)columns.get(i)));
                        buffer.append("to_date('").append(value).append("','YYYY-MM-DD HH24:MI:SS')").append(",");
                        continue;
                    }
                    buffer.append("'").append((String)values.get(i)).append("'").append(",");
                }
                buffer.append("SYSDATE,null,'0','2','0')");
                this.customDao.executeCustomInsert(buffer.toString());
                DgsFillingTaskExpandEntity taskExpandEntity = new DgsFillingTaskExpandEntity();
                taskExpandEntity.setId(UUID.randomUUID().toString().replace("-", ""));
                taskExpandEntity.setTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId());
                taskExpandEntity.setCollectionId(collectionUuId);
                taskExpandEntity.setCreatedTime(new Date());
                this.dgsFillingTaskExpandDao.save(taskExpandEntity);
            } else {
                StringBuffer buffer = new StringBuffer();
                buffer.append("UPDATE ").append(tableName).append(" SET ");
                for (int i = 0; i < collect.size(); ++i) {
                    String fieldType = (String)fieldTypes.get(i);
                    JSONObject jsonObject = (JSONObject)collect.get(i);
                    String column = jsonObject.getJSONObject("dataCollection").getString("fieldCode");
                    String value = jsonObject.getString("cellData");
                    buffer.append(column).append("=");
                    if (StrUtil.equals((CharSequence)"date", (CharSequence)fieldType)) {
                        if (this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2}")) {
                            value = value + " 00:00:00";
                        }
                        Assert.isFalse((boolean)this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}"), (String)("\u65f6\u95f4\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5b57\u6bb5\u4e3a\uff1a" + column));
                        buffer.append("to_date('").append(value).append("','YYYY-MM-DD HH24:MI:SS')").append(",");
                        continue;
                    }
                    buffer.append("'").append(value).append("'").append(",");
                }
                buffer.append("UPDATED_TIME=SYSDATE").append(" WHERE ID='").append(dgsFillingTaskExpandEntity.getCollectionId()).append("'");
                this.customDao.executeCustomUpdate(buffer.toString());
            }
        }
    }

    @Override
    public void formWithdraw(String taskInfoId, String userId) {
        this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, 0L);
        this.auditRecord(userId, taskInfoId, "4", "", "");
    }

    private void auditRecord(String userId, String taskInfoId, String operator, String operatorContent, String opinionContent) {
        SysOrgEntity sysOrgEntity = this.sysOrgService.queryByUserId(userId);
        Assert.isNull((Object)sysOrgEntity, (String)"\u5f53\u524d\u767b\u9646\u7528\u6237\u672a\u627e\u5230\u5173\u8054\u7ec4\u7ec7");
        DgsFillingAuditRecordEntity dgsFillingAuditRecordEntity = new DgsFillingAuditRecordEntity();
        dgsFillingAuditRecordEntity.setId(UuidUtil.get32UUID());
        dgsFillingAuditRecordEntity.setTaskInfoId(taskInfoId);
        dgsFillingAuditRecordEntity.setTaskNode(sysOrgEntity.getId());
        dgsFillingAuditRecordEntity.setOperatorUserId(userId);
        dgsFillingAuditRecordEntity.setRecordTime(new Date());
        switch (operator) {
            case "0": {
                dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank((CharSequence)operatorContent) ? "\u63d0\u4ea4\u5b8c\u6210" : operatorContent);
                dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank((CharSequence)opinionContent) ? "\u6570\u636e\u63d0\u4ea4" : opinionContent);
                break;
            }
            case "1": {
                dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank((CharSequence)operatorContent) ? "\u63d0\u4ea4\u4efb\u52a1" : operatorContent);
                dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank((CharSequence)opinionContent) ? "\u63d0\u4ea4\u672c\u5355\u4f4d\u6570\u636e,\u8bf7\u4e0a\u7ea7\u90e8\u95e8\u5ba1\u6838" : opinionContent);
                break;
            }
            case "2": {
                dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank((CharSequence)operatorContent) ? "\u901a\u8fc7\u4efb\u52a1" : operatorContent);
                dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank((CharSequence)opinionContent) ? "\u540c\u610f\u63a5\u6536" : opinionContent);
                break;
            }
            case "3": {
                dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank((CharSequence)operatorContent) ? "\u9000\u56de\u4efb\u52a1" : operatorContent);
                dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank((CharSequence)opinionContent) ? "\u4e0d\u540c\u610f\u63a5\u6536" : opinionContent);
                break;
            }
            case "4": {
                dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank((CharSequence)operatorContent) ? "\u64a4\u56de\u586b\u62a5" : operatorContent);
                dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank((CharSequence)opinionContent) ? "\u64a4\u56de\u586b\u62a5\u4efb\u52a1" : opinionContent);
                break;
            }
            case "5": {
                dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank((CharSequence)operatorContent) ? "\u5ba1\u6838\u9a73\u56de" : operatorContent);
                dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank((CharSequence)opinionContent) ? "\u53d6\u6d88\u63a5\u6536" : opinionContent);
                break;
            }
            default: {
                throw new RRException("\u5ba1\u6838\u64cd\u4f5c\u6dfb\u52a0\u5931\u8d25");
            }
        }
        this.dgsFillingAuditRecordDao.save(dgsFillingAuditRecordEntity);
    }

    private void auditRecord(String taskInfoId, String operator, String telephone) {
        SysUserEntity sysUserEntity = this.userService.queryByMobile(telephone);
        Assert.isNull((Object)sysUserEntity, (String)String.format("\u672a\u627e\u5230\u5f53\u524d\u586b\u62a5\u4eba\u624b\u673a\u53f7\u3010%s\u3011\u7684\u7528\u6237\u4fe1\u606f", telephone));
        SysOrgEntity sysOrgEntity = this.sysOrgService.queryByUserId(sysUserEntity.getUserId());
        Assert.isNull((Object)sysOrgEntity, (String)String.format("\u5f53\u524d\u586b\u62a5\u4eba\u624b\u673a\u53f7\u3010%s\u3011\u7684\u7528\u6237\u672a\u5173\u8054\u7ec4\u7ec7", telephone));
        DgsFillingAuditRecordEntity dgsFillingAuditRecordEntity = new DgsFillingAuditRecordEntity();
        dgsFillingAuditRecordEntity.setId(UuidUtil.get32UUID());
        dgsFillingAuditRecordEntity.setTaskInfoId(taskInfoId);
        dgsFillingAuditRecordEntity.setTaskNode(sysOrgEntity.getId());
        dgsFillingAuditRecordEntity.setOperatorUserId(sysUserEntity.getUserId());
        dgsFillingAuditRecordEntity.setRecordTime(new Date());
        switch (operator) {
            case "0": {
                dgsFillingAuditRecordEntity.setOperatorContent("\u63d0\u4ea4\u5b8c\u6210");
                dgsFillingAuditRecordEntity.setOpinionContent("\u6570\u636e\u63d0\u4ea4");
                break;
            }
            case "1": {
                dgsFillingAuditRecordEntity.setOperatorContent("\u63d0\u4ea4\u4efb\u52a1");
                dgsFillingAuditRecordEntity.setOpinionContent("\u5bf9\u63a5\u63d0\u4ea4\u672c\u5355\u4f4d\u6570\u636e,\u8bf7\u4e0a\u7ea7\u90e8\u95e8\u5ba1\u6838");
                break;
            }
            case "2": {
                dgsFillingAuditRecordEntity.setOperatorContent("\u901a\u8fc7\u4efb\u52a1");
                dgsFillingAuditRecordEntity.setOpinionContent("\u540c\u610f\u63a5\u6536");
                break;
            }
            case "3": {
                dgsFillingAuditRecordEntity.setOperatorContent("\u9000\u56de\u4efb\u52a1");
                dgsFillingAuditRecordEntity.setOpinionContent("\u4e0d\u540c\u610f\u63a5\u6536");
                break;
            }
            case "4": {
                dgsFillingAuditRecordEntity.setOperatorContent("\u64a4\u56de\u586b\u62a5");
                dgsFillingAuditRecordEntity.setOpinionContent("\u64a4\u56de\u586b\u62a5\u4efb\u52a1");
                break;
            }
            case "5": {
                dgsFillingAuditRecordEntity.setOperatorContent("\u5ba1\u6838\u9a73\u56de");
                dgsFillingAuditRecordEntity.setOpinionContent("\u53d6\u6d88\u63a5\u6536");
                break;
            }
            default: {
                throw new RRException("\u5ba1\u6838\u64cd\u4f5c\u6dfb\u52a0\u5931\u8d25");
            }
        }
        this.dgsFillingAuditRecordDao.save(dgsFillingAuditRecordEntity);
    }

    private boolean isDateTimeValid(String input, String format) {
        Pattern pattern = Pattern.compile(format);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    private void save(DgsFillingFormInfoBo dgsFillingFormInfoBo) throws Exception {
        DgsRsaUserInfo rsaUserInfo = (DgsRsaUserInfo)BeanUtil.copyProperties((Object)dgsFillingFormInfoBo, DgsRsaUserInfo.class, (String[])new String[0]);
        ValidatorUtils.validateEntity((Object)rsaUserInfo, (Class[])new Class[0]);
        SysUserEntity sysUserEntity = this.syncUserCheck(rsaUserInfo);
        dgsFillingFormInfoBo.setId(UuidUtil.get32UUID());
        dgsFillingFormInfoBo.setFillingUserId(sysUserEntity.getUserId());
        DgsFillingFormInfoEntity dgsFillingFormInfoEntity = (DgsFillingFormInfoEntity)BeanUtil.copyProperties((Object)dgsFillingFormInfoBo, DgsFillingFormInfoEntity.class, (String[])new String[0]);
        this.dgsFillingFormInfoDao.save(dgsFillingFormInfoEntity);
    }

    private void update(DgsFillingFormInfoBo dgsFillingFormInfoBo) throws Exception {
        DgsRsaUserInfo rsaUserInfo = (DgsRsaUserInfo)BeanUtil.copyProperties((Object)dgsFillingFormInfoBo, DgsRsaUserInfo.class, (String[])new String[0]);
        ValidatorUtils.validateEntity((Object)rsaUserInfo, (Class[])new Class[0]);
        SysUserEntity sysUserEntity = this.syncUserCheck(rsaUserInfo);
        dgsFillingFormInfoBo.setFillingUserId(sysUserEntity.getUserId());
        DgsFillingFormInfoEntity dgsFillingFormInfoEntity = (DgsFillingFormInfoEntity)BeanUtil.copyProperties((Object)dgsFillingFormInfoBo, DgsFillingFormInfoEntity.class, (String[])new String[0]);
        this.dgsFillingFormInfoDao.update(dgsFillingFormInfoEntity);
    }

    private String getFormData(String formConfig, Map<String, Object> formData) {
        List contrast;
        JSONObject jsonObject = JSONObject.parseObject((String)formConfig);
        if (!jsonObject.containsKey((Object)"cell")) {
            Assert.isFalse((boolean)false, (String)"\u8868\u5355\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        JSONArray cell = jsonObject.getJSONArray("cell");
        List dataCollectionArr = cell.stream().filter(j -> JSONObject.parseObject((String)JSON.toJSONString((Object)j)).containsKey((Object)"dataCollection")).collect(Collectors.toList());
        List fieldCodeArr = dataCollectionArr.stream().map(j -> JSONObject.parseObject((String)JSON.toJSONString((Object)j)).getJSONObject("dataCollection").getString("fieldCode")).collect(Collectors.toList());
        ArrayList<String> keys = new ArrayList<String>(formData.keySet());
        List difference = keys.stream().filter(element -> !fieldCodeArr.contains(element)).collect(Collectors.toList());
        if (difference.size() > 0) {
            Assert.isFalse((boolean)false, (String)("\u53c2\u6570\u5f02\u5e38\uff0c\u8868\u5355\u6570\u636e\u6620\u5c04\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u591a\u51fa\u5185\u5bb9\uff1a" + JSON.toJSONString(difference)));
        }
        if ((contrast = fieldCodeArr.stream().filter(element -> !keys.contains(element)).collect(Collectors.toList())).size() > 0) {
            Assert.isFalse((boolean)false, (String)("\u53c2\u6570\u5f02\u5e38\uff0c\u8868\u5355\u6570\u636e\u6620\u5c04\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u7f3a\u5931\u5185\u5bb9\uff1a" + JSON.toJSONString(contrast)));
        }
        if (dataCollectionArr.size() != formData.size()) {
            Assert.isFalse((boolean)false, (String)String.format("\u53c2\u6570\u5f02\u5e38\uff0c\u8868\u5355\u6570\u636e\u6620\u5c04\u5b57\u6bb5\u957f\u5ea6\u4e0d\u7b26:\u8868\u5355\u6570\u636e\u957f\u5ea6\uff1a" + dataCollectionArr.size() + ",\u5b9e\u9645\u63d0\u4ea4\u6570\u636e\u957f\u5ea6\uff1a" + formData.size() + "", new Object[0]));
        }
        JSONArray objects = new JSONArray();
        for (Object o : cell) {
            JSONObject cellObj = JSONObject.parseObject((String)JSON.toJSONString(o));
            if (cellObj.containsKey((Object)"dataCollection")) {
                String cellData = MapUtil.getStr(formData, (Object)cellObj.getJSONObject("dataCollection").getString("fieldCode"));
                Assert.isBlank((String)cellData, (String)("\u53c2\u6570\u5f02\u5e38\uff0c\u8868\u5355\u586b\u62a5\u6570\u636e\u5b57\u6bb5\u3010" + cellObj.getJSONObject("dataCollection").getString("fieldCode") + "\u3011\u4e0d\u80fd\u4e3a\u7a7a"));
                cellObj.put("cellData", (Object)cellData);
            }
            objects.add((Object)cellObj);
        }
        return JSON.toJSONString((Object)objects);
    }

    private SysUserEntity syncUserCheck(DgsRsaUserInfo rsaUserInfo) {
        SysOrgEntity sysOrgEntity = this.sysOrgService.queryByCode(rsaUserInfo.getOrgCode());
        cn.hutool.core.lang.Assert.notNull((Object)sysOrgEntity, () -> new RRException(JSON.toJSONString((Object)R.error((int)400, (String)"\u9519\u8bef\u7684\u5355\u4f4d\u673a\u6784\u7f16\u53f7")), 400));
        SysUserEntity sysUserEntity = this.userService.queryByMobile(rsaUserInfo.getTelephone());
        if (Objects.nonNull(sysUserEntity)) {
            SysOrgEntity sysOrg = this.sysOrgUserService.getOrgByUserId(sysUserEntity.getUserId());
            if (ObjectUtil.isNotNull((Object)sysOrg) && !sysOrg.getId().equals(sysOrgEntity.getId())) {
                throw new RRException("\u624b\u673a\u53f7" + rsaUserInfo.getTelephone() + "\u5df2\u7ed1\u5b9a\u673a\u6784\u3010" + sysOrg.getSysOrgName() + "\u3011\u8bf7\u66f4\u6362\u624b\u673a\u53f7", 400);
            }
            return sysUserEntity;
        }
        SysUserEntity userEntity = new SysUserEntity();
        userEntity.setUserId(UuidUtil.get32UUID());
        userEntity.setUsernickname(StrUtil.isBlank((CharSequence)rsaUserInfo.getUserName()) ? rsaUserInfo.getTelephone() : rsaUserInfo.getUserName());
        userEntity.setUsername(rsaUserInfo.getTelephone());
        userEntity.setMobile(rsaUserInfo.getTelephone());
        userEntity.setSortNum(Integer.valueOf(1));
        userEntity.setStatus(Integer.valueOf(1));
        Map userMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)userEntity), Map.class);
        userMap.put("orgId", sysOrgEntity.getId());
        userMap.put("password", "123-!@#");
        this.userService.save(userMap);
        return userEntity;
    }

    @Override
    public void formReject(String taskInfoId, String userId) {
        DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(taskInfoId);
        DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
        FillingProcessDrivenManager build = FillingProcessDrivenManager.build(dgsFillingTaskInfoEntity, dgsFillingRuleInfoEntity);
        FillingEventNotification.notice(build, FillingEventNotification.ListenerType.beforeTaskReject);
        this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, 2L);
        this.auditRecord(userId, taskInfoId, "5", "", "");
        FillingEventNotification.notice(build, FillingEventNotification.ListenerType.behindTaskReject);
    }
}

