/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.form.controller;

import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.dgs.filling.form.entity.DgsFillingFormInfoEntity;
import xyz.yuanjilu.dgs.filling.form.service.IDgsFillingFormInfoService;
import xyz.yuanjilu.system.utils.ShiroUtils;

@RestController
@RequestMapping(value={"dgs/filling/form"})
public class DgsFillingFormInfoController {
    @Autowired
    private IDgsFillingFormInfoService dgsFillingFormInfoService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"dgs:filling:form:list"})
    public R list(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        List<DgsFillingFormInfoEntity> dgsFillingFormInfoList = this.dgsFillingFormInfoService.queryList((Map<String, Object>)query);
        int total = this.dgsFillingFormInfoService.queryTotal((Map<String, Object>)query);
        PageUtils pageUtil = new PageUtils(dgsFillingFormInfoList, total, query.getLimit(), query.getPage());
        return R.ok().put("page", (Object)pageUtil);
    }

    @GetMapping(value={"/info/{id}"})
    @RequiresPermissions(value={"dgs:filling:form:info"})
    public R info(@PathVariable(value="id") String id) {
        DgsFillingFormInfoEntity dgsFillingFormInfo = this.dgsFillingFormInfoService.queryObject(id);
        return R.ok().put("dgsFillingFormInfo", (Object)dgsFillingFormInfo);
    }

    @SysLog(value="\u4fdd\u5b58\u8868\u5355\u586b\u62a5\u4fe1\u606f\u8868")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"dgs:filling:form:save"})
    public R save(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
        this.dgsFillingFormInfoService.save(dgsFillingFormInfo, ShiroUtils.getUserId());
        return R.ok();
    }

    @SysLog(value="\u4fee\u6539\u8868\u5355\u586b\u62a5\u4fe1\u606f\u8868")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"dgs:filling:form:update"})
    public R update(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
        this.dgsFillingFormInfoService.update(dgsFillingFormInfo, ShiroUtils.getUserId());
        return R.ok();
    }

    @SysLog(value="\u903b\u8f91\u5220\u9664\u8868\u5355\u586b\u62a5\u4fe1\u606f\u8868")
    @PostMapping(value={"/updateDelStatusBatch"})
    @RequiresPermissions(value={"dgs:filling:form:delete"})
    public R updateDelStatusBatch(@RequestBody String[] ids) {
        this.dgsFillingFormInfoService.updateDelStatusBatch(ids);
        return R.ok();
    }

    @SysLog(value="\u7269\u7406\u5220\u9664\u8868\u5355\u586b\u62a5\u4fe1\u606f\u8868")
    @PostMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"dgs:filling:form:delete"})
    public R deleteBatch(@RequestBody String[] ids) {
        this.dgsFillingFormInfoService.deleteBatch(ids);
        return R.ok();
    }

    @SysLog(value="\u4fdd\u5b58\u6216\u4fee\u6539\u8868\u5355\u586b\u62a5\u4fe1\u606f\u8868")
    @PostMapping(value={"/saveOrUpdate"})
    @RequiresPermissions(value={"dgs:filling:form:fillInTheReport"})
    public R saveOrUpdate(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
        this.dgsFillingFormInfoService.saveOrUpdate(dgsFillingFormInfo, ShiroUtils.getUserId());
        return R.ok();
    }

    @GetMapping(value={"/infoByTaskInfoId"})
    @RequiresPermissions(value={"dgs:filling:form:info"})
    public R infoByTaskInfoId(@RequestParam(value="taskInfoId") String taskInfoId) {
        return this.dgsFillingFormInfoService.infoByTaskInfoId(taskInfoId, ShiroUtils.getUserEntity());
    }

    @PostMapping(value={"/formReview"})
    @RequiresPermissions(value={"dgs:filling:form:formReview"})
    public R formReview(@RequestBody Map<String, Object> params) {
        params.put("userId", ShiroUtils.getUserId());
        this.dgsFillingFormInfoService.formReview(params);
        return R.ok();
    }

    @GetMapping(value={"/formWithdraw"})
    @RequiresPermissions(value={"dgs:filling:form:formWithdraw"})
    public R formWithdraw(@RequestParam(value="taskInfoId") String taskInfoId) {
        this.dgsFillingFormInfoService.formWithdraw(taskInfoId, ShiroUtils.getUserId());
        return R.ok();
    }

    @GetMapping(value={"/formReject"})
    @RequiresPermissions(value={"dgs:filling:form:formReject"})
    public R formReject(@RequestParam(value="taskInfoId") String taskInfoId) {
        this.dgsFillingFormInfoService.formReject(taskInfoId, ShiroUtils.getUserId());
        return R.ok();
    }
}

