/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.form.api;

import cn.hutool.core.map.MapUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.filling.common.util.RSAUtils;
import xyz.yuanjilu.dgs.filling.form.entity.DgsFillingFormInfoEntity;
import xyz.yuanjilu.dgs.filling.form.service.IDgsFillingFormInfoService;
import xyz.yuanjilu.system.utils.ShiroUtils;

@RestController
@RequestMapping(value={"api/dgs/filling/form"})
public class ApiDgsFillingFormInfoController {
    @Autowired
    private IDgsFillingFormInfoService dgsFillingFormInfoService;

    @GetMapping(value={"/list"})
    public R list(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        List<DgsFillingFormInfoEntity> dgsFillingFormInfoList = this.dgsFillingFormInfoService.queryList((Map<String, Object>)query);
        int total = this.dgsFillingFormInfoService.queryTotal((Map<String, Object>)query);
        PageUtils pageUtil = new PageUtils(dgsFillingFormInfoList, total, query.getLimit(), query.getPage());
        return R.ok().put("page", (Object)pageUtil);
    }

    @GetMapping(value={"/info/{id}"})
    public R info(@PathVariable(value="id") String id) {
        DgsFillingFormInfoEntity dgsFillingFormInfo = this.dgsFillingFormInfoService.queryObject(id);
        return R.ok().put("dgsFillingFormInfo", (Object)dgsFillingFormInfo);
    }

    @SysLog(value="\u4fee\u6539\u8868\u5355\u586b\u62a5\u4fe1\u606f\u8868")
    @PostMapping(value={"/save"})
    public R save(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
        this.dgsFillingFormInfoService.save(dgsFillingFormInfo, ShiroUtils.getUserId());
        return R.ok();
    }

    @SysLog(value="\u4fee\u6539\u8868\u5355\u586b\u62a5\u4fe1\u606f\u8868")
    @PostMapping(value={"/update"})
    public R update(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
        this.dgsFillingFormInfoService.update(dgsFillingFormInfo, ShiroUtils.getUserId());
        return R.ok();
    }

    @SysLog(value="\u903b\u8f91\u5220\u9664\u8868\u5355\u586b\u62a5\u4fe1\u606f\u8868")
    @PostMapping(value={"/updateDelStatusBatch"})
    public R updateDelStatusBatch(@RequestBody String[] ids) {
        this.dgsFillingFormInfoService.updateDelStatusBatch(ids);
        return R.ok();
    }

    @SysLog(value="\u7269\u7406\u5220\u9664\u8868\u5355\u586b\u62a5\u4fe1\u606f\u8868")
    @PostMapping(value={"/deleteBatch"})
    public R deleteBatch(@RequestBody String[] ids) {
        this.dgsFillingFormInfoService.deleteBatch(ids);
        return R.ok();
    }

    @SysLog(value="\u4efb\u52a1\u586b\u62a5\u63a5\u53e3\u63d0\u4ea4")
    @PostMapping(value={"/report"})
    public R report(@RequestBody Map<String, Object> params) throws Exception {
        String data = MapUtil.getStr(params, (Object)"data");
        Assert.isNull((Object)data, (String)"\u53c2\u6570\u5f02\u5e38\uff0cdata\u4e0d\u80fd\u4e3a\u7a7a");
        Map decryptParams = RSAUtils.decryptParseData(data, Map.class, KeyType.PublicKey);
        this.dgsFillingFormInfoService.report(decryptParams);
        return R.ok();
    }
}

