/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.common.util;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import xyz.yuanjilu.common.service.SysConfigService;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.validator.Assert;

public class RSAUtils {
    private static String publicKey;
    private static String privateKey;

    public static String getPrivateKey() {
        String rsaConfig = ((SysConfigService)SpringUtil.getBean(SysConfigService.class)).getValue("RSA_CONFIG", "");
        JSONObject jsonObject = JSON.parseObject((String)rsaConfig);
        privateKey = jsonObject.getString("RSA_PRIVATE_KEY");
        return privateKey;
    }

    public static String getPublicKey() {
        String rsaConfig = ((SysConfigService)SpringUtil.getBean(SysConfigService.class)).getValue("RSA_CONFIG", "");
        JSONObject jsonObject = JSON.parseObject((String)rsaConfig);
        publicKey = jsonObject.getString("RSA_PUBLIC_KEY");
        return publicKey;
    }

    public static String encryptPrivate(String data) {
        Assert.isBlank((String)data, (String)"\u53c2\u6570\u5f02\u5e38: data\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        RSA rsa = new RSA(RSAUtils.getPrivateKey(), null);
        return rsa.encryptBase64(data, CharsetUtil.CHARSET_UTF_8, KeyType.PrivateKey);
    }

    public static String encryptPublic(String data) {
        Assert.isBlank((String)data, (String)"\u53c2\u6570\u5f02\u5e38: data\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        RSA rsa = new RSA(null, RSAUtils.getPublicKey());
        return rsa.encryptBase64(data, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
    }

    public static String decryptPrivate(String data) {
        Assert.isBlank((String)data, (String)"\u53c2\u6570\u5f02\u5e38: data\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        RSA rsa = new RSA(RSAUtils.getPrivateKey(), null);
        return rsa.decryptStr(data, KeyType.PrivateKey, CharsetUtil.CHARSET_UTF_8);
    }

    public static String decryptPublic(String data) {
        Assert.isBlank((String)data, (String)"\u53c2\u6570\u5f02\u5e38: data\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        RSA rsa = new RSA(null, RSAUtils.getPublicKey());
        return rsa.decryptStr(data, KeyType.PublicKey, CharsetUtil.CHARSET_UTF_8);
    }

    public static <T> T decryptParseData(String data, Class<T> clazz, KeyType keyType) {
        Assert.isBlank((String)data, (String)"\u53c2\u6570\u5f02\u5e38: data\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        String decryptedData = null;
        if (keyType == KeyType.PrivateKey) {
            decryptedData = RSAUtils.decryptPrivate(data);
        } else if (keyType == KeyType.PublicKey) {
            decryptedData = RSAUtils.decryptPublic(data);
        }
        boolean typeJSON = JSONUtil.isTypeJSON((String)decryptedData);
        if (!typeJSON) {
            throw new RRException(JSON.toJSONString((Object)R.error((int)400, (String)"\u53c2\u6570\u5f02\u5e38")), 400);
        }
        return (T)JSON.parseObject((String)decryptedData, clazz);
    }
}

