/*
 * Decompiled with CFR 0.152.
 */
package xyz.yuanjilu.dgs.filling.common.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgTreeNode;

public class FillingOrgUtil {
    public static List<FillingOrgTreeNode> getFillingOrgNodes(String orgTree) {
        Assert.isBlank((String)orgTree, (String)"\u89c4\u5219\u914d\u7f6e\u4e2d\u7684\u5355\u4f4d\u7ed3\u6784\u6811\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        LinkedList<FillingOrgTreeNode> resultArr = new LinkedList<FillingOrgTreeNode>();
        List fillingOrgTreeNodes = JSON.parseArray((String)orgTree, FillingOrgTreeNode.class);
        FillingOrgUtil.addResultArr(fillingOrgTreeNodes, resultArr);
        return resultArr;
    }

    public static String getParentOrgId(String orgTree, String orgId) {
        List<FillingOrgTreeNode> fillingOrgNodes = FillingOrgUtil.getFillingOrgNodes(orgTree);
        Optional<FillingOrgTreeNode> first = fillingOrgNodes.stream().filter(f -> StrUtil.equals((CharSequence)orgId, (CharSequence)f.getOrgId())).findFirst();
        if (first.isPresent()) {
            FillingOrgTreeNode fillingOrgTreeNode = first.get();
            return fillingOrgTreeNode.getPid();
        }
        return null;
    }

    public static FillingOrgTreeNode getParentOrg(String orgTree, String orgId) {
        List<FillingOrgTreeNode> fillingOrgNodes = FillingOrgUtil.getFillingOrgNodes(orgTree);
        Optional<FillingOrgTreeNode> first = fillingOrgNodes.stream().filter(f -> StrUtil.equals((CharSequence)orgId, (CharSequence)f.getOrgId())).findFirst();
        if (first.isPresent()) {
            FillingOrgTreeNode fillingOrgTreeNode = first.get();
            Optional<FillingOrgTreeNode> optional = fillingOrgNodes.stream().filter(e -> StrUtil.equals((CharSequence)e.getOrgId(), (CharSequence)fillingOrgTreeNode.getPid())).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
        }
        return null;
    }

    public static List<FillingOrgTreeNode> getChildOrg(String orgTree, String orgId) {
        List<FillingOrgTreeNode> fillingOrgNodes = FillingOrgUtil.getFillingOrgNodes(orgTree);
        List<FillingOrgTreeNode> child = fillingOrgNodes.stream().filter(f -> StrUtil.equals((CharSequence)orgId, (CharSequence)f.getPid())).collect(Collectors.toList());
        if (!CollUtil.isEmpty(child)) {
            return child;
        }
        return null;
    }

    public static List<FillingOrgTreeNode> getTreeData(List<FillingOrgTreeNode> nodes) {
        List<FillingOrgTreeNode> orgTreeNodes = nodes.stream().filter(f -> StrUtil.isBlank((CharSequence)f.getPid())).collect(Collectors.toList());
        if (!CollUtil.isEmpty(orgTreeNodes)) {
            for (FillingOrgTreeNode orgTreeNode : orgTreeNodes) {
                FillingOrgUtil.getChildDataRecursion(orgTreeNode, nodes);
            }
            return orgTreeNodes;
        }
        return null;
    }

    private static void addResultArr(List<FillingOrgTreeNode> fillingOrgTreeNodes, List<FillingOrgTreeNode> resultArr) {
        if (!CollUtil.isEmpty(fillingOrgTreeNodes)) {
            for (FillingOrgTreeNode fillingOrgTreeNode : fillingOrgTreeNodes) {
                resultArr.add(fillingOrgTreeNode);
                FillingOrgUtil.addResultArr(fillingOrgTreeNode.getChild(), resultArr);
            }
        }
    }

    private static void getChildDataRecursion(FillingOrgTreeNode fillingOrgTreeNode, List<FillingOrgTreeNode> nodes) {
        List<FillingOrgTreeNode> collect = nodes.stream().filter(f -> StrUtil.equals((CharSequence)fillingOrgTreeNode.getOrgId(), (CharSequence)f.getPid())).collect(Collectors.toList());
        if (!CollUtil.isEmpty(collect)) {
            for (FillingOrgTreeNode orgTreeNode : collect) {
                FillingOrgUtil.getChildDataRecursion(orgTreeNode, nodes);
            }
        }
        fillingOrgTreeNode.setChild(collect);
    }
}

