package xyz.yuanjilu.dgs.filling.task.service.impl;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.utils.UuidUtil;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskExpandDao;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskExpandEntity;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskExpandService;

@Service("dgsFillingTaskExpandService")
public class DgsFillingTaskExpandServiceImpl implements IDgsFillingTaskExpandService {

   @Autowired
   private DgsFillingTaskExpandDao dgsFillingTaskExpandDao;


   public DgsFillingTaskExpandEntity queryObject(String id) {
      return (DgsFillingTaskExpandEntity)this.dgsFillingTaskExpandDao.queryObject(id);
   }

   public List queryList(Map map) {
      return this.dgsFillingTaskExpandDao.queryList(map);
   }

   public int queryTotal(Map map) {
      return this.dgsFillingTaskExpandDao.queryTotal(map);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void save(DgsFillingTaskExpandEntity dgsFillingTaskExpand) {
      dgsFillingTaskExpand.setId(UuidUtil.get32UUID());
      this.dgsFillingTaskExpandDao.save(dgsFillingTaskExpand);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void update(DgsFillingTaskExpandEntity dgsFillingTaskExpand) {
      this.dgsFillingTaskExpandDao.update(dgsFillingTaskExpand);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void updateDelStatusBatch(String[] ids) {
      this.dgsFillingTaskExpandDao.updateDelStatusBatch(ids);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void deleteBatch(String[] ids) {
      this.dgsFillingTaskExpandDao.deleteBatch(ids);
   }

   public DgsFillingTaskExpandEntity queryByTaskInfoId(String taskInfoId) {
      return this.dgsFillingTaskExpandDao.queryByTaskInfoId(taskInfoId);
   }
}
