package xyz.yuanjilu.dgs.filling.task.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.utils.UuidUtil;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskAgentDao;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskAgentEntity;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskAgentService;

@Service("dgsFillingTaskAgentService")
public class DgsFillingTaskAgentServiceImpl implements IDgsFillingTaskAgentService {

   @Autowired
   private DgsFillingTaskAgentDao dgsFillingTaskAgentDao;


   public DgsFillingTaskAgentEntity queryObject(String id) {
      return (DgsFillingTaskAgentEntity)this.dgsFillingTaskAgentDao.queryObject(id);
   }

   public List queryList(Map map) {
      return this.dgsFillingTaskAgentDao.queryList(map);
   }

   public int queryTotal(Map map) {
      return this.dgsFillingTaskAgentDao.queryTotal(map);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void save(DgsFillingTaskAgentEntity dgsFillingTaskAgent) {
      dgsFillingTaskAgent.setId(UuidUtil.get32UUID());
      dgsFillingTaskAgent.setStatus(Long.valueOf(0L));
      dgsFillingTaskAgent.setTaskStartTime(new Date());
      dgsFillingTaskAgent.setCreatedTime(new Date());
      dgsFillingTaskAgent.setDataStatus(Long.valueOf("0"));
      this.dgsFillingTaskAgentDao.save(dgsFillingTaskAgent);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void update(DgsFillingTaskAgentEntity dgsFillingTaskAgent) {
      this.dgsFillingTaskAgentDao.update(dgsFillingTaskAgent);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void updateDelStatusBatch(String[] ids) {
      this.dgsFillingTaskAgentDao.updateDelStatusBatch(ids);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void deleteBatch(String[] ids) {
      this.dgsFillingTaskAgentDao.deleteBatch(ids);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void updateStatusByTaskInfoId(String taskInfoId, Long status) {
      this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, status);
   }

   public String getTaskStatus(String taskInfoId) {
      return this.dgsFillingTaskAgentDao.getTaskStatus(taskInfoId);
   }

   public DgsFillingTaskAgentEntity getAgentInfoByTaskInfoId(String taskInfoId) {
      return this.dgsFillingTaskAgentDao.getAgentInfoByTaskInfoId(taskInfoId);
   }
}
