package xyz.yuanjilu.dgs.filling.task.controller;

import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.dgs.filling.task.entity.vo.AddTaskVo;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskAgentService;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskInfoService;

@RestController
@RequestMapping({"dgs/filling/taskInfo"})
public class DgsFillingTaskInfoController {

   @Autowired
   private IDgsFillingTaskInfoService dgsFillingTaskInfoService;
   @Autowired
   private IDgsFillingTaskAgentService dgsFillingTaskAgentService;


   @RequestMapping({"/queryPagelist"})
   @RequiresPermissions({"dgs:filling:taskInfo:list"})
   public R queryPagelist(@RequestParam Map params) {
      Query query = new Query(params);
      List dgsFillingTaskInfoBoList = this.dgsFillingTaskInfoService.queryPagelist(query);
      int total = this.dgsFillingTaskInfoService.queryPageTotal(query);
      PageUtils pageUtil = new PageUtils(dgsFillingTaskInfoBoList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }

   @RequestMapping({"/querySubTasklist"})
   public R querySubTasklist(@RequestParam Map params) {
      Query query = new Query(params);
      List dgsFillingTaskInfoBoList = this.dgsFillingTaskInfoService.querySubTasklist(query);
      int total = this.dgsFillingTaskInfoService.queryPageTotal(query);
      PageUtils pageUtil = new PageUtils(dgsFillingTaskInfoBoList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }

   @RequestMapping({"/list"})
   @RequiresPermissions({"dgs:filling:taskInfo:list"})
   public R list(@RequestParam Map params) {
      Query query = new Query(params);
      List dgsFillingTaskInfoList = this.dgsFillingTaskInfoService.queryList(query);
      int total = this.dgsFillingTaskInfoService.queryTotal(query);
      PageUtils pageUtil = new PageUtils(dgsFillingTaskInfoList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }

   @GetMapping({"/info/{id}"})
   @RequiresPermissions({"dgs:filling:taskInfo:info"})
   public R info(@PathVariable("id") String id) {
      DgsFillingTaskInfoEntity dgsFillingTaskInfo = this.dgsFillingTaskInfoService.queryObject(id);
      return R.ok().put("dgsFillingTaskInfo", dgsFillingTaskInfo);
   }

   @SysLog("保存数据填报-任务信息")
   @PostMapping({"/save"})
   @RequiresPermissions({"dgs:filling:taskInfo:save"})
   public R save(@RequestBody DgsFillingTaskInfoEntity dgsFillingTaskInfo) {
      this.dgsFillingTaskInfoService.save(dgsFillingTaskInfo);
      return R.ok();
   }

   @SysLog("修改数据填报-任务信息")
   @PostMapping({"/update"})
   @RequiresPermissions({"dgs:filling:taskInfo:update"})
   public R update(@RequestBody DgsFillingTaskInfoEntity dgsFillingTaskInfo) {
      this.dgsFillingTaskInfoService.update(dgsFillingTaskInfo);
      return R.ok();
   }

   @SysLog("逻辑删除数据填报-任务信息")
   @PostMapping({"/updateDelStatusBatch"})
   @RequiresPermissions({"dgs:filling:taskInfo:delete"})
   public R updateDelStatusBatch(@RequestBody String[] ids) {
      this.dgsFillingTaskInfoService.updateDelStatusBatch(ids);
      return R.ok();
   }

   @SysLog("物理删除数据填报-任务信息")
   @PostMapping({"/deleteBatch"})
   @RequiresPermissions({"dgs:filling:taskInfo:delete"})
   public R deleteBatch(@RequestBody String[] ids) {
      this.dgsFillingTaskInfoService.deleteBatch(ids);
      return R.ok();
   }

   @RequestMapping({"/filingAssistantData"})
   public R filingAssistantData(@RequestParam Map params) {
      Map result = this.dgsFillingTaskInfoService.filingAssistantData(params);
      return R.ok().put("data", result);
   }

   @GetMapping({"/getTaskStatus"})
   public R getTaskStatus(@RequestParam("taskInfoId") String taskInfoId) {
      String status = this.dgsFillingTaskAgentService.getTaskStatus(taskInfoId);
      return R.ok().put("data", status);
   }

   @PostMapping({"/addTask"})
   @RequiresPermissions({"dgs:filling:taskInfo:save"})
   public R addTask(@RequestBody AddTaskVo addTaskVo) {
      this.dgsFillingTaskInfoService.addTask(addTaskVo);
      return R.ok();
   }

   @PostMapping({"/delTask"})
   @RequiresPermissions({"dgs:filling:taskInfo:delete"})
   public R delTask(@RequestBody Map params) {
      this.dgsFillingTaskInfoService.delTask(params);
      return R.ok();
   }

   @GetMapping({"/getBatchDateList"})
   public R getBatchDateList(@RequestParam("ruleInfoId") String ruleInfoId) {
      return R.ok().put("data", this.dgsFillingTaskInfoService.getBatchDateList(ruleInfoId));
   }

   @PostMapping({"/getNotTaskOrgList"})
   public R getNotTaskOrgList(@RequestBody Map params) {
      return R.ok().put("data", this.dgsFillingTaskInfoService.getNotTaskOrgList(params));
   }

   @GetMapping({"/orgTaskData"})
   public R orgTaskData(@RequestParam("orgId") String orgId) {
      return R.ok().put("data", this.dgsFillingTaskInfoService.orgTaskData(orgId));
   }

   @GetMapping({"/getTaskListenerDic"})
   public R getTaskListenerDic() {
      return R.ok().put("data", this.dgsFillingTaskInfoService.getTaskListenerDic());
   }

   @PostMapping({"/fetchYearEndArchive"})
   public R fetchYearEndArchive(@RequestBody Map params) {
      return R.ok().put("data", this.dgsFillingTaskInfoService.fetchYearEndArchive(params));
   }

   @PostMapping({"/fetchPastArchive"})
   public R fetchPastArchive(@RequestBody Map params) {
      return R.ok().put("data", this.dgsFillingTaskInfoService.fetchPastArchive(params));
   }
}
