package xyz.yuanjilu.dgs.filling.task.api;

import cn.hutool.core.map.MapUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskInfoService;

@RestController
@RequestMapping({"api/dgs/filling/taskInfo"})
public class ApiDgsFillingTaskInfoController {

   @Autowired
   private IDgsFillingTaskInfoService dgsFillingTaskInfoService;


   @GetMapping({"/list"})
   public R list(@RequestParam Map params) {
      Assert.isNull(MapUtil.getInt(params, "page"), "参数异常，当前页不能为空");
      Assert.isNull(MapUtil.getInt(params, "limit"), "参数异常，每页条数不能为空");
      Query query = new Query(params);
      List dgsFillingTaskInfoList = this.dgsFillingTaskInfoService.queryList(query);
      int total = this.dgsFillingTaskInfoService.queryTotal(query);
      PageUtils pageUtil = new PageUtils(dgsFillingTaskInfoList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }

   @GetMapping({"/info/{id}"})
   public R info(@PathVariable("id") String id) {
      DgsFillingTaskInfoEntity dgsFillingTaskInfo = this.dgsFillingTaskInfoService.queryObject(id);
      return R.ok().put("dgsFillingTaskInfo", dgsFillingTaskInfo);
   }

   @SysLog("修改数据填报-任务信息")
   @PostMapping({"/save"})
   public R save(@RequestBody DgsFillingTaskInfoEntity dgsFillingTaskInfo) {
      this.dgsFillingTaskInfoService.save(dgsFillingTaskInfo);
      return R.ok();
   }

   @SysLog("修改数据填报-任务信息")
   @PostMapping({"/update"})
   public R update(@RequestBody DgsFillingTaskInfoEntity dgsFillingTaskInfo) {
      this.dgsFillingTaskInfoService.update(dgsFillingTaskInfo);
      return R.ok();
   }

   @SysLog("逻辑删除数据填报-任务信息")
   @PostMapping({"/updateDelStatusBatch"})
   public R updateDelStatusBatch(@RequestBody String[] ids) {
      this.dgsFillingTaskInfoService.updateDelStatusBatch(ids);
      return R.ok();
   }

   @SysLog("物理删除数据填报-任务信息")
   @PostMapping({"/deleteBatch"})
   public R deleteBatch(@RequestBody String[] ids) {
      this.dgsFillingTaskInfoService.deleteBatch(ids);
      return R.ok();
   }
}
