package xyz.yuanjilu.dgs.filling.task;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo.CycleConfig;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgTreeNode;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.rule.service.IDgsFillingRuleInfoService;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskAgentEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskAgentService;
import xyz.yuanjilu.dgs.filling.task.service.IDgsFillingTaskInfoService;

@Component("fillingInspectionPlanTask")
public class FillingInspectionPlanTask {

   private static final Logger logger = Logger.getLogger(FillingInspectionPlanTask.class);
   @Autowired
   private IDgsFillingRuleInfoService dgsFillingRuleInfoService;
   @Autowired
   private IDgsFillingTaskInfoService dgsFillingTaskInfoService;
   @Autowired
   private IDgsFillingTaskAgentService dgsFillingTaskAgentService;


   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void releaseInspectionTask() {
      logger.info("填报任务计划发布填报定时任务开始----------");
      LocalDateTime now = LocalDateTime.now();
      HashMap queryParams = new HashMap();
      queryParams.put("status", String.valueOf(1L));
      List dgsFillingRuleInfoEntities = this.dgsFillingRuleInfoService.queryList(queryParams);
      Assert.isNull(dgsFillingRuleInfoEntities, "巡检计划发布巡检任务定时任务结束----------");
      if(dgsFillingRuleInfoEntities.size() > 0) {
         Iterator var4 = dgsFillingRuleInfoEntities.iterator();

         while(var4.hasNext()) {
            DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = (DgsFillingRuleInfoEntity)var4.next();
            String fillingConfig = dgsFillingRuleInfoEntity.getFillingConfig();
            if(!StrUtil.isBlank(fillingConfig)) {
               FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject(fillingConfig, FillingConfigBo.class);
               String startStopDate = fillingConfigBo.getCycleConfig().getStartStopDate();
               if(StrUtil.equals(startStopDate, "2")) {
                  String checkCycle = fillingConfigBo.getCycleConfig().getFillingTimeStart();
                  String fillingOrgTreeNodes = fillingConfigBo.getCycleConfig().getFillingTimeEnd();
                  boolean checkDate = this.isCheckDate(checkCycle, fillingOrgTreeNodes, (new SimpleDateFormat("yyyy-MM-dd")).format(new Date()));
                  if(!checkDate) {
                     continue;
                  }
               }

               boolean checkCycle1 = this.isCheckCycle(fillingConfigBo.getCycleConfig(), now);
               if(checkCycle1) {
                  List fillingOrgTreeNodes1 = JSON.parseArray(fillingConfigBo.getProcessConfig().getOrgTree(), FillingOrgTreeNode.class);
                  if(!ObjectUtil.isNull(fillingOrgTreeNodes1) && fillingOrgTreeNodes1.size() > 0) {
                     Iterator checkDate1 = fillingOrgTreeNodes1.iterator();

                     while(checkDate1.hasNext()) {
                        FillingOrgTreeNode fillingOrgTreeNode = (FillingOrgTreeNode)checkDate1.next();
                        String id = UUID.randomUUID().toString().replace("-", "");
                        String ruleInfoId = dgsFillingRuleInfoEntity.getId();
                        String batchDate = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        String taskCode = "TB" + UUID.randomUUID().toString().replace("-", "");
                        Date date = new Date();
                        DateTime planEndTime = DateUtil.offsetDay(date, Integer.valueOf(fillingConfigBo.getCycleConfig().getLotDayNum()).intValue() - 1);
                        DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = new DgsFillingTaskInfoEntity();
                        dgsFillingTaskInfoEntity.setId(id);
                        dgsFillingTaskInfoEntity.setRuleInfoId(ruleInfoId);
                        dgsFillingTaskInfoEntity.setTaskCode(taskCode);
                        dgsFillingTaskInfoEntity.setBatchDate(batchDate);
                        dgsFillingTaskInfoEntity.setpTaskId("");
                        dgsFillingTaskInfoEntity.setPlanStartTime(date);
                        dgsFillingTaskInfoEntity.setPlanEndTime(planEndTime);
                        this.dgsFillingTaskInfoService.save(dgsFillingTaskInfoEntity);
                        DgsFillingTaskAgentEntity dgsFillingTaskAgentEntity = new DgsFillingTaskAgentEntity();
                        dgsFillingTaskAgentEntity.setTaskInfoId(id);
                        dgsFillingTaskAgentEntity.setFillingOrg(fillingOrgTreeNode.getOrgId());
                        this.dgsFillingTaskAgentService.save(dgsFillingTaskAgentEntity);
                        List dgsFillingTaskInfoEntityChild = this.getDgsFillingTaskInfoEntityChild(dgsFillingTaskInfoEntity, fillingOrgTreeNode, new ArrayList());
                        if(ObjectUtil.isNotNull(dgsFillingTaskInfoEntityChild) && dgsFillingTaskInfoEntityChild.size() > 0) {
                           Iterator var23 = dgsFillingTaskInfoEntityChild.iterator();

                           while(var23.hasNext()) {
                              DgsFillingTaskInfoEntity fillingTaskInfoEntity = (DgsFillingTaskInfoEntity)var23.next();
                              String childTaskCode = "TB" + UUID.randomUUID().toString().replace("-", "");
                              fillingTaskInfoEntity.setTaskCode(childTaskCode);
                              this.dgsFillingTaskInfoService.save(fillingTaskInfoEntity);
                              DgsFillingTaskAgentEntity fillingTaskAgentEntity = new DgsFillingTaskAgentEntity();
                              fillingTaskAgentEntity.setTaskInfoId(fillingTaskInfoEntity.getId());
                              fillingTaskAgentEntity.setFillingOrg(fillingTaskInfoEntity.getOrgId());
                              fillingTaskAgentEntity.setAuditOrg(fillingTaskInfoEntity.getAuditOrg());
                              this.dgsFillingTaskAgentService.save(fillingTaskAgentEntity);
                           }
                        }
                     }
                  }
               }
            }
         }
      }

   }

   private boolean isCheckDate(String startDateStr, String endDateStr, String checkDateStr) {
      long startDate = DateUtil.parseDate(startDateStr).getTime();
      long endDate = DateUtil.parseDate(endDateStr).getTime();
      long checkDate = DateUtil.parseDate(checkDateStr).getTime();
      return checkDate >= startDate && checkDate <= endDate;
   }

   private boolean isCheckCycle(CycleConfig cycleConfig, LocalDateTime now) {
      boolean bol = false;
      String cycleType = cycleConfig.getCycleType();
      byte var6 = -1;
      switch(cycleType.hashCode()) {
      case 49:
         if(cycleType.equals("1")) {
            var6 = 0;
         }
         break;
      case 50:
         if(cycleType.equals("2")) {
            var6 = 1;
         }
         break;
      case 51:
         if(cycleType.equals("3")) {
            var6 = 2;
         }
         break;
      case 52:
         if(cycleType.equals("4")) {
            var6 = 3;
         }
         break;
      case 53:
         if(cycleType.equals("5")) {
            var6 = 4;
         }
         break;
      case 54:
         if(cycleType.equals("6")) {
            var6 = 5;
         }
      }

      switch(var6) {
      case 0:
         List numberTime = cycleConfig.getNumberTime();
         if(numberTime.contains(Integer.valueOf(now.getHour()))) {
            bol = true;
         }
         break;
      case 1:
         String dateTimeWeek = cycleConfig.getDateTimeWeek();
         String weekTime = cycleConfig.getWeekTime();
         if(StrUtil.equals(dateTimeWeek, String.valueOf(now.getDayOfWeek().getValue())) && StrUtil.equals(weekTime, String.valueOf(now.getHour()))) {
            bol = true;
         }
         break;
      case 2:
         String dateTimeMonth = cycleConfig.getDateTimeMonth();
         String monthTime = cycleConfig.getMonthTime();
         if(StrUtil.equals(dateTimeMonth, String.valueOf(now.getDayOfMonth())) && StrUtil.equals(monthTime, String.valueOf(now.getHour()))) {
            bol = true;
         }
         break;
      case 3:
         String dateTimeQuarter = cycleConfig.getDateTimeQuarter();
         String quarterDayTime = cycleConfig.getQuarterDayTime();
         String quarterTime = cycleConfig.getQuarterTime();
         if(StrUtil.equals(dateTimeQuarter, String.valueOf((now.getMonthValue() - 1) % 3 + 1)) && StrUtil.equals(quarterDayTime, String.valueOf(now.getDayOfMonth())) && StrUtil.equals(quarterTime, String.valueOf(now.getHour()))) {
            bol = true;
         }
         break;
      case 4:
         String dateTimeYearMonth = cycleConfig.getDateTimeYearMonth();
         String yearDayTime = cycleConfig.getYearDayTime();
         String yearTime = cycleConfig.getYearTime();
         if(StrUtil.equals(dateTimeYearMonth, String.valueOf(now.getMonthValue())) && StrUtil.equals(yearDayTime, String.valueOf(now.getDayOfMonth())) && StrUtil.equals(yearTime, String.valueOf(now.getHour()))) {
            bol = true;
         }
         break;
      case 5:
         String dateTimeSpecify = cycleConfig.getDateTimeSpecify();
         String specifyTime = cycleConfig.getSpecifyTime();
         if(StrUtil.equals(dateTimeSpecify, now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))) && StrUtil.equals(specifyTime, String.valueOf(now.getHour()))) {
            bol = true;
         }
         break;
      default:
         bol = false;
      }

      return bol;
   }

   private List getDgsFillingTaskInfoEntityChild(DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity, FillingOrgTreeNode fillingOrgTreeNode, List dgsFillingTaskInfoEntities) {
      String orgId = StrUtil.isNotBlank(fillingOrgTreeNode.getOrgId())?fillingOrgTreeNode.getOrgId():"";
      List child = fillingOrgTreeNode.getChild();
      if(ObjectUtil.isNotNull(child) && child.size() > 0) {
         Iterator var6 = child.iterator();

         while(var6.hasNext()) {
            FillingOrgTreeNode orgTreeNode = (FillingOrgTreeNode)var6.next();
            DgsFillingTaskInfoEntity ord = (DgsFillingTaskInfoEntity)JSON.parseObject(JSON.toJSONString(dgsFillingTaskInfoEntity), DgsFillingTaskInfoEntity.class);
            ord.setId(UUID.randomUUID().toString().replace("-", ""));
            ord.setpTaskId(dgsFillingTaskInfoEntity.getId());
            ord.setOrgId(orgTreeNode.getOrgId());
            ord.setOrgId(orgTreeNode.getOrgId());
            ord.setAuditOrg(orgId);
            dgsFillingTaskInfoEntities.add(ord);
            if(ObjectUtil.isNotNull(orgTreeNode.getChild()) && orgTreeNode.getChild().size() > 0) {
               this.getDgsFillingTaskInfoEntityChild(ord, orgTreeNode, dgsFillingTaskInfoEntities);
            }
         }
      }

      return dgsFillingTaskInfoEntities;
   }

}
