package xyz.yuanjilu.dgs.filling.rule.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.utils.UuidUtil;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgTreeNode;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgUtil;
import xyz.yuanjilu.dgs.filling.rule.dao.DgsFillingRuleInfoDao;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.rule.service.IDgsFillingRuleInfoService;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskInfoDao;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.system.utils.ShiroUtils;

@Service("dgsFillingRuleInfoService")
public class DgsFillingRuleInfoServiceImpl implements IDgsFillingRuleInfoService {

   private static final Logger logger = LoggerFactory.getLogger(DgsFillingRuleInfoServiceImpl.class);
   @Autowired
   private DgsFillingRuleInfoDao dgsFillingRuleInfoDao;
   @Autowired
   private DgsFillingTaskInfoDao dgsFillingTaskInfoDao;


   public DgsFillingRuleInfoEntity queryObject(String id) {
      return (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(id);
   }

   public List queryList(Map map) {
      return this.dgsFillingRuleInfoDao.queryList(map);
   }

   public int queryTotal(Map map) {
      return this.dgsFillingRuleInfoDao.queryTotal(map);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void save(DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
      dgsFillingRuleInfo.setId(UuidUtil.get32UUID());
      dgsFillingRuleInfo.setRuleCode(this.generateRuleCode());
      dgsFillingRuleInfo.setCreatedTime(new Date());
      dgsFillingRuleInfo.setCreatedUserId(ShiroUtils.getUserId());
      dgsFillingRuleInfo.setStatus(Long.valueOf(0L));
      dgsFillingRuleInfo.setDataStatus(Long.valueOf("0"));
      this.dgsFillingRuleInfoDao.save(dgsFillingRuleInfo);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void update(DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
      this.dgsFillingRuleInfoDao.update(dgsFillingRuleInfo);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void updateDelStatusBatch(String[] ids) {
      this.dgsFillingRuleInfoDao.updateDelStatusBatch(ids);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void deleteBatch(String[] ids) {
      this.dgsFillingRuleInfoDao.deleteBatch(ids);
   }

   public void release(String id) {
      DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(id);
      if(ObjectUtil.isNotNull(dgsFillingRuleInfoEntity)) {
         dgsFillingRuleInfoEntity.setStatus(Long.valueOf(1L));
         dgsFillingRuleInfoEntity.setUpdatedTime(new Date());
         dgsFillingRuleInfoEntity.setUpdatedUserId(ShiroUtils.getUserId());
         dgsFillingRuleInfoEntity.setReleaseTime(new Date());
         this.dgsFillingRuleInfoDao.update(dgsFillingRuleInfoEntity);
      }

   }

   public void deactivate(String id) {
      DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(id);
      if(ObjectUtil.isNotNull(dgsFillingRuleInfoEntity)) {
         dgsFillingRuleInfoEntity.setStatus(Long.valueOf(2L));
         dgsFillingRuleInfoEntity.setUpdatedTime(new Date());
         dgsFillingRuleInfoEntity.setUpdatedUserId(ShiroUtils.getUserId());
         this.dgsFillingRuleInfoDao.update(dgsFillingRuleInfoEntity);
      }

   }

   public String generateRuleCode() {
      List dgsFillingRuleInfoEntities = this.dgsFillingRuleInfoDao.queryList(new HashMap());
      if(!ObjectUtil.isNull(dgsFillingRuleInfoEntities) && dgsFillingRuleInfoEntities.size() > 0) {
         Collections.sort(dgsFillingRuleInfoEntities, Comparator.comparing(apply<invokedynamic>()).reversed());
         DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = (DgsFillingRuleInfoEntity)dgsFillingRuleInfoEntities.get(0);
         String ruleCode = dgsFillingRuleInfoEntity.getRuleCode();
         Long aLong = Long.valueOf(Long.valueOf(ruleCode.substring(2, ruleCode.length())).longValue() + 1L);
         return "SQ" + aLong.toString();
      } else {
         return "SQ102010100";
      }
   }

   public List getDefaultDataList() {
      try {
         String e = "[{\"id\":\"TASK_CREATION_TIME\",\"name\":\"任务创建时间\"},{\"id\":\"TASK_START_TIME\",\"name\":\"任务开始时间\"},{\"id\":\"TASK_OPERATOR_NAME\",\"name\":\"任务操作人员名称\"},{\"id\":\"TASK_ORG_NAME\",\"name\":\"任务所属单位名称\"},{\"id\":\"TASK_OPERATION_TIME\",\"name\":\"任务操作时间\"}]";
         ObjectMapper objectMapper = new ObjectMapper();
         List list = (List)objectMapper.readValue(e, new TypeReference() {
         });
         return list;
      } catch (JsonProcessingException var4) {
         logger.error(var4.getMessage(), var4);
         return new ArrayList();
      }
   }

   public DgsFillingRuleInfoEntity queryObjectByTaskInfoId(String taskInfoId) {
      return this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
   }

   public Map getSupOrgData(Map params) {
      String ruleInfoId = MapUtil.getStr(params, "ruleInfoId");
      String orgId = MapUtil.getStr(params, "orgId");
      String batchDate = MapUtil.getStr(params, "batchDate");
      Assert.isBlank(ruleInfoId, "参数不合法，规则ID不能为空");
      Assert.isBlank(orgId, "参数不合法，单位ID不能为空");
      Assert.isBlank(batchDate, "参数不合法，填报批次不能为空");
      DgsFillingRuleInfoEntity ruleInfo = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(ruleInfoId);
      Assert.isNull(ruleInfo, "规则不存在");
      FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject(ruleInfo.getFillingConfig(), FillingConfigBo.class);
      Assert.isNull(fillingConfigBo, "当前规则，未设置填报配置");
      Assert.isTrue(StrUtil.isBlank(fillingConfigBo.getProcessConfig().getOrgTree()), "当前规则，未设置填报单位");
      FillingOrgTreeNode parentOrg = FillingOrgUtil.getParentOrg(fillingConfigBo.getProcessConfig().getOrgTree(), orgId);
      if(ObjUtil.isNull(parentOrg)) {
         return null;
      } else {
         DgsFillingTaskInfoEntity taskInfo = this.dgsFillingTaskInfoDao.getRuleOrgBatchTaskInfo(ruleInfoId, batchDate, parentOrg.getOrgId());
         Assert.isNull(taskInfo, "未找到该批次单位的上级单位任务信息，上级单位为：" + parentOrg.getOrgName());
         HashMap result = new HashMap();
         result.put("org", parentOrg);
         result.put("taskInfo", taskInfo);
         return result;
      }
   }

   public boolean isMiddleNode(String ruleInfoId, String orgId) {
      try {
         DgsFillingRuleInfoEntity e = (DgsFillingRuleInfoEntity)this.dgsFillingRuleInfoDao.queryObject(ruleInfoId);
         FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject(e.getFillingConfig(), FillingConfigBo.class);
         List childOrg = FillingOrgUtil.getChildOrg(fillingConfigBo.getProcessConfig().getOrgTree(), orgId);
         return !CollUtil.isEmpty(childOrg);
      } catch (Exception var6) {
         return false;
      }
   }

}
