package xyz.yuanjilu.dgs.filling.rule.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.dgs.dcm.collection.service.DgsDcmCollectionFieldService;
import xyz.yuanjilu.dgs.dcm.collection.service.DgsDcmCollectionService;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.rule.service.IDgsFillingRuleInfoService;

@RestController
@RequestMapping({"dgs/filling/rule"})
public class DgsFillingRuleInfoController {

   @Autowired
   private IDgsFillingRuleInfoService dgsFillingRuleInfoService;
   @Autowired
   private DgsDcmCollectionFieldService dgsDcmCollectionFieldService;
   @Autowired
   private DgsDcmCollectionService dgsDcmCollectionService;


   @RequestMapping({"/list"})
   @RequiresPermissions({"dgs:filling:rule:list"})
   public R list(@RequestParam Map params) {
      Query query = new Query(params);
      List dgsFillingRuleInfoList = this.dgsFillingRuleInfoService.queryList(query);
      int total = this.dgsFillingRuleInfoService.queryTotal(query);
      PageUtils pageUtil = new PageUtils(dgsFillingRuleInfoList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }

   @GetMapping({"/info/{id}"})
   @RequiresPermissions({"dgs:filling:rule:info"})
   public R info(@PathVariable("id") String id) {
      DgsFillingRuleInfoEntity dgsFillingRuleInfo = this.dgsFillingRuleInfoService.queryObject(id);
      return R.ok().put("dgsFillingRuleInfo", dgsFillingRuleInfo);
   }

   @SysLog("保存数据填报-规则信息表")
   @PostMapping({"/save"})
   @RequiresPermissions({"dgs:filling:rule:save"})
   public R save(@RequestBody DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
      this.dgsFillingRuleInfoService.save(dgsFillingRuleInfo);
      return R.ok();
   }

   @SysLog("修改数据填报-规则信息表")
   @PostMapping({"/update"})
   @RequiresPermissions({"dgs:filling:rule:update"})
   public R update(@RequestBody DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
      this.dgsFillingRuleInfoService.update(dgsFillingRuleInfo);
      return R.ok();
   }

   @SysLog("逻辑删除数据填报-规则信息表")
   @PostMapping({"/updateDelStatusBatch"})
   @RequiresPermissions({"dgs:filling:rule:delete"})
   public R updateDelStatusBatch(@RequestBody String[] ids) {
      this.dgsFillingRuleInfoService.updateDelStatusBatch(ids);
      return R.ok();
   }

   @SysLog("物理删除数据填报-规则信息表")
   @PostMapping({"/deleteBatch"})
   @RequiresPermissions({"dgs:filling:rule:delete"})
   public R deleteBatch(@RequestBody String[] ids) {
      this.dgsFillingRuleInfoService.deleteBatch(ids);
      return R.ok();
   }

   @SysLog("发布数据填报-规则信息表")
   @GetMapping({"/release/{id}"})
   @RequiresPermissions({"dgs:filling:rule:release"})
   public R release(@PathVariable("id") String id) {
      this.dgsFillingRuleInfoService.release(id);
      return R.ok();
   }

   @SysLog("停用数据填报-规则信息表")
   @GetMapping({"/deactivate/{id}"})
   @RequiresPermissions({"dgs:filling:rule:deactivate"})
   public R deactivate(@PathVariable("id") String id) {
      this.dgsFillingRuleInfoService.deactivate(id);
      return R.ok();
   }

   @GetMapping({"/generateRuleCode"})
   public R generateRuleCode() {
      return R.ok().put("data", this.dgsFillingRuleInfoService.generateRuleCode());
   }

   @GetMapping({"/getDefaultDataList"})
   public R getDefaultDataList() {
      return R.ok().put("data", this.dgsFillingRuleInfoService.getDefaultDataList());
   }

   @GetMapping({"/getList"})
   public R getList() {
      return R.ok().put("data", this.dgsFillingRuleInfoService.queryList(new HashMap()));
   }

   @PostMapping({"/getSupOrgData"})
   public R getSupOrgData(@RequestBody Map params) {
      return R.ok().put("data", this.dgsFillingRuleInfoService.getSupOrgData(params));
   }

   @GetMapping({"/isMiddleNode"})
   public R isMiddleNode(@RequestParam("ruleInfoId") String ruleInfoId, @RequestParam("orgId") String orgId) {
      return R.ok().put("data", Boolean.valueOf(this.dgsFillingRuleInfoService.isMiddleNode(ruleInfoId, orgId)));
   }

   @RequestMapping({"/queryFieldList"})
   public R queryFieldList(@RequestParam Map params) {
      List dgsDcmCollectionFieldEntity = this.dgsDcmCollectionFieldService.queryAll(params);
      return R.ok().put("list", dgsDcmCollectionFieldEntity);
   }

   @RequestMapping({"/queryDcmList"})
   public R queryDcmList(@RequestParam Map params) {
      Query query = new Query(params);
      List dgsDcmCollectionList = this.dgsDcmCollectionService.queryList(query);
      int total = this.dgsDcmCollectionService.queryTotal(query);
      PageUtils pageUtil = new PageUtils(dgsDcmCollectionList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }
}
