package xyz.yuanjilu.dgs.filling.rule.api;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.rule.service.IDgsFillingRuleInfoService;

@RestController
@RequestMapping({"api/dgs/filling/rule"})
public class ApiDgsFillingRuleInfoController {

   @Autowired
   private IDgsFillingRuleInfoService dgsFillingRuleInfoService;


   @GetMapping({"/list"})
   public R list(@RequestParam Map params) {
      Query query = new Query(params);
      List dgsFillingRuleInfoList = this.dgsFillingRuleInfoService.queryList(query);
      int total = this.dgsFillingRuleInfoService.queryTotal(query);
      PageUtils pageUtil = new PageUtils(dgsFillingRuleInfoList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }

   @GetMapping({"/info/{id}"})
   public R info(@PathVariable("id") String id) {
      DgsFillingRuleInfoEntity dgsFillingRuleInfo = this.dgsFillingRuleInfoService.queryObject(id);
      return R.ok().put("dgsFillingRuleInfo", dgsFillingRuleInfo);
   }

   @SysLog("修改数据填报-规则信息表")
   @PostMapping({"/save"})
   public R save(@RequestBody DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
      this.dgsFillingRuleInfoService.save(dgsFillingRuleInfo);
      return R.ok();
   }

   @SysLog("修改数据填报-规则信息表")
   @PostMapping({"/update"})
   public R update(@RequestBody DgsFillingRuleInfoEntity dgsFillingRuleInfo) {
      this.dgsFillingRuleInfoService.update(dgsFillingRuleInfo);
      return R.ok();
   }

   @SysLog("逻辑删除数据填报-规则信息表")
   @PostMapping({"/updateDelStatusBatch"})
   public R updateDelStatusBatch(@RequestBody String[] ids) {
      this.dgsFillingRuleInfoService.updateDelStatusBatch(ids);
      return R.ok();
   }

   @SysLog("物理删除数据填报-规则信息表")
   @PostMapping({"/deleteBatch"})
   public R deleteBatch(@RequestBody String[] ids) {
      this.dgsFillingRuleInfoService.deleteBatch(ids);
      return R.ok();
   }
}
