package xyz.yuanjilu.dgs.filling.listener;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.Map.Entry;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo;
import xyz.yuanjilu.dgs.filling.listener.FillingProcessDrivenManager;
import xyz.yuanjilu.dgs.filling.listener.FillingProcessListener;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;

@Component
public class FillingEventNotification {

   private static final Logger log = LoggerFactory.getLogger(FillingEventNotification.class);
   private static final String DEFAULT_PROCESS_LISTENER = "defaultFillingProcessListener";
   private static Map fillingProcessListenerList;


   @Resource
   public void setProcessListenerList(Map fillingProcessListenerList) {
      fillingProcessListenerList = fillingProcessListenerList;
   }

   public static void notice(FillingProcessDrivenManager fillingProcessDrivenManager, FillingEventNotification.ListenerType listenerType) {
      DgsFillingTaskInfoEntity taskInfoEntity = fillingProcessDrivenManager.getTaskInfoEntity();
      String info = String.format("填报任务编号【%s】", new Object[]{ObjectUtil.isNull(taskInfoEntity)?"":taskInfoEntity.getTaskCode()});
      String listenerBean = "";
      DgsFillingRuleInfoEntity ruleInfo = fillingProcessDrivenManager.getRuleInfoEntity();
      if(ObjectUtil.isNotNull(ruleInfo) && StrUtil.isNotBlank(ruleInfo.getFillingConfig())) {
         FillingConfigBo listener = (FillingConfigBo)JSON.parseObject(ruleInfo.getFillingConfig(), FillingConfigBo.class);
         listenerBean = ObjectUtil.isNotNull(listener.getExtendConfig())?listener.getExtendConfig().getExtendBean():"";
      }

      if(StrUtil.isBlank(listenerBean)) {
         listenerBean = "defaultFillingProcessListener";
      }

      FillingProcessListener listener1 = (FillingProcessListener)fillingProcessListenerList.get(listenerBean);
      Assert.notNull(listener1, String.format("%s,无法找到对应类型的bean,参数[%s]", new Object[]{info, listenerBean}));
      switch(null.$SwitchMap$xyz$yuanjilu$dgs$filling$listener$FillingEventNotification$ListenerType[listenerType.ordinal()]) {
      case 1:
         listener1.beforePageRender(fillingProcessDrivenManager);
         break;
      case 2:
         listener1.beforeTaskFilling(fillingProcessDrivenManager);
         break;
      case 3:
         listener1.beforeTaskAuditing(fillingProcessDrivenManager);
         break;
      case 4:
         listener1.behindTaskAuditing(fillingProcessDrivenManager);
         break;
      case 5:
         listener1.beforeTaskReject(fillingProcessDrivenManager);
         break;
      case 6:
         listener1.behindTaskReject(fillingProcessDrivenManager);
      }

   }

   public static String valueTaking(FillingProcessDrivenManager fillingProcessDrivenManager, FillingEventNotification.ListenerType listenerType) {
      DgsFillingTaskInfoEntity taskInfoEntity = fillingProcessDrivenManager.getTaskInfoEntity();
      String info = String.format("填报任务编号【%s】", new Object[]{ObjectUtil.isNull(taskInfoEntity)?"":taskInfoEntity.getTaskCode()});
      String listenerBean = "";
      DgsFillingRuleInfoEntity ruleInfo = fillingProcessDrivenManager.getRuleInfoEntity();
      if(ObjectUtil.isNotNull(ruleInfo) && StrUtil.isNotBlank(ruleInfo.getFillingConfig())) {
         FillingConfigBo listener = (FillingConfigBo)JSON.parseObject(ruleInfo.getFillingConfig(), FillingConfigBo.class);
         listenerBean = ObjectUtil.isNotNull(listener.getExtendConfig())?listener.getExtendConfig().getExtendBean():"";
      }

      if(StrUtil.isBlank(listenerBean)) {
         listenerBean = "defaultFillingProcessListener";
      }

      FillingProcessListener listener1 = (FillingProcessListener)fillingProcessListenerList.get(listenerBean);
      Assert.notNull(listener1, String.format("%s,无法找到对应类型的bean,参数[%s]", new Object[]{info, listenerBean}));
      switch(null.$SwitchMap$xyz$yuanjilu$dgs$filling$listener$FillingEventNotification$ListenerType[listenerType.ordinal()]) {
      case 7:
         return listener1.getQuarterlyReportRuleCode();
      case 8:
         return listener1.getMonthlyReportRuleCode();
      default:
         return "";
      }
   }

   public static Map getFillingProcessListenerEntrySet() {
      return (Map)fillingProcessListenerList.entrySet().stream().collect(Collectors.toMap(apply<invokedynamic>(), apply<invokedynamic>()));
   }

   // $FF: synthetic method
   private static String lambda$getFillingProcessListenerEntrySet$0(Entry entry) {
      return ((FillingProcessListener)entry.getValue()).getBeanName();
   }


   public static enum ListenerType {

      beforePageRender,
      beforeTaskFilling,
      getQuarterlyReportRuleCode,
      getMonthlyReportRuleCode,
      beforeTaskAuditing,
      behindTaskAuditing,
      beforeTaskReject,
      behindTaskReject;
      // $FF: synthetic field
      private static final FillingEventNotification.ListenerType[] $VALUES = new FillingEventNotification.ListenerType[]{beforePageRender, beforeTaskFilling, getQuarterlyReportRuleCode, getMonthlyReportRuleCode, beforeTaskAuditing, behindTaskAuditing, beforeTaskReject, behindTaskReject};


   }
}
