package xyz.yuanjilu.dgs.filling.form.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.utils.UuidUtil;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.common.validator.ValidatorUtils;
import xyz.yuanjilu.dgs.dcm.collection.dao.DgsDcmCollectionDao;
import xyz.yuanjilu.dgs.dcm.collection.entity.DgsDcmCollectionEntity;
import xyz.yuanjilu.dgs.filling.audit.dao.DgsFillingAuditRecordDao;
import xyz.yuanjilu.dgs.filling.audit.entity.DgsFillingAuditRecordEntity;
import xyz.yuanjilu.dgs.filling.common.dao.CustomDao;
import xyz.yuanjilu.dgs.filling.common.entity.FillingConfigBo;
import xyz.yuanjilu.dgs.filling.form.dao.DgsFillingFormInfoDao;
import xyz.yuanjilu.dgs.filling.form.entity.DgsFillingFormInfoEntity;
import xyz.yuanjilu.dgs.filling.form.entity.bo.DgsFillingFormInfoBo;
import xyz.yuanjilu.dgs.filling.form.entity.bo.DgsRsaUserInfo;
import xyz.yuanjilu.dgs.filling.form.service.IDgsFillingFormInfoService;
import xyz.yuanjilu.dgs.filling.listener.FillingEventNotification;
import xyz.yuanjilu.dgs.filling.listener.FillingProcessDrivenManager;
import xyz.yuanjilu.dgs.filling.listener.FillingEventNotification.ListenerType;
import xyz.yuanjilu.dgs.filling.rule.dao.DgsFillingRuleInfoDao;
import xyz.yuanjilu.dgs.filling.rule.entity.DgsFillingRuleInfoEntity;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskAgentDao;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskExpandDao;
import xyz.yuanjilu.dgs.filling.task.dao.DgsFillingTaskInfoDao;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskAgentEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskAuditingEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskExpandEntity;
import xyz.yuanjilu.dgs.filling.task.entity.DgsFillingTaskInfoEntity;
import xyz.yuanjilu.system.sysorg.entity.SysOrgEntity;
import xyz.yuanjilu.system.sysorg.service.ISysOrgService;
import xyz.yuanjilu.system.sysorg.service.ISysOrgUserService;
import xyz.yuanjilu.system.sysuser.entity.SysUserEntity;
import xyz.yuanjilu.system.sysuser.service.SysUserService;

@Service("dgsFillingFormInfoService")
public class DgsFillingFormInfoServiceImpl implements IDgsFillingFormInfoService {

   @Autowired
   private DgsFillingFormInfoDao dgsFillingFormInfoDao;
   @Autowired
   private DgsFillingRuleInfoDao dgsFillingRuleInfoDao;
   @Autowired
   private DgsFillingTaskAgentDao dgsFillingTaskAgentDao;
   @Autowired
   private DgsFillingAuditRecordDao dgsFillingAuditRecordDao;
   @Autowired
   private DgsDcmCollectionDao dgsDcmCollectionDao;
   @Autowired
   private DgsFillingTaskExpandDao dgsFillingTaskExpandDao;
   @Autowired
   private DgsFillingTaskInfoDao dgsFillingTaskInfoDao;
   @Autowired
   private CustomDao customDao;
   @Autowired
   private ISysOrgService sysOrgService;
   @Autowired
   private SysUserService userService;
   @Autowired
   private ISysOrgUserService sysOrgUserService;
   private static final ConcurrentHashMap taskLocks = new ConcurrentHashMap();


   public DgsFillingFormInfoEntity queryObject(String id) {
      return (DgsFillingFormInfoEntity)this.dgsFillingFormInfoDao.queryObject(id);
   }

   public List queryList(Map map) {
      return this.dgsFillingFormInfoDao.queryList(map);
   }

   public int queryTotal(Map map) {
      return this.dgsFillingFormInfoDao.queryTotal(map);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void save(DgsFillingFormInfoEntity dgsFillingFormInfo, String userId) {
      dgsFillingFormInfo.setId(UuidUtil.get32UUID());
      dgsFillingFormInfo.setFillingUserId(userId);
      this.dgsFillingFormInfoDao.save(dgsFillingFormInfo);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void update(DgsFillingFormInfoEntity dgsFillingFormInfo, String userId) {
      dgsFillingFormInfo.setFillingUserId(userId);
      this.dgsFillingFormInfoDao.update(dgsFillingFormInfo);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void updateDelStatusBatch(String[] ids) {
      this.dgsFillingFormInfoDao.updateDelStatusBatch(ids);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void deleteBatch(String[] ids) {
      this.dgsFillingFormInfoDao.deleteBatch(ids);
   }

   public DgsFillingFormInfoEntity queryObjectByTaskInfoId(String taskInfoId) {
      return this.dgsFillingFormInfoDao.queryObjectByTaskInfoId(taskInfoId);
   }

   @Transactional(
      propagation = Propagation.REQUIRED,
      rollbackFor = {RRException.class}
   )
   public void saveOrUpdate(DgsFillingFormInfoEntity dgsFillingFormInfo, String userId) {
      if(StrUtil.isNotBlank(dgsFillingFormInfo.getTaskInfoId())) {
         String taskInfoId = dgsFillingFormInfo.getTaskInfoId();
         ReentrantLock lock = (ReentrantLock)taskLocks.computeIfAbsent(taskInfoId, (param1) -> {
            return new ReentrantLock();
         });
         lock.lock();

         try {
            DgsFillingFormInfoEntity dgsFillingFormInfoEntity = this.dgsFillingFormInfoDao.queryObjectByTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
            if(ObjectUtil.isNotNull(dgsFillingFormInfoEntity) && StrUtil.isNotBlank(dgsFillingFormInfoEntity.getId())) {
               dgsFillingFormInfo.setId(dgsFillingFormInfoEntity.getId());
               this.update(dgsFillingFormInfo, userId);
            } else {
               this.save(dgsFillingFormInfo, userId);
            }

            if(dgsFillingFormInfo.getStatus().longValue() == 1L) {
               DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
               FillingProcessDrivenManager fillingProcessDrivenManager = FillingProcessDrivenManager.build((DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(dgsFillingFormInfo.getTaskInfoId()), dgsFillingRuleInfoEntity, dgsFillingFormInfo);
               FillingEventNotification.notice(fillingProcessDrivenManager, ListenerType.beforeTaskFilling);
               String fillingConfig = dgsFillingRuleInfoEntity.getFillingConfig();
               FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject(fillingConfig, FillingConfigBo.class);
               String completionMode = fillingConfigBo.getProcessConfig().getCompletionMode();
               if(StrUtil.equals(completionMode, "1")) {
                  this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfo.getTaskInfoId(), Long.valueOf(1L));
                  this.auditRecord(userId, dgsFillingFormInfo.getTaskInfoId(), "0", "", "");
               } else {
                  DgsFillingTaskAgentEntity jsonArray = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
                  if(ObjectUtil.isNotNull(jsonArray.getAuditOrg())) {
                     this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfo.getTaskInfoId(), Long.valueOf(2L));
                     this.auditRecord(userId, dgsFillingFormInfo.getTaskInfoId(), "1", "", "");
                  } else {
                     this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfo.getTaskInfoId(), Long.valueOf(1L));
                     this.auditRecord(userId, dgsFillingFormInfo.getTaskInfoId(), "0", "", "");
                  }
               }

               if(StrUtil.isNotBlank(dgsFillingFormInfo.getFormData())) {
                  JSONArray var28 = JSON.parseArray(dgsFillingFormInfo.getFormData());
                  List collect = (List)var28.stream().filter((jsonObject) -> {
                     JSONObject jsonObject = (JSONObject)e;
                     boolean dataCollection = jsonObject.containsKey("dataCollection");
                     return dataCollection;
                  }).collect(Collectors.toList());
                  if(ObjectUtil.isNotNull(collect) && collect.size() > 0) {
                     String collectionId = fillingConfigBo.getSummaryConfig().getCollectionId();
                     DgsDcmCollectionEntity dgsDcmCollectionEntity = (DgsDcmCollectionEntity)this.dgsDcmCollectionDao.queryObject(collectionId);
                     String tableName = "DGS_T_" + dgsDcmCollectionEntity.getTableCode();
                     DgsFillingTaskExpandEntity dgsFillingTaskExpandEntity = this.dgsFillingTaskExpandDao.queryByTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
                     List fieldTypes = (List)collect.stream().map((jsonObject) -> {
                        JSONObject jsonObject = (JSONObject)e;
                        String column = jsonObject.getJSONObject("dataCollection").getString("fieldType");
                        return column;
                     }).collect(Collectors.toList());
                     String value;
                     if(ObjectUtil.isNull(dgsFillingTaskExpandEntity)) {
                        List buffer = (List)collect.stream().map((jsonObject) -> {
                           JSONObject jsonObject = (JSONObject)e;
                           String column = jsonObject.getJSONObject("dataCollection").getString("fieldCode");
                           return column;
                        }).collect(Collectors.toList());
                        List i = (List)collect.stream().map((jsonObject) -> {
                           JSONObject jsonObject = (JSONObject)e;
                           String value = jsonObject.getString("cellData");
                           return value;
                        }).collect(Collectors.toList());
                        StringBuffer fieldType = new StringBuffer();
                        fieldType.append("INSERT INTO ").append(tableName).append(" (");
                        fieldType.append("ID,");

                        for(int jsonObject = 0; jsonObject < buffer.size(); ++jsonObject) {
                           fieldType.append((String)buffer.get(jsonObject)).append(",");
                        }

                        String var32 = UUID.randomUUID().toString().replace("-", "");
                        fieldType.append("CREATED_TIME, UPDATED_TIME, DATA_STATUS, QUALITY_DATA_STATUS, BUSINESS_DATA_STATUS) VALUES (\'").append(var32).append("\',");

                        for(int column = 0; column < i.size(); ++column) {
                           value = (String)fieldTypes.get(column);
                           if(StrUtil.equals("date", value)) {
                              String value1 = (String)i.get(column);
                              if(this.isDateTimeValid(value1, "\\d{4}-\\d{2}-\\d{2}")) {
                                 value1 = value1 + " 00:00:00";
                              }

                              if(!this.isDateTimeValid(value1, "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
                                 throw new RRException("时间数据格式不正确！");
                              }

                              fieldType.append("to_date(\'").append(value1).append("\',\'YYYY-MM-DD HH24:MI:SS\')").append(",");
                           } else {
                              fieldType.append("\'").append((String)i.get(column)).append("\'").append(",");
                           }
                        }

                        fieldType.append("SYSDATE,null,\'0\',\'2\',\'0\')");
                        this.customDao.executeCustomInsert(fieldType.toString());
                        DgsFillingTaskExpandEntity var34 = new DgsFillingTaskExpandEntity();
                        var34.setId(UUID.randomUUID().toString().replace("-", ""));
                        var34.setTaskInfoId(dgsFillingFormInfo.getTaskInfoId());
                        var34.setCollectionId(var32);
                        var34.setCreatedTime(new Date());
                        this.dgsFillingTaskExpandDao.save(var34);
                     } else {
                        StringBuffer var29 = new StringBuffer();
                        var29.append("UPDATE ").append(tableName).append(" SET ");

                        for(int var30 = 0; var30 < collect.size(); ++var30) {
                           String var31 = (String)fieldTypes.get(var30);
                           JSONObject var33 = (JSONObject)collect.get(var30);
                           String var35 = var33.getJSONObject("dataCollection").getString("fieldCode");
                           value = var33.getString("cellData");
                           var29.append(var35).append("=");
                           if(StrUtil.equals("date", var31)) {
                              if(this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2}")) {
                                 value = value + " 00:00:00";
                              }

                              if(!this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
                                 throw new RRException("时间数据格式不正确！");
                              }

                              var29.append("to_date(\'").append(value).append("\',\'YYYY-MM-DD HH24:MI:SS\')").append(",");
                           } else {
                              var29.append("\'").append(value).append("\'").append(",");
                           }
                        }

                        var29.append("UPDATED_TIME=SYSDATE").append(" WHERE ID=\'").append(dgsFillingTaskExpandEntity.getCollectionId()).append("\'");
                        this.customDao.executeCustomUpdate(var29.toString());
                     }
                  }
               }
            }
         } finally {
            lock.unlock();
         }
      }

   }

   public void formReview(Map params) {
      String taskInfoId = MapUtil.getStr(params, "taskInfoId");
      String status = MapUtil.getStr(params, "status");
      String operatorContent = MapUtil.getStr(params, "operatorContent");
      String opinionContent = MapUtil.getStr(params, "opinionContent");
      String userId = MapUtil.getStr(params, "userId");
      DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(taskInfoId);
      DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
      DgsFillingTaskAuditingEntity dgsFillingTaskAuditingEntity = new DgsFillingTaskAuditingEntity(taskInfoId, status, operatorContent, opinionContent, userId);
      FillingProcessDrivenManager build = FillingProcessDrivenManager.build(dgsFillingTaskInfoEntity, dgsFillingRuleInfoEntity, dgsFillingTaskAuditingEntity);
      FillingEventNotification.notice(build, ListenerType.beforeTaskAuditing);
      if(StrUtil.equals(status, "1")) {
         this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, Long.valueOf(3L));
         this.auditRecord(userId, taskInfoId, "2", operatorContent, opinionContent);
      } else {
         this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, Long.valueOf(4L));
         this.auditRecord(userId, taskInfoId, "3", operatorContent, opinionContent);
      }

      FillingEventNotification.notice(build, ListenerType.behindTaskAuditing);
   }

   public R infoByTaskInfoId(String taskInfoId, SysUserEntity userEntity) {
      DgsFillingFormInfoEntity dgsFillingFormInfo = this.queryObjectByTaskInfoId(taskInfoId);
      DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
      DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(taskInfoId);
      DgsFillingTaskAgentEntity dgsFillingTaskAgentEntity = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(taskInfoId);
      FillingProcessDrivenManager fillingProcessDrivenManager = FillingProcessDrivenManager.build(dgsFillingTaskInfoEntity, dgsFillingRuleInfoEntity, dgsFillingFormInfo, dgsFillingTaskAgentEntity);
      FillingEventNotification.notice(fillingProcessDrivenManager, ListenerType.beforePageRender);
      R ok = R.ok();
      ok.put("fillingConfig", ObjectUtil.isNotNull(dgsFillingRuleInfoEntity)?dgsFillingRuleInfoEntity.getFillingConfig():null);
      if(ObjectUtil.isNotNull(dgsFillingFormInfo) && StrUtil.isNotBlank(dgsFillingFormInfo.getFormData())) {
         ok.put("formConfig", ObjectUtil.isNotNull(dgsFillingRuleInfoEntity)?dgsFillingRuleInfoEntity.getFormConfig():null);
         ok.put("formData", dgsFillingFormInfo.getFormData());
      } else {
         if(ObjectUtil.isNotNull(dgsFillingRuleInfoEntity) && StrUtil.isNotBlank(dgsFillingRuleInfoEntity.getFormConfig())) {
            String formConfig = dgsFillingRuleInfoEntity.getFormConfig();
            JSONObject jsonObject = JSON.parseObject(formConfig);
            if(jsonObject.containsKey("fillCell")) {
               JSONArray cellArr = jsonObject.getJSONArray("fillCell");
               Iterator var12 = cellArr.iterator();

               while(var12.hasNext()) {
                  Object o = var12.next();
                  JSONObject cellObj = (JSONObject)o;
                  if(cellObj.containsKey("defaultValue")) {
                     String defaultValue = cellObj.getString("defaultValue");
                     SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                     byte var18 = -1;
                     switch(defaultValue.hashCode()) {
                     case -1830060896:
                        if(defaultValue.equals("TASK_ORG_NAME")) {
                           var18 = 3;
                        }
                        break;
                     case 613169343:
                        if(defaultValue.equals("TASK_OPERATION_TIME")) {
                           var18 = 4;
                        }
                        break;
                     case 1150897164:
                        if(defaultValue.equals("TASK_OPERATOR_NAME")) {
                           var18 = 2;
                        }
                        break;
                     case 1822196644:
                        if(defaultValue.equals("TASK_START_TIME")) {
                           var18 = 1;
                        }
                        break;
                     case 1888389875:
                        if(defaultValue.equals("TASK_CREATION_TIME")) {
                           var18 = 0;
                        }
                     }

                     switch(var18) {
                     case 0:
                        cellObj.put("cellData", ObjectUtil.isNotNull(dgsFillingTaskInfoEntity) && ObjectUtil.isNotNull(dgsFillingTaskInfoEntity.getCreatedTime())?dateFormat.format(dgsFillingTaskInfoEntity.getCreatedTime()):"");
                        break;
                     case 1:
                        cellObj.put("cellData", ObjectUtil.isNotNull(dgsFillingTaskAgentEntity) && ObjectUtil.isNotNull(dgsFillingTaskAgentEntity.getTaskStartTime())?dateFormat.format(dgsFillingTaskAgentEntity.getTaskStartTime()):"");
                        break;
                     case 2:
                        cellObj.put("cellData", userEntity.getUsernickname());
                        break;
                     case 3:
                        String orgName = "";
                        if(ObjectUtil.isNotNull(dgsFillingTaskAgentEntity) && StrUtil.isNotBlank(dgsFillingTaskAgentEntity.getFillingOrg())) {
                           SysOrgEntity sysOrgEntity = this.sysOrgService.queryObject(dgsFillingTaskAgentEntity.getFillingOrg());
                           if(ObjectUtil.isNotNull(sysOrgEntity) && StrUtil.isNotBlank(sysOrgEntity.getSysOrgName())) {
                              orgName = sysOrgEntity.getSysOrgName();
                           }
                        }

                        cellObj.put("cellData", orgName);
                        break;
                     case 4:
                        cellObj.put("cellData", dateFormat.format(new Date()));
                     }
                  }
               }
            }

            ok.put("formConfig", jsonObject.toJSONString());
         } else {
            ok.put("formConfig", (Object)null);
         }

         ok.put("formData", (Object)null);
      }

      return ok;
   }

   public void report(Map params) throws Exception {
      String orgCode = MapUtil.getStr(params, "orgCode");
      String periodType = MapUtil.getStr(params, "periodType");
      String batchDate = MapUtil.getStr(params, "batchDate");
      String companyType = MapUtil.getStr(params, "companyType");
      String userName = MapUtil.getStr(params, "userName");
      String telephone = MapUtil.getStr(params, "telephone");
      Map formDataMap = (Map)MapUtil.get(params, "formData", Map.class);
      Assert.isBlank(orgCode, "参数异常，单位机构编号不能为空");
      Assert.isBlank(periodType, "参数异常，填报周期类型不能为空");
      Assert.isBlank(batchDate, "参数异常，填报批次不能为空");
      Assert.isNull(formDataMap, "参数异常，填报内容不能为空");
      SysOrgEntity sysOrgEntity = this.sysOrgService.queryByCode(orgCode);
      Assert.isNull(sysOrgEntity, "参数异常，单位机构编号错误");
      List taskInfoList = this.dgsFillingTaskInfoDao.getListByOrgCodeAndBatchDate(orgCode, batchDate);
      if(CollUtil.isEmpty(taskInfoList)) {
         Assert.isFalse(false, "当前机构【" + orgCode + "】【" + sysOrgEntity.getSysOrgName() + "】批次【" + batchDate + "】没有填报任务");
      }

      FillingProcessDrivenManager fillingProcessDrivenManager = FillingProcessDrivenManager.build((DgsFillingTaskInfoEntity)taskInfoList.get(0), this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(((DgsFillingTaskInfoEntity)taskInfoList.get(0)).getId()));
      String rouleCode = "";
      String periodTypeName = "";
      if(StrUtil.equals("1", periodType)) {
         periodTypeName = "季报";
         rouleCode = FillingEventNotification.valueTaking(fillingProcessDrivenManager, ListenerType.getQuarterlyReportRuleCode);
      } else if(StrUtil.equals("2", periodType)) {
         periodTypeName = "月报";
         rouleCode = FillingEventNotification.valueTaking(fillingProcessDrivenManager, ListenerType.getMonthlyReportRuleCode);
      } else {
         Assert.isFalse(false, "填报周期类型参数异常，无法识别");
      }

      DgsFillingTaskInfoEntity dgsFillingTaskInfo = this.dgsFillingTaskInfoDao.getInfoByOrgCodeAndRuleCode(orgCode, rouleCode, batchDate);
      Assert.isNull(dgsFillingTaskInfo, "当前机构【" + orgCode + "】【" + sysOrgEntity.getSysOrgName() + "】填报类型【" + periodTypeName + "】批次【" + batchDate + "】没有填报任务");
      DgsFillingTaskAgentEntity dgsFillingTaskAgentEntity = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(dgsFillingTaskInfo.getId());
      Long status = dgsFillingTaskAgentEntity.getStatus();
      if(status.longValue() != 0L && status.longValue() != 4L) {
         Assert.isFalse(false, "当前机构【" + orgCode + "】【" + sysOrgEntity.getSysOrgName() + "】填报类型【" + periodTypeName + "】批次【" + batchDate + "】任务已填报，请勿重复提交");
      }

      DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(dgsFillingTaskInfo.getId());
      Assert.isNull(dgsFillingRuleInfoEntity, "当前填报类型【" + periodTypeName + "】批次【" + batchDate + "】任务未设置填报规则，任务ID为：" + dgsFillingTaskInfo.getId());
      String formConfig = dgsFillingRuleInfoEntity.getFormConfig();
      String formData = this.getFormData(formConfig, formDataMap);
      DgsFillingFormInfoBo dgsFillingFormInfoBo = new DgsFillingFormInfoBo();
      dgsFillingFormInfoBo.setTaskInfoId(dgsFillingTaskInfo.getId());
      dgsFillingFormInfoBo.setStatus(Long.valueOf(1L));
      dgsFillingFormInfoBo.setFormData(formData);
      dgsFillingFormInfoBo.setPeriodType(periodType);
      dgsFillingFormInfoBo.setBatchDate(batchDate);
      dgsFillingFormInfoBo.setOrgCode(orgCode);
      dgsFillingFormInfoBo.setCompanyType(companyType);
      if(StrUtil.isNotBlank(userName)) {
         dgsFillingFormInfoBo.setUserName(userName);
      }

      dgsFillingFormInfoBo.setTelephone(telephone);
      DgsFillingFormInfoEntity dgsFillingFormInfoEntity = this.dgsFillingFormInfoDao.queryObjectByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId());
      if(ObjectUtil.isNotNull(dgsFillingFormInfoEntity) && StrUtil.isNotBlank(dgsFillingFormInfoEntity.getId())) {
         dgsFillingFormInfoBo.setId(dgsFillingFormInfoEntity.getId());
         this.update(dgsFillingFormInfoBo);
      } else {
         this.save(dgsFillingFormInfoBo);
      }

      DgsFillingFormInfoEntity dgsFillingFormInfo = new DgsFillingFormInfoEntity();
      BeanUtil.copyProperties(dgsFillingFormInfoBo, dgsFillingFormInfo, new String[0]);
      FillingProcessDrivenManager manager = FillingProcessDrivenManager.build(dgsFillingTaskInfo, dgsFillingRuleInfoEntity, dgsFillingFormInfo, dgsFillingTaskAgentEntity);
      FillingEventNotification.notice(manager, ListenerType.beforePageRender);
      FillingEventNotification.notice(manager, ListenerType.beforeTaskFilling);
      String fillingConfig = dgsFillingRuleInfoEntity.getFillingConfig();
      FillingConfigBo fillingConfigBo = (FillingConfigBo)JSON.parseObject(fillingConfig, FillingConfigBo.class);
      String completionMode = fillingConfigBo.getProcessConfig().getCompletionMode();
      if(StrUtil.equals(completionMode, "1")) {
         this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId(), Long.valueOf(1L));
         this.auditRecord(dgsFillingFormInfoBo.getTaskInfoId(), "0", dgsFillingFormInfoBo.getTelephone());
      } else {
         DgsFillingTaskAgentEntity jsonArray = this.dgsFillingTaskAgentDao.queryObjectByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId());
         if(ObjectUtil.isNotNull(jsonArray.getAuditOrg())) {
            this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId(), Long.valueOf(2L));
            this.auditRecord(dgsFillingFormInfoBo.getTaskInfoId(), "1", dgsFillingFormInfoBo.getTelephone());
         } else {
            this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId(), Long.valueOf(1L));
            this.auditRecord(dgsFillingFormInfoBo.getTaskInfoId(), "0", dgsFillingFormInfoBo.getTelephone());
         }
      }

      JSONArray var41 = JSON.parseArray(dgsFillingFormInfoBo.getFormData());
      List collect = (List)var41.stream().filter((jsonObject) -> {
         JSONObject jsonObject = (JSONObject)e;
         boolean dataCollection = jsonObject.containsKey("dataCollection");
         return dataCollection;
      }).collect(Collectors.toList());
      if(ObjectUtil.isNotNull(collect) && collect.size() > 0) {
         String collectionId = fillingConfigBo.getSummaryConfig().getCollectionId();
         DgsDcmCollectionEntity dgsDcmCollectionEntity = (DgsDcmCollectionEntity)this.dgsDcmCollectionDao.queryObject(collectionId);
         String tableName = "DGS_T_" + dgsDcmCollectionEntity.getTableCode();
         DgsFillingTaskExpandEntity dgsFillingTaskExpandEntity = this.dgsFillingTaskExpandDao.queryByTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId());
         List fieldTypes = (List)collect.stream().map((jsonObject) -> {
            JSONObject jsonObject = (JSONObject)e;
            String column = jsonObject.getJSONObject("dataCollection").getString("fieldType");
            return column;
         }).collect(Collectors.toList());
         String value;
         if(ObjectUtil.isNull(dgsFillingTaskExpandEntity)) {
            List buffer = (List)collect.stream().map((jsonObject) -> {
               JSONObject jsonObject = (JSONObject)e;
               String column = jsonObject.getJSONObject("dataCollection").getString("fieldCode");
               return column;
            }).collect(Collectors.toList());
            List i = (List)collect.stream().map((jsonObject) -> {
               JSONObject jsonObject = (JSONObject)e;
               String value = jsonObject.getString("cellData");
               return value;
            }).collect(Collectors.toList());
            StringBuffer fieldType = new StringBuffer();
            fieldType.append("INSERT INTO ").append(tableName).append(" (");
            fieldType.append("ID,");

            for(int jsonObject = 0; jsonObject < buffer.size(); ++jsonObject) {
               fieldType.append((String)buffer.get(jsonObject)).append(",");
            }

            String var45 = UUID.randomUUID().toString().replace("-", "");
            fieldType.append("CREATED_TIME, UPDATED_TIME, DATA_STATUS, QUALITY_DATA_STATUS, BUSINESS_DATA_STATUS) VALUES (\'").append(var45).append("\',");

            for(int column = 0; column < i.size(); ++column) {
               value = (String)fieldTypes.get(column);
               if(StrUtil.equals("date", value)) {
                  String value1 = (String)i.get(column);
                  if(this.isDateTimeValid(value1, "\\d{4}-\\d{2}-\\d{2}")) {
                     value1 = value1 + " 00:00:00";
                  }

                  Assert.isFalse(this.isDateTimeValid(value1, "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}"), "时间数据格式不正确，字段为：" + (String)buffer.get(column));
                  fieldType.append("to_date(\'").append(value1).append("\',\'YYYY-MM-DD HH24:MI:SS\')").append(",");
               } else {
                  fieldType.append("\'").append((String)i.get(column)).append("\'").append(",");
               }
            }

            fieldType.append("SYSDATE,null,\'0\',\'2\',\'0\')");
            this.customDao.executeCustomInsert(fieldType.toString());
            DgsFillingTaskExpandEntity var47 = new DgsFillingTaskExpandEntity();
            var47.setId(UUID.randomUUID().toString().replace("-", ""));
            var47.setTaskInfoId(dgsFillingFormInfoBo.getTaskInfoId());
            var47.setCollectionId(var45);
            var47.setCreatedTime(new Date());
            this.dgsFillingTaskExpandDao.save(var47);
         } else {
            StringBuffer var42 = new StringBuffer();
            var42.append("UPDATE ").append(tableName).append(" SET ");

            for(int var43 = 0; var43 < collect.size(); ++var43) {
               String var44 = (String)fieldTypes.get(var43);
               JSONObject var46 = (JSONObject)collect.get(var43);
               String var48 = var46.getJSONObject("dataCollection").getString("fieldCode");
               value = var46.getString("cellData");
               var42.append(var48).append("=");
               if(StrUtil.equals("date", var44)) {
                  if(this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2}")) {
                     value = value + " 00:00:00";
                  }

                  Assert.isFalse(this.isDateTimeValid(value, "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}"), "时间数据格式不正确，字段为：" + var48);
                  var42.append("to_date(\'").append(value).append("\',\'YYYY-MM-DD HH24:MI:SS\')").append(",");
               } else {
                  var42.append("\'").append(value).append("\'").append(",");
               }
            }

            var42.append("UPDATED_TIME=SYSDATE").append(" WHERE ID=\'").append(dgsFillingTaskExpandEntity.getCollectionId()).append("\'");
            this.customDao.executeCustomUpdate(var42.toString());
         }
      }

   }

   public void formWithdraw(String taskInfoId, String userId) {
      this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, Long.valueOf(0L));
      this.auditRecord(userId, taskInfoId, "4", "", "");
   }

   private void auditRecord(String userId, String taskInfoId, String operator, String operatorContent, String opinionContent) {
      SysOrgEntity sysOrgEntity = this.sysOrgService.queryByUserId(userId);
      Assert.isNull(sysOrgEntity, "当前登陆用户未找到关联组织");
      DgsFillingAuditRecordEntity dgsFillingAuditRecordEntity = new DgsFillingAuditRecordEntity();
      dgsFillingAuditRecordEntity.setId(UuidUtil.get32UUID());
      dgsFillingAuditRecordEntity.setTaskInfoId(taskInfoId);
      dgsFillingAuditRecordEntity.setTaskNode(sysOrgEntity.getId());
      dgsFillingAuditRecordEntity.setOperatorUserId(userId);
      dgsFillingAuditRecordEntity.setRecordTime(new Date());
      byte var9 = -1;
      switch(operator.hashCode()) {
      case 48:
         if(operator.equals("0")) {
            var9 = 0;
         }
         break;
      case 49:
         if(operator.equals("1")) {
            var9 = 1;
         }
         break;
      case 50:
         if(operator.equals("2")) {
            var9 = 2;
         }
         break;
      case 51:
         if(operator.equals("3")) {
            var9 = 3;
         }
         break;
      case 52:
         if(operator.equals("4")) {
            var9 = 4;
         }
         break;
      case 53:
         if(operator.equals("5")) {
            var9 = 5;
         }
      }

      switch(var9) {
      case 0:
         dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank(operatorContent)?"提交完成":operatorContent);
         dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank(opinionContent)?"数据提交":opinionContent);
         break;
      case 1:
         dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank(operatorContent)?"提交任务":operatorContent);
         dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank(opinionContent)?"提交本单位数据,请上级部门审核":opinionContent);
         break;
      case 2:
         dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank(operatorContent)?"通过任务":operatorContent);
         dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank(opinionContent)?"同意接收":opinionContent);
         break;
      case 3:
         dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank(operatorContent)?"退回任务":operatorContent);
         dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank(opinionContent)?"不同意接收":opinionContent);
         break;
      case 4:
         dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank(operatorContent)?"撤回填报":operatorContent);
         dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank(opinionContent)?"撤回填报任务":opinionContent);
         break;
      case 5:
         dgsFillingAuditRecordEntity.setOperatorContent(StrUtil.isBlank(operatorContent)?"审核驳回":operatorContent);
         dgsFillingAuditRecordEntity.setOpinionContent(StrUtil.isBlank(opinionContent)?"取消接收":opinionContent);
         break;
      default:
         throw new RRException("审核操作添加失败");
      }

      this.dgsFillingAuditRecordDao.save(dgsFillingAuditRecordEntity);
   }

   private void auditRecord(String taskInfoId, String operator, String telephone) {
      SysUserEntity sysUserEntity = this.userService.queryByMobile(telephone);
      Assert.isNull(sysUserEntity, String.format("未找到当前填报人手机号【%s】的用户信息", new Object[]{telephone}));
      SysOrgEntity sysOrgEntity = this.sysOrgService.queryByUserId(sysUserEntity.getUserId());
      Assert.isNull(sysOrgEntity, String.format("当前填报人手机号【%s】的用户未关联组织", new Object[]{telephone}));
      DgsFillingAuditRecordEntity dgsFillingAuditRecordEntity = new DgsFillingAuditRecordEntity();
      dgsFillingAuditRecordEntity.setId(UuidUtil.get32UUID());
      dgsFillingAuditRecordEntity.setTaskInfoId(taskInfoId);
      dgsFillingAuditRecordEntity.setTaskNode(sysOrgEntity.getId());
      dgsFillingAuditRecordEntity.setOperatorUserId(sysUserEntity.getUserId());
      dgsFillingAuditRecordEntity.setRecordTime(new Date());
      byte var8 = -1;
      switch(operator.hashCode()) {
      case 48:
         if(operator.equals("0")) {
            var8 = 0;
         }
         break;
      case 49:
         if(operator.equals("1")) {
            var8 = 1;
         }
         break;
      case 50:
         if(operator.equals("2")) {
            var8 = 2;
         }
         break;
      case 51:
         if(operator.equals("3")) {
            var8 = 3;
         }
         break;
      case 52:
         if(operator.equals("4")) {
            var8 = 4;
         }
         break;
      case 53:
         if(operator.equals("5")) {
            var8 = 5;
         }
      }

      switch(var8) {
      case 0:
         dgsFillingAuditRecordEntity.setOperatorContent("提交完成");
         dgsFillingAuditRecordEntity.setOpinionContent("数据提交");
         break;
      case 1:
         dgsFillingAuditRecordEntity.setOperatorContent("提交任务");
         dgsFillingAuditRecordEntity.setOpinionContent("对接提交本单位数据,请上级部门审核");
         break;
      case 2:
         dgsFillingAuditRecordEntity.setOperatorContent("通过任务");
         dgsFillingAuditRecordEntity.setOpinionContent("同意接收");
         break;
      case 3:
         dgsFillingAuditRecordEntity.setOperatorContent("退回任务");
         dgsFillingAuditRecordEntity.setOpinionContent("不同意接收");
         break;
      case 4:
         dgsFillingAuditRecordEntity.setOperatorContent("撤回填报");
         dgsFillingAuditRecordEntity.setOpinionContent("撤回填报任务");
         break;
      case 5:
         dgsFillingAuditRecordEntity.setOperatorContent("审核驳回");
         dgsFillingAuditRecordEntity.setOpinionContent("取消接收");
         break;
      default:
         throw new RRException("审核操作添加失败");
      }

      this.dgsFillingAuditRecordDao.save(dgsFillingAuditRecordEntity);
   }

   private boolean isDateTimeValid(String input, String format) {
      Pattern pattern = Pattern.compile(format);
      Matcher matcher = pattern.matcher(input);
      return matcher.matches();
   }

   private void save(DgsFillingFormInfoBo dgsFillingFormInfoBo) throws Exception {
      DgsRsaUserInfo rsaUserInfo = (DgsRsaUserInfo)BeanUtil.copyProperties(dgsFillingFormInfoBo, DgsRsaUserInfo.class, new String[0]);
      ValidatorUtils.validateEntity(rsaUserInfo, new Class[0]);
      SysUserEntity sysUserEntity = this.syncUserCheck(rsaUserInfo);
      dgsFillingFormInfoBo.setId(UuidUtil.get32UUID());
      dgsFillingFormInfoBo.setFillingUserId(sysUserEntity.getUserId());
      DgsFillingFormInfoEntity dgsFillingFormInfoEntity = (DgsFillingFormInfoEntity)BeanUtil.copyProperties(dgsFillingFormInfoBo, DgsFillingFormInfoEntity.class, new String[0]);
      this.dgsFillingFormInfoDao.save(dgsFillingFormInfoEntity);
   }

   private void update(DgsFillingFormInfoBo dgsFillingFormInfoBo) throws Exception {
      DgsRsaUserInfo rsaUserInfo = (DgsRsaUserInfo)BeanUtil.copyProperties(dgsFillingFormInfoBo, DgsRsaUserInfo.class, new String[0]);
      ValidatorUtils.validateEntity(rsaUserInfo, new Class[0]);
      SysUserEntity sysUserEntity = this.syncUserCheck(rsaUserInfo);
      dgsFillingFormInfoBo.setFillingUserId(sysUserEntity.getUserId());
      DgsFillingFormInfoEntity dgsFillingFormInfoEntity = (DgsFillingFormInfoEntity)BeanUtil.copyProperties(dgsFillingFormInfoBo, DgsFillingFormInfoEntity.class, new String[0]);
      this.dgsFillingFormInfoDao.update(dgsFillingFormInfoEntity);
   }

   private String getFormData(String formConfig, Map formData) {
      JSONObject jsonObject = JSONObject.parseObject(formConfig);
      if(!jsonObject.containsKey("cell")) {
         Assert.isFalse(false, "表单配置异常，请联系管理员");
      }

      JSONArray cell = jsonObject.getJSONArray("cell");
      List dataCollectionArr = (List)cell.stream().filter((param1) -> {
         return JSONObject.parseObject(JSON.toJSONString(j)).containsKey("dataCollection");
      }).collect(Collectors.toList());
      List fieldCodeArr = (List)dataCollectionArr.stream().map((param1) -> {
         return JSONObject.parseObject(JSON.toJSONString(j)).getJSONObject("dataCollection").getString("fieldCode");
      }).collect(Collectors.toList());
      ArrayList keys = new ArrayList(formData.keySet());
      List difference = (List)keys.stream().filter((param2) -> {
         return !fieldCodeArr.contains(element);
      }).collect(Collectors.toList());
      if(difference.size() > 0) {
         Assert.isFalse(false, "参数异常，表单数据映射字段不匹配，多出内容：" + JSON.toJSONString(difference));
      }

      List contrast = (List)fieldCodeArr.stream().filter((param2) -> {
         return !keys.contains(element);
      }).collect(Collectors.toList());
      if(contrast.size() > 0) {
         Assert.isFalse(false, "参数异常，表单数据映射字段不匹配，缺失内容：" + JSON.toJSONString(contrast));
      }

      if(dataCollectionArr.size() != formData.size()) {
         Assert.isFalse(false, String.format("参数异常，表单数据映射字段长度不符:表单数据长度：" + dataCollectionArr.size() + ",实际提交数据长度：" + formData.size() + "", new Object[0]));
      }

      JSONArray objects = new JSONArray();

      JSONObject cellObj;
      for(Iterator var11 = cell.iterator(); var11.hasNext(); objects.add(cellObj)) {
         Object o = var11.next();
         cellObj = JSONObject.parseObject(JSON.toJSONString(o));
         if(cellObj.containsKey("dataCollection")) {
            String cellData = MapUtil.getStr(formData, cellObj.getJSONObject("dataCollection").getString("fieldCode"));
            Assert.isBlank(cellData, "参数异常，表单填报数据字段【" + cellObj.getJSONObject("dataCollection").getString("fieldCode") + "】不能为空");
            cellObj.put("cellData", cellData);
         }
      }

      return JSON.toJSONString(objects);
   }

   private SysUserEntity syncUserCheck(DgsRsaUserInfo rsaUserInfo) {
      SysOrgEntity sysOrgEntity = this.sysOrgService.queryByCode(rsaUserInfo.getOrgCode());
      cn.hutool.core.lang.Assert.notNull(sysOrgEntity, () -> {
         return new RRException(JSON.toJSONString(R.error(400, "错误的单位机构编号")), 400);
      });
      SysUserEntity sysUserEntity = this.userService.queryByMobile(rsaUserInfo.getTelephone());
      if(Objects.nonNull(sysUserEntity)) {
         SysOrgEntity userEntity1 = this.sysOrgUserService.getOrgByUserId(sysUserEntity.getUserId());
         if(ObjectUtil.isNotNull(userEntity1) && !userEntity1.getId().equals(sysOrgEntity.getId())) {
            throw new RRException("手机号" + rsaUserInfo.getTelephone() + "已绑定机构【" + userEntity1.getSysOrgName() + "】请更换手机号", 400);
         } else {
            return sysUserEntity;
         }
      } else {
         SysUserEntity userEntity = new SysUserEntity();
         userEntity.setUserId(UuidUtil.get32UUID());
         userEntity.setUsernickname(StrUtil.isBlank(rsaUserInfo.getUserName())?rsaUserInfo.getTelephone():rsaUserInfo.getUserName());
         userEntity.setUsername(rsaUserInfo.getTelephone());
         userEntity.setMobile(rsaUserInfo.getTelephone());
         userEntity.setSortNum(Integer.valueOf(1));
         userEntity.setStatus(Integer.valueOf(1));
         Map userMap = (Map)JSON.parseObject(JSON.toJSONString(userEntity), Map.class);
         userMap.put("orgId", sysOrgEntity.getId());
         userMap.put("password", "123-!@#");
         this.userService.save(userMap);
         return userEntity;
      }
   }

   public void formReject(String taskInfoId, String userId) {
      DgsFillingTaskInfoEntity dgsFillingTaskInfoEntity = (DgsFillingTaskInfoEntity)this.dgsFillingTaskInfoDao.queryObject(taskInfoId);
      DgsFillingRuleInfoEntity dgsFillingRuleInfoEntity = this.dgsFillingRuleInfoDao.queryObjectByTaskInfoId(taskInfoId);
      FillingProcessDrivenManager build = FillingProcessDrivenManager.build(dgsFillingTaskInfoEntity, dgsFillingRuleInfoEntity);
      FillingEventNotification.notice(build, ListenerType.beforeTaskReject);
      this.dgsFillingTaskAgentDao.updateStatusByTaskInfoId(taskInfoId, Long.valueOf(2L));
      this.auditRecord(userId, taskInfoId, "5", "", "");
      FillingEventNotification.notice(build, ListenerType.behindTaskReject);
   }

}
