package xyz.yuanjilu.dgs.filling.form.controller;

import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.dgs.filling.form.entity.DgsFillingFormInfoEntity;
import xyz.yuanjilu.dgs.filling.form.service.IDgsFillingFormInfoService;
import xyz.yuanjilu.system.utils.ShiroUtils;

@RestController
@RequestMapping({"dgs/filling/form"})
public class DgsFillingFormInfoController {

   @Autowired
   private IDgsFillingFormInfoService dgsFillingFormInfoService;


   @RequestMapping({"/list"})
   @RequiresPermissions({"dgs:filling:form:list"})
   public R list(@RequestParam Map params) {
      Query query = new Query(params);
      List dgsFillingFormInfoList = this.dgsFillingFormInfoService.queryList(query);
      int total = this.dgsFillingFormInfoService.queryTotal(query);
      PageUtils pageUtil = new PageUtils(dgsFillingFormInfoList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }

   @GetMapping({"/info/{id}"})
   @RequiresPermissions({"dgs:filling:form:info"})
   public R info(@PathVariable("id") String id) {
      DgsFillingFormInfoEntity dgsFillingFormInfo = this.dgsFillingFormInfoService.queryObject(id);
      return R.ok().put("dgsFillingFormInfo", dgsFillingFormInfo);
   }

   @SysLog("保存表单填报信息表")
   @PostMapping({"/save"})
   @RequiresPermissions({"dgs:filling:form:save"})
   public R save(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
      this.dgsFillingFormInfoService.save(dgsFillingFormInfo, ShiroUtils.getUserId());
      return R.ok();
   }

   @SysLog("修改表单填报信息表")
   @PostMapping({"/update"})
   @RequiresPermissions({"dgs:filling:form:update"})
   public R update(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
      this.dgsFillingFormInfoService.update(dgsFillingFormInfo, ShiroUtils.getUserId());
      return R.ok();
   }

   @SysLog("逻辑删除表单填报信息表")
   @PostMapping({"/updateDelStatusBatch"})
   @RequiresPermissions({"dgs:filling:form:delete"})
   public R updateDelStatusBatch(@RequestBody String[] ids) {
      this.dgsFillingFormInfoService.updateDelStatusBatch(ids);
      return R.ok();
   }

   @SysLog("物理删除表单填报信息表")
   @PostMapping({"/deleteBatch"})
   @RequiresPermissions({"dgs:filling:form:delete"})
   public R deleteBatch(@RequestBody String[] ids) {
      this.dgsFillingFormInfoService.deleteBatch(ids);
      return R.ok();
   }

   @SysLog("保存或修改表单填报信息表")
   @PostMapping({"/saveOrUpdate"})
   @RequiresPermissions({"dgs:filling:form:fillInTheReport"})
   public R saveOrUpdate(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
      this.dgsFillingFormInfoService.saveOrUpdate(dgsFillingFormInfo, ShiroUtils.getUserId());
      return R.ok();
   }

   @GetMapping({"/infoByTaskInfoId"})
   @RequiresPermissions({"dgs:filling:form:info"})
   public R infoByTaskInfoId(@RequestParam("taskInfoId") String taskInfoId) {
      return this.dgsFillingFormInfoService.infoByTaskInfoId(taskInfoId, ShiroUtils.getUserEntity());
   }

   @PostMapping({"/formReview"})
   @RequiresPermissions({"dgs:filling:form:formReview"})
   public R formReview(@RequestBody Map params) {
      params.put("userId", ShiroUtils.getUserId());
      this.dgsFillingFormInfoService.formReview(params);
      return R.ok();
   }

   @GetMapping({"/formWithdraw"})
   @RequiresPermissions({"dgs:filling:form:formWithdraw"})
   public R formWithdraw(@RequestParam("taskInfoId") String taskInfoId) {
      this.dgsFillingFormInfoService.formWithdraw(taskInfoId, ShiroUtils.getUserId());
      return R.ok();
   }

   @GetMapping({"/formReject"})
   @RequiresPermissions({"dgs:filling:form:formReject"})
   public R formReject(@RequestParam("taskInfoId") String taskInfoId) {
      this.dgsFillingFormInfoService.formReject(taskInfoId, ShiroUtils.getUserId());
      return R.ok();
   }
}
