package xyz.yuanjilu.dgs.filling.form.api;

import cn.hutool.core.map.MapUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.filling.common.util.RSAUtils;
import xyz.yuanjilu.dgs.filling.form.entity.DgsFillingFormInfoEntity;
import xyz.yuanjilu.dgs.filling.form.service.IDgsFillingFormInfoService;
import xyz.yuanjilu.system.utils.ShiroUtils;

@RestController
@RequestMapping({"api/dgs/filling/form"})
public class ApiDgsFillingFormInfoController {

   @Autowired
   private IDgsFillingFormInfoService dgsFillingFormInfoService;


   @GetMapping({"/list"})
   public R list(@RequestParam Map params) {
      Query query = new Query(params);
      List dgsFillingFormInfoList = this.dgsFillingFormInfoService.queryList(query);
      int total = this.dgsFillingFormInfoService.queryTotal(query);
      PageUtils pageUtil = new PageUtils(dgsFillingFormInfoList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }

   @GetMapping({"/info/{id}"})
   public R info(@PathVariable("id") String id) {
      DgsFillingFormInfoEntity dgsFillingFormInfo = this.dgsFillingFormInfoService.queryObject(id);
      return R.ok().put("dgsFillingFormInfo", dgsFillingFormInfo);
   }

   @SysLog("修改表单填报信息表")
   @PostMapping({"/save"})
   public R save(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
      this.dgsFillingFormInfoService.save(dgsFillingFormInfo, ShiroUtils.getUserId());
      return R.ok();
   }

   @SysLog("修改表单填报信息表")
   @PostMapping({"/update"})
   public R update(@RequestBody DgsFillingFormInfoEntity dgsFillingFormInfo) {
      this.dgsFillingFormInfoService.update(dgsFillingFormInfo, ShiroUtils.getUserId());
      return R.ok();
   }

   @SysLog("逻辑删除表单填报信息表")
   @PostMapping({"/updateDelStatusBatch"})
   public R updateDelStatusBatch(@RequestBody String[] ids) {
      this.dgsFillingFormInfoService.updateDelStatusBatch(ids);
      return R.ok();
   }

   @SysLog("物理删除表单填报信息表")
   @PostMapping({"/deleteBatch"})
   public R deleteBatch(@RequestBody String[] ids) {
      this.dgsFillingFormInfoService.deleteBatch(ids);
      return R.ok();
   }

   @SysLog("任务填报接口提交")
   @PostMapping({"/report"})
   public R report(@RequestBody Map params) throws Exception {
      String data = MapUtil.getStr(params, "data");
      Assert.isNull(data, "参数异常，data不能为空");
      Map decryptParams = (Map)RSAUtils.decryptParseData(data, Map.class, KeyType.PublicKey);
      this.dgsFillingFormInfoService.report(decryptParams);
      return R.ok();
   }
}
