package xyz.yuanjilu.dgs.filling.common.util;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import xyz.yuanjilu.common.service.SysConfigService;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.common.utils.RRException;
import xyz.yuanjilu.common.validator.Assert;

public class RSAUtils {

   private static String publicKey;
   private static String privateKey;


   public static String getPrivateKey() {
      String rsaConfig = ((SysConfigService)SpringUtil.getBean(SysConfigService.class)).getValue("RSA_CONFIG", "");
      JSONObject jsonObject = JSON.parseObject(rsaConfig);
      privateKey = jsonObject.getString("RSA_PRIVATE_KEY");
      return privateKey;
   }

   public static String getPublicKey() {
      String rsaConfig = ((SysConfigService)SpringUtil.getBean(SysConfigService.class)).getValue("RSA_CONFIG", "");
      JSONObject jsonObject = JSON.parseObject(rsaConfig);
      publicKey = jsonObject.getString("RSA_PUBLIC_KEY");
      return publicKey;
   }

   public static String encryptPrivate(String data) {
      Assert.isBlank(data, "参数异常: data数据不能为空");
      RSA rsa = new RSA(getPrivateKey(), (String)null);
      return rsa.encryptBase64(data, CharsetUtil.CHARSET_UTF_8, KeyType.PrivateKey);
   }

   public static String encryptPublic(String data) {
      Assert.isBlank(data, "参数异常: data数据不能为空");
      RSA rsa = new RSA((String)null, getPublicKey());
      return rsa.encryptBase64(data, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
   }

   public static String decryptPrivate(String data) {
      Assert.isBlank(data, "参数异常: data数据不能为空");
      RSA rsa = new RSA(getPrivateKey(), (String)null);
      return rsa.decryptStr(data, KeyType.PrivateKey, CharsetUtil.CHARSET_UTF_8);
   }

   public static String decryptPublic(String data) {
      Assert.isBlank(data, "参数异常: data数据不能为空");
      RSA rsa = new RSA((String)null, getPublicKey());
      return rsa.decryptStr(data, KeyType.PublicKey, CharsetUtil.CHARSET_UTF_8);
   }

   public static Object decryptParseData(String data, Class clazz, KeyType keyType) {
      Assert.isBlank(data, "参数异常: data数据不能为空");
      String decryptedData = null;
      if(keyType == KeyType.PrivateKey) {
         decryptedData = decryptPrivate(data);
      } else if(keyType == KeyType.PublicKey) {
         decryptedData = decryptPublic(data);
      }

      boolean typeJSON = JSONUtil.isTypeJSON(decryptedData);
      if(!typeJSON) {
         throw new RRException(JSON.toJSONString(R.error(400, "参数异常")), 400);
      } else {
         return JSON.parseObject(decryptedData, clazz);
      }
   }
}
