package xyz.yuanjilu.dgs.filling.common.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import xyz.yuanjilu.common.validator.Assert;
import xyz.yuanjilu.dgs.filling.common.util.FillingOrgTreeNode;

public class FillingOrgUtil {

   public static List getFillingOrgNodes(String orgTree) {
      Assert.isBlank(orgTree, "规则配置中的单位结构树数据为空，请检查配置");
      LinkedList resultArr = new LinkedList();
      List fillingOrgTreeNodes = JSON.parseArray(orgTree, FillingOrgTreeNode.class);
      addResultArr(fillingOrgTreeNodes, resultArr);
      return resultArr;
   }

   public static String getParentOrgId(String orgTree, String orgId) {
      List fillingOrgNodes = getFillingOrgNodes(orgTree);
      Optional first = fillingOrgNodes.stream().filter((param2) -> {
         return StrUtil.equals(orgId, f.getOrgId());
      }).findFirst();
      if(first.isPresent()) {
         FillingOrgTreeNode fillingOrgTreeNode = (FillingOrgTreeNode)first.get();
         return fillingOrgTreeNode.getPid();
      } else {
         return null;
      }
   }

   public static FillingOrgTreeNode getParentOrg(String orgTree, String orgId) {
      List fillingOrgNodes = getFillingOrgNodes(orgTree);
      Optional first = fillingOrgNodes.stream().filter((param2) -> {
         return StrUtil.equals(orgId, f.getOrgId());
      }).findFirst();
      if(first.isPresent()) {
         FillingOrgTreeNode fillingOrgTreeNode = (FillingOrgTreeNode)first.get();
         Optional optional = fillingOrgNodes.stream().filter((param2) -> {
            return StrUtil.equals(e.getOrgId(), fillingOrgTreeNode.getPid());
         }).findFirst();
         if(optional.isPresent()) {
            return (FillingOrgTreeNode)optional.get();
         }
      }

      return null;
   }

   public static List getChildOrg(String orgTree, String orgId) {
      List fillingOrgNodes = getFillingOrgNodes(orgTree);
      List child = (List)fillingOrgNodes.stream().filter((param2) -> {
         return StrUtil.equals(orgId, f.getPid());
      }).collect(Collectors.toList());
      return !CollUtil.isEmpty(child)?child:null;
   }

   public static List getTreeData(List nodes) {
      List orgTreeNodes = (List)nodes.stream().filter((param1) -> {
         return StrUtil.isBlank(f.getPid());
      }).collect(Collectors.toList());
      if(CollUtil.isEmpty(orgTreeNodes)) {
         return null;
      } else {
         Iterator var2 = orgTreeNodes.iterator();

         while(var2.hasNext()) {
            FillingOrgTreeNode orgTreeNode = (FillingOrgTreeNode)var2.next();
            getChildDataRecursion(orgTreeNode, nodes);
         }

         return orgTreeNodes;
      }
   }

   private static void addResultArr(List fillingOrgTreeNodes, List resultArr) {
      if(!CollUtil.isEmpty(fillingOrgTreeNodes)) {
         Iterator var2 = fillingOrgTreeNodes.iterator();

         while(var2.hasNext()) {
            FillingOrgTreeNode fillingOrgTreeNode = (FillingOrgTreeNode)var2.next();
            resultArr.add(fillingOrgTreeNode);
            addResultArr(fillingOrgTreeNode.getChild(), resultArr);
         }
      }

   }

   private static void getChildDataRecursion(FillingOrgTreeNode fillingOrgTreeNode, List nodes) {
      List collect = (List)nodes.stream().filter((param2) -> {
         return StrUtil.equals(fillingOrgTreeNode.getOrgId(), f.getPid());
      }).collect(Collectors.toList());
      if(!CollUtil.isEmpty(collect)) {
         Iterator var3 = collect.iterator();

         while(var3.hasNext()) {
            FillingOrgTreeNode orgTreeNode = (FillingOrgTreeNode)var3.next();
            getChildDataRecursion(orgTreeNode, nodes);
         }
      }

      fillingOrgTreeNode.setChild(collect);
   }
}
