package xyz.yuanjilu.dgs.filling.audit.api;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.yuanjilu.common.annotation.SysLog;
import xyz.yuanjilu.common.utils.PageUtils;
import xyz.yuanjilu.common.utils.Query;
import xyz.yuanjilu.common.utils.R;
import xyz.yuanjilu.dgs.filling.audit.entity.DgsFillingAuditRecordEntity;
import xyz.yuanjilu.dgs.filling.audit.service.IDgsFillingAuditRecordService;

@RestController
@RequestMapping({"api/dgs/filling/audit"})
public class ApiDgsFillingAuditRecordController {

   @Autowired
   private IDgsFillingAuditRecordService dgsFillingAuditRecordService;


   @GetMapping({"/list"})
   public R list(@RequestParam Map params) {
      Query query = new Query(params);
      List dgsFillingAuditRecordList = this.dgsFillingAuditRecordService.queryList(query);
      int total = this.dgsFillingAuditRecordService.queryTotal(query);
      PageUtils pageUtil = new PageUtils(dgsFillingAuditRecordList, total, query.getLimit(), query.getPage());
      return R.ok().put("page", pageUtil);
   }

   @GetMapping({"/info/{id}"})
   public R info(@PathVariable("id") String id) {
      DgsFillingAuditRecordEntity dgsFillingAuditRecord = this.dgsFillingAuditRecordService.queryObject(id);
      return R.ok().put("dgsFillingAuditRecord", dgsFillingAuditRecord);
   }

   @SysLog("修改数据填报-审核记录")
   @PostMapping({"/save"})
   public R save(@RequestBody DgsFillingAuditRecordEntity dgsFillingAuditRecord) {
      this.dgsFillingAuditRecordService.save(dgsFillingAuditRecord);
      return R.ok();
   }

   @SysLog("修改数据填报-审核记录")
   @PostMapping({"/update"})
   public R update(@RequestBody DgsFillingAuditRecordEntity dgsFillingAuditRecord) {
      this.dgsFillingAuditRecordService.update(dgsFillingAuditRecord);
      return R.ok();
   }

   @SysLog("逻辑删除数据填报-审核记录")
   @PostMapping({"/updateDelStatusBatch"})
   public R updateDelStatusBatch(@RequestBody String[] ids) {
      this.dgsFillingAuditRecordService.updateDelStatusBatch(ids);
      return R.ok();
   }

   @SysLog("物理删除数据填报-审核记录")
   @PostMapping({"/deleteBatch"})
   public R deleteBatch(@RequestBody String[] ids) {
      this.dgsFillingAuditRecordService.deleteBatch(ids);
      return R.ok();
   }
}
