/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.button;

import android.content.Context;
import android.graphics.Canvas;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.ToggleButton;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.timepicker.h;
import d.p0;
import d2.d;
import e0.t0;
import j1.e;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import l.f;
import w1.a;
import w1.c;
import w1.j;
import w1.k;

public class MaterialButtonToggleGroup
extends LinearLayout {
    public static final int k = 0;
    public final ArrayList a = new ArrayList();
    public final p0 b = new p0(this);
    public final LinkedHashSet c = new LinkedHashSet();
    public final f d = new f(1, (Object)this);
    public Integer[] e;
    public boolean f = false;
    public boolean g;
    public boolean h;
    public final int i;
    public HashSet j = new HashSet();

    public MaterialButtonToggleGroup(Context object, AttributeSet attributeSet) {
        super(d2.d.Y0(object, attributeSet, 2130903781, 2131756061), attributeSet, 2130903781);
        object = d2.f.Y(this.getContext(), attributeSet, d1.a.k, 2130903781, 2131756061, new int[0]);
        this.setSingleSelection(object.getBoolean(3, false));
        this.i = object.getResourceId(1, -1);
        this.h = object.getBoolean(2, false);
        this.setChildrenDrawingOrderEnabled(true);
        this.setEnabled(object.getBoolean(0, true));
        object.recycle();
        object = t0.a;
        this.setImportantForAccessibility(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFirstVisibleChildIndex() {
        int n4 = this.getChildCount();
        int n5 = 0;
        while (n5 < n4) {
            if (this.d(n5)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getLastVisibleChildIndex() {
        int n4 = this.getChildCount() - 1;
        while (n4 >= 0) {
            if (this.d(n4)) {
                return n4;
            }
            --n4;
        }
        return -1;
    }

    private int getVisibleButtonCount() {
        int n4 = 0;
        for (int i4 = 0; i4 < this.getChildCount(); ++i4) {
            int n5 = n4;
            if (this.getChildAt(i4) instanceof MaterialButton) {
                n5 = n4;
                if (this.d(i4)) {
                    n5 = n4 + 1;
                }
            }
            n4 = n5;
        }
        return n4;
    }

    private void setGeneratedIdIfNeeded(MaterialButton materialButton) {
        if (materialButton.getId() == -1) {
            WeakHashMap weakHashMap = t0.a;
            materialButton.setId(View.generateViewId());
        }
    }

    private void setupButtonChild(MaterialButton materialButton) {
        materialButton.setMaxLines(1);
        materialButton.setEllipsize(TextUtils.TruncateAt.END);
        materialButton.setCheckable(true);
        materialButton.setOnPressedChangeListenerInternal(this.b);
        materialButton.setShouldDrawSurfaceColorStroke(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void a() {
        MaterialButton materialButton;
        int n4 = this.getFirstVisibleChildIndex();
        if (n4 == -1) {
            return;
        }
        for (int i4 = n4 + 1; i4 < this.getChildCount(); ++i4) {
            MaterialButton materialButton2 = this.c(i4);
            materialButton = this.c(i4 - 1);
            int n5 = Math.min(materialButton2.getStrokeWidth(), materialButton.getStrokeWidth());
            materialButton = materialButton2.getLayoutParams();
            materialButton = materialButton instanceof LinearLayout.LayoutParams ? (LinearLayout.LayoutParams)materialButton : new LinearLayout.LayoutParams(((ViewGroup.LayoutParams)materialButton).width, ((ViewGroup.LayoutParams)materialButton).height);
            if (this.getOrientation() == 0) {
                materialButton.setMarginEnd(0);
                materialButton.setMarginStart(-n5);
                ((LinearLayout.LayoutParams)materialButton).topMargin = 0;
            } else {
                ((LinearLayout.LayoutParams)materialButton).bottomMargin = 0;
                ((LinearLayout.LayoutParams)materialButton).topMargin = -n5;
                materialButton.setMarginStart(0);
            }
            materialButton2.setLayoutParams((ViewGroup.LayoutParams)materialButton);
        }
        if (this.getChildCount() == 0) return;
        if (n4 == -1) return;
        materialButton = (LinearLayout.LayoutParams)this.c(n4).getLayoutParams();
        if (this.getOrientation() == 1) {
            ((LinearLayout.LayoutParams)materialButton).topMargin = 0;
            ((LinearLayout.LayoutParams)materialButton).bottomMargin = 0;
            return;
        }
        materialButton.setMarginEnd(0);
        materialButton.setMarginStart(0);
        ((LinearLayout.LayoutParams)materialButton).leftMargin = 0;
        ((LinearLayout.LayoutParams)materialButton).rightMargin = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void addView(View object, int n4, ViewGroup.LayoutParams object2) {
        if (!(object instanceof MaterialButton)) {
            Log.e((String)"MButtonToggleGroup", (String)"Child views must be of type MaterialButton.");
            return;
        }
        super.addView((View)object, n4, object2);
        MaterialButton materialButton = (MaterialButton)object;
        this.setGeneratedIdIfNeeded(materialButton);
        this.setupButtonChild(materialButton);
        this.b(materialButton.getId(), materialButton.isChecked());
        k k4 = materialButton.getShapeAppearanceModel();
        object = this.a;
        c c4 = k4.e;
        c c5 = k4.f;
        c c6 = k4.g;
        ((ArrayList)object).add(new e(c4, k4.h, c5, c6));
        materialButton.setEnabled(this.isEnabled());
        t0.l((View)materialButton, new j1.d(0, (Object)this));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void b(int n4, boolean bl) {
        if (n4 == -1) {
            StringBuilder stringBuilder = new StringBuilder("Button ID is not valid: ");
            stringBuilder.append(n4);
            Log.e((String)"MButtonToggleGroup", (String)stringBuilder.toString());
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(this.j);
        if (bl && !hashSet.contains(n4)) {
            if (this.g && !hashSet.isEmpty()) {
                hashSet.clear();
            }
            hashSet.add(n4);
        } else {
            if (bl) return;
            if (!hashSet.contains(n4)) return;
            if (!this.h || hashSet.size() > 1) {
                hashSet.remove(n4);
            }
        }
        this.e(hashSet);
    }

    public final MaterialButton c(int n4) {
        return (MaterialButton)this.getChildAt(n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean d(int n4) {
        if (this.getChildAt(n4).getVisibility() == 8) return false;
        return true;
    }

    public final void dispatchDraw(Canvas canvas) {
        TreeMap<MaterialButton, Integer> treeMap = new TreeMap<MaterialButton, Integer>(this.d);
        int n4 = this.getChildCount();
        for (int i4 = 0; i4 < n4; ++i4) {
            treeMap.put(this.c(i4), i4);
        }
        this.e = treeMap.values().toArray(new Integer[0]);
        super.dispatchDraw(canvas);
    }

    public final void e(Set set) {
        HashSet hashSet = this.j;
        this.j = new HashSet(set);
        for (int i4 = 0; i4 < this.getChildCount(); ++i4) {
            int n4 = this.c(i4).getId();
            boolean bl = set.contains(n4);
            Object object = this.findViewById(n4);
            if (object instanceof MaterialButton) {
                this.f = true;
                ((MaterialButton)object).setChecked(bl);
                this.f = false;
            }
            if (hashSet.contains(n4) == set.contains(n4)) continue;
            set.contains(n4);
            object = ((AbstractCollection)this.c).iterator();
            while (object.hasNext()) {
                ((h)object.next()).a();
            }
        }
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void f() {
        int n4 = this.getChildCount();
        int n5 = this.getFirstVisibleChildIndex();
        int n6 = this.getLastVisibleChildIndex();
        int n7 = 0;
        while (n7 < n4) {
            MaterialButton materialButton = this.c(n7);
            if (materialButton.getVisibility() != 8) {
                Object object = materialButton.getShapeAppearanceModel();
                object.getClass();
                j j4 = new j((k)object);
                object = (e)this.a.get(n7);
                if (n5 != n6) {
                    boolean bl = this.getOrientation() == 0;
                    a a4 = j1.e.e;
                    object = n7 == n5 ? (bl ? (d2.d.d0((View)this) ? new e(a4, a4, ((e)object).b, ((e)object).c) : new e(((e)object).a, ((e)object).d, a4, a4)) : new e(((e)object).a, a4, ((e)object).b, a4)) : (n7 == n6 ? (bl ? (d2.d.d0((View)this) ? new e(((e)object).a, ((e)object).d, a4, a4) : new e(a4, a4, ((e)object).b, ((e)object).c)) : new e(a4, ((e)object).d, a4, ((e)object).c)) : null);
                }
                if (object == null) {
                    j4.e = new a(0.0f);
                    j4.f = new a(0.0f);
                    j4.g = new a(0.0f);
                    j4.h = new a(0.0f);
                } else {
                    j4.e = ((e)object).a;
                    j4.h = ((e)object).d;
                    j4.f = ((e)object).b;
                    j4.g = ((e)object).c;
                }
                materialButton.setShapeAppearanceModel(new k(j4));
            }
            ++n7;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCheckedButtonId() {
        if (!this.g) return -1;
        if (this.j.isEmpty()) return -1;
        return (Integer)this.j.iterator().next();
    }

    public List<Integer> getCheckedButtonIds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i4 = 0; i4 < this.getChildCount(); ++i4) {
            int n4 = this.c(i4).getId();
            if (!this.j.contains(n4)) continue;
            arrayList.add(n4);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getChildDrawingOrder(int n4, int n5) {
        Integer[] integerArray = this.e;
        if (integerArray != null) {
            if (n5 < integerArray.length) return integerArray[n5];
        }
        Log.w((String)"MButtonToggleGroup", (String)"Child order wasn't updated");
        return n5;
    }

    public final void onFinishInflate() {
        super.onFinishInflate();
        int n4 = this.i;
        if (n4 != -1) {
            this.e(Collections.singleton(n4));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        int n4 = this.getVisibleButtonCount();
        int n5 = this.g ? 1 : 2;
        accessibilityNodeInfo.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain((int)1, (int)n4, (boolean)false, (int)n5));
    }

    public final void onMeasure(int n4, int n5) {
        this.f();
        this.a();
        super.onMeasure(n4, n5);
    }

    public final void onViewRemoved(View view) {
        int n4;
        super.onViewRemoved(view);
        if (view instanceof MaterialButton) {
            ((MaterialButton)view).setOnPressedChangeListenerInternal(null);
        }
        if ((n4 = this.indexOfChild(view)) >= 0) {
            this.a.remove(n4);
        }
        this.f();
        this.a();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i4 = 0; i4 < this.getChildCount(); ++i4) {
            this.c(i4).setEnabled(bl);
        }
    }

    public void setSelectionRequired(boolean bl) {
        this.h = bl;
    }

    public void setSingleSelection(int n4) {
        this.setSingleSelection(this.getResources().getBoolean(n4));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSingleSelection(boolean bl) {
        if (this.g != bl) {
            this.g = bl;
            this.e(new HashSet());
        }
        int n4 = 0;
        while (n4 < this.getChildCount()) {
            Object object = this.g ? RadioButton.class : ToggleButton.class;
            object = ((Class)object).getName();
            this.c(n4).setA11yClassName((String)object);
            ++n4;
        }
        return;
    }
}

