/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Parcelable;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.Checkable;
import android.widget.CompoundButton;
import androidx.appcompat.widget.t;
import com.google.android.material.button.MaterialButtonToggleGroup;
import d.p0;
import d2.d;
import d2.f;
import e0.t0;
import j1.b;
import j1.c;
import java.util.AbstractCollection;
import java.util.LinkedHashSet;
import java.util.WeakHashMap;
import w1.j;
import w1.k;
import w1.v;
import y.a;

public class MaterialButton
extends t
implements Checkable,
v {
    public static final int[] r = new int[]{16842911};
    public static final int[] s = new int[]{0x10100A0};
    public final c d;
    public final LinkedHashSet e = new LinkedHashSet();
    public j1.a f;
    public PorterDuff.Mode g;
    public ColorStateList h;
    public Drawable i;
    public String j;
    public int k;
    public int l;
    public int m;
    public int n;
    public boolean o = false;
    public boolean p = false;
    public int q;

    /*
     * Enabled aggressive block sorting
     */
    public MaterialButton(Context context, AttributeSet object) {
        super(d2.d.Y0(context, (AttributeSet)object, 2130903780, 2131756029), (AttributeSet)object, 2130903780);
        int n4;
        Object object2 = this.getContext();
        context = d2.f.Y((Context)object2, (AttributeSet)object, d1.a.j, 2130903780, 2131756029, new int[0]);
        this.n = context.getDimensionPixelSize(12, 0);
        this.g = d2.d.r0(context.getInt(15, -1), PorterDuff.Mode.SRC_IN);
        this.h = d2.d.E(this.getContext(), (TypedArray)context, 14);
        this.i = d2.d.J(this.getContext(), (TypedArray)context, 10);
        this.q = context.getInteger(11, 1);
        this.k = context.getDimensionPixelSize(13, 0);
        this.d = object = new c(this, new k(w1.k.b((Context)object2, (AttributeSet)object, 2130903780, 2131756029)));
        ((c)object).c = context.getDimensionPixelOffset(1, 0);
        ((c)object).d = context.getDimensionPixelOffset(2, 0);
        ((c)object).e = context.getDimensionPixelOffset(3, 0);
        ((c)object).f = context.getDimensionPixelOffset(4, 0);
        if (context.hasValue(8)) {
            ((c)object).g = n4 = context.getDimensionPixelSize(8, -1);
            object2 = ((c)object).b;
            float f4 = n4;
            object2.getClass();
            object2 = new j((k)object2);
            ((j)object2).e = new w1.a(f4);
            ((j)object2).f = new w1.a(f4);
            ((j)object2).g = new w1.a(f4);
            ((j)object2).h = new w1.a(f4);
            ((c)object).c(new k((j)object2));
            ((c)object).p = true;
        }
        ((c)object).h = context.getDimensionPixelSize(20, 0);
        ((c)object).i = d2.d.r0(context.getInt(7, -1), PorterDuff.Mode.SRC_IN);
        ((c)object).j = d2.d.E(this.getContext(), (TypedArray)context, 6);
        ((c)object).k = d2.d.E(this.getContext(), (TypedArray)context, 19);
        ((c)object).l = d2.d.E(this.getContext(), (TypedArray)context, 16);
        ((c)object).q = context.getBoolean(5, false);
        ((c)object).t = context.getDimensionPixelSize(9, 0);
        ((c)object).r = context.getBoolean(21, true);
        object2 = t0.a;
        int n5 = this.getPaddingStart();
        n4 = this.getPaddingTop();
        int n6 = this.getPaddingEnd();
        int n7 = this.getPaddingBottom();
        if (context.hasValue(0)) {
            ((c)object).o = true;
            this.setSupportBackgroundTintList(((c)object).j);
            this.setSupportBackgroundTintMode(((c)object).i);
        } else {
            ((c)object).e();
        }
        this.setPaddingRelative(n5 + ((c)object).c, n4 + ((c)object).e, n6 + ((c)object).d, ((c)object).f + n7);
        context.recycle();
        this.setCompoundDrawablePadding(this.n);
        boolean bl = this.i != null;
        this.c(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Layout.Alignment getActualTextAlignment() {
        int n4 = this.getTextAlignment();
        if (n4 == 1) return this.getGravityTextAlignment();
        if (n4 == 6) return Layout.Alignment.ALIGN_OPPOSITE;
        if (n4 == 3) return Layout.Alignment.ALIGN_OPPOSITE;
        if (n4 == 4) return Layout.Alignment.ALIGN_CENTER;
        return Layout.Alignment.ALIGN_NORMAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Layout.Alignment getGravityTextAlignment() {
        int n4 = this.getGravity() & 0x800007;
        if (n4 == 1) return Layout.Alignment.ALIGN_CENTER;
        if (n4 == 5) return Layout.Alignment.ALIGN_OPPOSITE;
        if (n4 == 0x800005) return Layout.Alignment.ALIGN_OPPOSITE;
        return Layout.Alignment.ALIGN_NORMAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getTextHeight() {
        String string;
        if (this.getLineCount() > 1) {
            return this.getLayout().getHeight();
        }
        TextPaint textPaint = this.getPaint();
        String string2 = string = this.getText().toString();
        if (this.getTransformationMethod() != null) {
            string2 = this.getTransformationMethod().getTransformation((CharSequence)string, (View)this).toString();
        }
        string = new Rect();
        textPaint.getTextBounds(string2, 0, string2.length(), (Rect)string);
        return Math.min(string.height(), this.getLayout().getHeight());
    }

    private int getTextLayoutWidth() {
        int n4 = this.getLineCount();
        float f4 = 0.0f;
        for (int i4 = 0; i4 < n4; ++i4) {
            f4 = Math.max(f4, this.getLayout().getLineWidth(i4));
        }
        return (int)Math.ceil(f4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean a() {
        c c4 = this.d;
        if (c4 == null) return false;
        if (c4.o) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void b() {
        boolean bl;
        block6: {
            block5: {
                boolean bl2 = false;
                int n4 = this.q;
                bl = n4 == 1 || n4 == 2;
                if (bl) {
                    this.setCompoundDrawablesRelative(this.i, null, null, null);
                    return;
                }
                bl = n4 == 3 || n4 == 4;
                if (bl) {
                    this.setCompoundDrawablesRelative(null, null, this.i, null);
                    return;
                }
                if (n4 == 16) break block5;
                bl = bl2;
                if (n4 != 32) break block6;
            }
            bl = true;
        }
        if (!bl) return;
        this.setCompoundDrawablesRelative(null, this.i, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void c(boolean bl) {
        int n4;
        int n5;
        Drawable drawable = this.i;
        if (drawable != null) {
            this.i = drawable = drawable.mutate();
            y.a.h(drawable, this.h);
            drawable = this.g;
            if (drawable != null) {
                y.a.i(this.i, (PorterDuff.Mode)drawable);
            }
            if ((n5 = this.k) == 0) {
                n5 = this.i.getIntrinsicWidth();
            }
            if ((n4 = this.k) == 0) {
                n4 = this.i.getIntrinsicHeight();
            }
            drawable = this.i;
            int n6 = this.l;
            int n7 = this.m;
            drawable.setBounds(n6, n7, n5 + n6, n4 + n7);
            this.i.setVisible(true, bl);
        }
        if (bl) {
            this.b();
            return;
        }
        Drawable drawable2 = this.getCompoundDrawablesRelative();
        Drawable drawable3 = drawable2[0];
        drawable = drawable2[1];
        drawable2 = drawable2[2];
        n4 = this.q;
        n5 = n4 == 1 || n4 == 2 ? 1 : 0;
        n5 = !(n5 != 0 && drawable3 != this.i || (n5 = n4 == 3 || n4 == 4 ? 1 : 0) != 0 && drawable2 != this.i) ? ((n5 = n4 == 16 || n4 == 32 ? 1 : 0) != 0 && drawable != this.i ? 1 : 0) : 1;
        if (n5 == 0) return;
        this.b();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void d(int n4, int n5) {
        block14: {
            Layout.Alignment alignment;
            int n6;
            int n7;
            block11: {
                block13: {
                    block12: {
                        int n8;
                        int n9;
                        block10: {
                            n7 = 1;
                            n9 = 1;
                            if (this.i == null) return;
                            if (this.getLayout() == null) {
                                return;
                            }
                            n8 = this.q;
                            n6 = n8 == 1 || n8 == 2 ? 1 : 0;
                            if (n6 == 0 && (n6 = n8 == 3 || n8 == 4 ? 1 : 0) == 0) break block10;
                            this.m = 0;
                            alignment = this.getActualTextAlignment();
                            n5 = this.q;
                            if (n5 != 1 && n5 != 3 && (n5 != 2 || alignment != Layout.Alignment.ALIGN_NORMAL) && (n5 != 4 || alignment != Layout.Alignment.ALIGN_OPPOSITE)) break block11;
                            this.l = 0;
                            break block12;
                        }
                        n4 = n9;
                        if (n8 != 16) {
                            n4 = n8 == 32 ? n9 : 0;
                        }
                        if (n4 == 0) return;
                        this.l = 0;
                        if (n8 != 16) break block13;
                        this.m = 0;
                    }
                    this.c(false);
                    return;
                }
                n4 = n6 = this.k;
                if (n6 == 0) {
                    n4 = this.i.getIntrinsicHeight();
                }
                if (this.m == (n4 = Math.max(0, (n5 - this.getTextHeight() - this.getPaddingTop() - n4 - this.n - this.getPaddingBottom()) / 2))) return;
                this.m = n4;
                break block14;
            }
            n5 = n6 = this.k;
            if (n6 == 0) {
                n5 = this.i.getIntrinsicWidth();
            }
            n6 = this.getTextLayoutWidth();
            WeakHashMap weakHashMap = t0.a;
            n4 = n5 = n4 - n6 - this.getPaddingEnd() - n5 - this.n - this.getPaddingStart();
            if (alignment == Layout.Alignment.ALIGN_CENTER) {
                n4 = n5 / 2;
            }
            n5 = this.getLayoutDirection() == 1 ? 1 : 0;
            if (this.q != 4) {
                n7 = 0;
            }
            n6 = n4;
            if (n5 != n7) {
                n6 = -n4;
            }
            if (this.l == n6) return;
            this.l = n6;
        }
        this.c(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getA11yClassName() {
        if (!TextUtils.isEmpty((CharSequence)this.j)) {
            return this.j;
        }
        Object object = this.d;
        boolean bl = object != null && ((c)object).q;
        object = bl ? CompoundButton.class : Button.class;
        return ((Class)object).getName();
    }

    public ColorStateList getBackgroundTintList() {
        return this.getSupportBackgroundTintList();
    }

    public PorterDuff.Mode getBackgroundTintMode() {
        return this.getSupportBackgroundTintMode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCornerRadius() {
        if (!this.a()) return 0;
        return this.d.g;
    }

    public Drawable getIcon() {
        return this.i;
    }

    public int getIconGravity() {
        return this.q;
    }

    public int getIconPadding() {
        return this.n;
    }

    public int getIconSize() {
        return this.k;
    }

    public ColorStateList getIconTint() {
        return this.h;
    }

    public PorterDuff.Mode getIconTintMode() {
        return this.g;
    }

    public int getInsetBottom() {
        return this.d.f;
    }

    public int getInsetTop() {
        return this.d.e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ColorStateList getRippleColor() {
        if (!this.a()) return null;
        return this.d.l;
    }

    public k getShapeAppearanceModel() {
        if (this.a()) {
            return this.d.b;
        }
        throw new IllegalStateException("Attempted to get ShapeAppearanceModel from a MaterialButton which has an overwritten background.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ColorStateList getStrokeColor() {
        if (!this.a()) return null;
        return this.d.k;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getStrokeWidth() {
        if (!this.a()) return 0;
        return this.d.h;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ColorStateList getSupportBackgroundTintList() {
        if (!this.a()) return super.getSupportBackgroundTintList();
        return this.d.j;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PorterDuff.Mode getSupportBackgroundTintMode() {
        if (!this.a()) return super.getSupportBackgroundTintMode();
        return this.d.i;
    }

    public final boolean isChecked() {
        return this.o;
    }

    public final void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.a()) {
            d2.d.J0((View)this, this.d.b(false));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int[] onCreateDrawableState(int n4) {
        int[] nArray = super.onCreateDrawableState(n4 + 2);
        c c4 = this.d;
        n4 = c4 != null && c4.q ? 1 : 0;
        if (n4 != 0) {
            View.mergeDrawableStates((int[])nArray, (int[])r);
        }
        if (this.isChecked()) {
            View.mergeDrawableStates((int[])nArray, (int[])s);
        }
        return nArray;
    }

    @Override
    public final void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)this.getA11yClassName());
        accessibilityEvent.setChecked(this.isChecked());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)this.getA11yClassName());
        c c4 = this.d;
        boolean bl = c4 != null && c4.q;
        accessibilityNodeInfo.setCheckable(bl);
        accessibilityNodeInfo.setChecked(this.isChecked());
        accessibilityNodeInfo.setClickable(this.isClickable());
    }

    @Override
    public final void onLayout(boolean bl, int n4, int n5, int n6, int n7) {
        super.onLayout(bl, n4, n5, n6, n7);
        this.d(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof b)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        parcelable = (b)parcelable;
        super.onRestoreInstanceState(parcelable.a);
        this.setChecked(parcelable.c);
    }

    public final Parcelable onSaveInstanceState() {
        b b4 = new b(super.onSaveInstanceState());
        b4.c = this.o;
        return b4;
    }

    @Override
    public final void onTextChanged(CharSequence charSequence, int n4, int n5, int n6) {
        super.onTextChanged(charSequence, n4, n5, n6);
        this.d(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    public final boolean performClick() {
        if (this.d.r) {
            this.toggle();
        }
        return super.performClick();
    }

    public final void refreshDrawableState() {
        int[] nArray;
        super.refreshDrawableState();
        if (this.i != null && this.i.setState(nArray = this.getDrawableState())) {
            this.invalidate();
        }
    }

    public void setA11yClassName(String string) {
        this.j = string;
    }

    public void setBackground(Drawable drawable) {
        this.setBackgroundDrawable(drawable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBackgroundColor(int n4) {
        if (this.a()) {
            c c4 = this.d;
            if (c4.b(false) != null) {
                c4.b(false).setTint(n4);
            }
            return;
        }
        super.setBackgroundColor(n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBackgroundDrawable(Drawable drawable) {
        block4: {
            block3: {
                if (!this.a()) break block3;
                if (drawable == this.getBackground()) break block4;
                Log.w((String)"MaterialButton", (String)"MaterialButton manages its own background to control elevation, shape, color and states. Consider using backgroundTint, shapeAppearance and other attributes where available. A custom background will ignore these attributes and you should consider handling interaction states such as pressed, focused and disabled");
                c c4 = this.d;
                c4.o = true;
                ColorStateList colorStateList = c4.j;
                MaterialButton materialButton = c4.a;
                materialButton.setSupportBackgroundTintList(colorStateList);
                materialButton.setSupportBackgroundTintMode(c4.i);
            }
            super.setBackgroundDrawable(drawable);
            return;
        }
        this.getBackground().setState(drawable.getState());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setBackgroundResource(int n4) {
        Drawable drawable = n4 != 0 ? d2.d.I(this.getContext(), n4) : null;
        this.setBackgroundDrawable(drawable);
    }

    public void setBackgroundTintList(ColorStateList colorStateList) {
        this.setSupportBackgroundTintList(colorStateList);
    }

    public void setBackgroundTintMode(PorterDuff.Mode mode) {
        this.setSupportBackgroundTintMode(mode);
    }

    public void setCheckable(boolean bl) {
        if (this.a()) {
            this.d.q = bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setChecked(boolean bl) {
        Object object = this.d;
        boolean bl2 = object != null && ((c)object).q;
        if (!bl2) return;
        if (!this.isEnabled()) return;
        if (this.o == bl) return;
        this.o = bl;
        this.refreshDrawableState();
        if (this.getParent() instanceof MaterialButtonToggleGroup) {
            object = (MaterialButtonToggleGroup)this.getParent();
            bl = this.o;
            if (!((MaterialButtonToggleGroup)((Object)object)).f) {
                ((MaterialButtonToggleGroup)((Object)object)).b(this.getId(), bl);
            }
        }
        if (this.p) {
            return;
        }
        this.p = true;
        object = ((AbstractCollection)this.e).iterator();
        if (!object.hasNext()) {
            this.p = false;
            return;
        }
        androidx.activity.result.d.i(object.next());
        throw null;
    }

    public void setCornerRadius(int n4) {
        if (this.a()) {
            c c4 = this.d;
            if (!c4.p || c4.g != n4) {
                c4.g = n4;
                c4.p = true;
                Object object = c4.b;
                float f4 = n4;
                object.getClass();
                object = new j((k)object);
                ((j)object).e = new w1.a(f4);
                ((j)object).f = new w1.a(f4);
                ((j)object).g = new w1.a(f4);
                ((j)object).h = new w1.a(f4);
                c4.c(new k((j)object));
            }
        }
    }

    public void setCornerRadiusResource(int n4) {
        if (this.a()) {
            this.setCornerRadius(this.getResources().getDimensionPixelSize(n4));
        }
    }

    public void setElevation(float f4) {
        super.setElevation(f4);
        if (this.a()) {
            this.d.b(false).i(f4);
        }
    }

    public void setIcon(Drawable drawable) {
        if (this.i != drawable) {
            this.i = drawable;
            this.c(true);
            this.d(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    public void setIconGravity(int n4) {
        if (this.q != n4) {
            this.q = n4;
            this.d(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    public void setIconPadding(int n4) {
        if (this.n != n4) {
            this.n = n4;
            this.setCompoundDrawablePadding(n4);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setIconResource(int n4) {
        Drawable drawable = n4 != 0 ? d2.d.I(this.getContext(), n4) : null;
        this.setIcon(drawable);
    }

    public void setIconSize(int n4) {
        if (n4 >= 0) {
            if (this.k != n4) {
                this.k = n4;
                this.c(true);
            }
            return;
        }
        throw new IllegalArgumentException("iconSize cannot be less than 0");
    }

    public void setIconTint(ColorStateList colorStateList) {
        if (this.h != colorStateList) {
            this.h = colorStateList;
            this.c(false);
        }
    }

    public void setIconTintMode(PorterDuff.Mode mode) {
        if (this.g != mode) {
            this.g = mode;
            this.c(false);
        }
    }

    public void setIconTintResource(int n4) {
        this.setIconTint(d2.d.D(this.getContext(), n4));
    }

    public void setInsetBottom(int n4) {
        c c4 = this.d;
        c4.d(c4.e, n4);
    }

    public void setInsetTop(int n4) {
        c c4 = this.d;
        c4.d(n4, c4.f);
    }

    public void setInternalBackground(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
    }

    public void setOnPressedChangeListenerInternal(j1.a a4) {
        this.f = a4;
    }

    public void setPressed(boolean bl) {
        j1.a a4 = this.f;
        if (a4 != null) {
            ((MaterialButtonToggleGroup)((Object)((p0)a4).b)).invalidate();
        }
        super.setPressed(bl);
    }

    public void setRippleColor(ColorStateList colorStateList) {
        if (this.a()) {
            Object object = this.d;
            if (((c)object).l != colorStateList) {
                ((c)object).l = colorStateList;
                object = ((c)object).a;
                if (object.getBackground() instanceof RippleDrawable) {
                    ((RippleDrawable)object.getBackground()).setColor(u1.a.a(colorStateList));
                }
            }
        }
    }

    public void setRippleColorResource(int n4) {
        if (this.a()) {
            this.setRippleColor(d2.d.D(this.getContext(), n4));
        }
    }

    @Override
    public void setShapeAppearanceModel(k k4) {
        if (this.a()) {
            this.d.c(k4);
            return;
        }
        throw new IllegalStateException("Attempted to set ShapeAppearanceModel on a MaterialButton which has an overwritten background.");
    }

    public void setShouldDrawSurfaceColorStroke(boolean bl) {
        if (this.a()) {
            c c4 = this.d;
            c4.n = bl;
            c4.f();
        }
    }

    public void setStrokeColor(ColorStateList colorStateList) {
        if (this.a()) {
            c c4 = this.d;
            if (c4.k != colorStateList) {
                c4.k = colorStateList;
                c4.f();
            }
        }
    }

    public void setStrokeColorResource(int n4) {
        if (this.a()) {
            this.setStrokeColor(d2.d.D(this.getContext(), n4));
        }
    }

    public void setStrokeWidth(int n4) {
        if (this.a()) {
            c c4 = this.d;
            if (c4.h != n4) {
                c4.h = n4;
                c4.f();
            }
        }
    }

    public void setStrokeWidthResource(int n4) {
        if (this.a()) {
            this.setStrokeWidth(this.getResources().getDimensionPixelSize(n4));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        if (this.a()) {
            c c4 = this.d;
            if (c4.j != colorStateList) {
                c4.j = colorStateList;
                if (c4.b(false) != null) {
                    y.a.h(c4.b(false), c4.j);
                }
            }
            return;
        }
        super.setSupportBackgroundTintList(colorStateList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        if (this.a()) {
            c c4 = this.d;
            if (c4.i != mode) {
                c4.i = mode;
                if (c4.b(false) != null && c4.i != null) {
                    y.a.i(c4.b(false), c4.i);
                }
            }
            return;
        }
        super.setSupportBackgroundTintMode(mode);
    }

    public void setTextAlignment(int n4) {
        super.setTextAlignment(n4);
        this.d(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    public void setToggleCheckedStateOnClick(boolean bl) {
        this.d.r = bl;
    }

    public final void toggle() {
        this.setChecked(this.o ^ true);
    }
}

