/*
 * Decompiled with CFR 0.152.
 */
package com.killercraft.jimy.BARunnable;

import com.killercraft.jimy.BAAPI.AttributeSupplier;
import com.killercraft.jimy.BAAPI.AttributeSupplierManager;
import com.killercraft.jimy.BigAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerSuitRunnable
implements Runnable {
    @Override
    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerSuitRunnable.checkPlayerSuit(player);
        }
    }

    private static void checkPlayerSuit(Player player) {
        PlayerInventory inv = player.getInventory();
        HashMap<String, Integer> armorSuitMap = new HashMap<String, Integer>();
        PlayerSuitRunnable.checkStack(inv.getHelmet(), armorSuitMap);
        PlayerSuitRunnable.checkStack(inv.getChestplate(), armorSuitMap);
        PlayerSuitRunnable.checkStack(inv.getLeggings(), armorSuitMap);
        PlayerSuitRunnable.checkStack(inv.getBoots(), armorSuitMap);
        HashMap<String, AttributeSupplier> managers = AttributeSupplierManager.getAtrManager();
        for (String pluginName : managers.keySet()) {
            AttributeSupplier supplier = managers.get(pluginName);
            try {
                PlayerSuitRunnable.checkLore(supplier.getSuitLore(player), armorSuitMap);
            }
            catch (Throwable e) {
                System.out.println("[" + pluginName + "]Check Suit Lore Error!");
            }
        }
        Iterator<Map.Entry<String, Integer>> it = armorSuitMap.entrySet().iterator();
        ArrayList<HashMap<String, Integer>> atrList = new ArrayList<HashMap<String, Integer>>();
        while (it.hasNext()) {
            Map.Entry<String, Integer> e = it.next();
            HashMap<String, Integer> sumAttribute = PlayerSuitRunnable.getSuitAttribute(e.getValue(), e.getKey());
            if (sumAttribute == null) continue;
            atrList.add(sumAttribute);
        }
        HashMap<String, Integer> atrSumMap = new HashMap<String, Integer>();
        for (HashMap hashMap : atrList) {
            for (String key : hashMap.keySet()) {
                if (atrSumMap.containsKey(key)) {
                    atrSumMap.put(key, (Integer)atrSumMap.get(key) + (Integer)hashMap.get(key));
                    continue;
                }
                atrSumMap.put(key, (Integer)hashMap.get(key));
            }
        }
        if (atrSumMap.isEmpty()) {
            BigAttribute.playerMap.remove(player);
        } else {
            BigAttribute.playerMap.put(player, atrSumMap);
        }
    }

    private static void checkLore(List<String> loreList, HashMap<String, Integer> armorSuitMap) {
        for (String lore : loreList) {
            if (!lore.startsWith(BigAttribute.suit)) continue;
            String key = ChatColor.stripColor((String)lore.replace(BigAttribute.suit, ""));
            if (armorSuitMap.containsKey(key)) {
                armorSuitMap.put(key, armorSuitMap.get(key) + 1);
                continue;
            }
            armorSuitMap.put(key, 1);
        }
    }

    private static void checkStack(ItemStack stack, HashMap<String, Integer> armorSuitMap) {
        ItemMeta meta;
        if (stack != null && stack.hasItemMeta() && (meta = stack.getItemMeta()).hasLore()) {
            List loreList = meta.getLore();
            for (String lore : loreList) {
                if (!lore.startsWith(BigAttribute.suit)) continue;
                String key = ChatColor.stripColor((String)lore.replace(BigAttribute.suit, ""));
                if (armorSuitMap.containsKey(key)) {
                    armorSuitMap.put(key, armorSuitMap.get(key) + 1);
                    continue;
                }
                armorSuitMap.put(key, 1);
            }
        }
    }

    private static HashMap<String, Integer> getSuitAttribute(int need, String lore) {
        HashMap<Integer, HashMap<String, Integer>> needMap;
        if (BigAttribute.suitMap.containsKey(lore) && (needMap = BigAttribute.suitMap.get(lore)).containsKey(need)) {
            return needMap.get(need);
        }
        return null;
    }
}

