/*
 * Decompiled with CFR 0.152.
 */
package com.killercraft.jimy.BAListener;

import com.killercraft.jimy.BAAPI.AttributeSupplier;
import com.killercraft.jimy.BAAPI.AttributeSupplierManager;
import com.killercraft.jimy.BAManager.DamageAtr;
import com.killercraft.jimy.BAUtils.BAGetArmourUtil;
import com.killercraft.jimy.BAUtils.BAGetSuitAttributeUtil;
import com.killercraft.jimy.BigAttribute;
import java.util.HashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class BAPlayerDamageListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        Player damagerPlayer;
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Entity damager = event.getDamager();
        Player player = (Player)event.getEntity();
        DamageAtr atr = new DamageAtr();
        double damageSum = event.getDamage();
        if (damager instanceof Player) {
            damagerPlayer = (Player)event.getDamager();
        } else {
            damagerPlayer = null;
            atr.setMob(true);
        }
        BAGetArmourUtil.getAmour(player, atr);
        BAGetSuitAttributeUtil.checkSuit(atr, player);
        HashMap<String, AttributeSupplier> managers = AttributeSupplierManager.getAtrManager();
        for (String pluginName : managers.keySet()) {
            AttributeSupplier supplier = managers.get(pluginName);
            try {
                BAGetArmourUtil.checkLore(supplier.getDamageAtr(player), atr);
            }
            catch (Throwable e) {
                System.out.println("[" + pluginName + "]Check Damage Atr Error!");
            }
        }
        atr.formatAtr();
        int armor = atr.getArmor();
        int dodge = atr.getDodge();
        int block = atr.getBlock();
        int injury = atr.getInjury();
        boolean isDodge = false;
        boolean isInjury = false;
        double breaker = 0.0;
        double noDodge = 0.0;
        double noBlock = 0.0;
        double unsafeBreaker = 0.0;
        double unsafeNoDodge = 0.0;
        double unsafeNoBlock = 0.0;
        if (damagerPlayer != null) {
            HashMap<Object, Object> hitPlayerMap = new HashMap();
            if (BigAttribute.playerMap.containsKey(damagerPlayer)) {
                hitPlayerMap = BigAttribute.playerMap.get(damagerPlayer);
            }
            for (String key : hitPlayerMap.keySet()) {
                if (key.startsWith(BigAttribute.onUnsafeL)) {
                    if (key.contains(BigAttribute.armorBreak)) {
                        unsafeBreaker += (double)((Integer)hitPlayerMap.get(key)).intValue();
                        continue;
                    }
                    if (key.contains(BigAttribute.dodgeBreaker)) {
                        unsafeNoDodge += (double)((Integer)hitPlayerMap.get(key)).intValue();
                        continue;
                    }
                    if (!key.contains(BigAttribute.blockBreakerL)) continue;
                    unsafeNoBlock += (double)((Integer)hitPlayerMap.get(key)).intValue();
                    continue;
                }
                if (key.contains(BigAttribute.armorBreak)) {
                    breaker += (double)((Integer)hitPlayerMap.get(key)).intValue();
                    continue;
                }
                if (key.contains(BigAttribute.dodgeBreaker)) {
                    noDodge += (double)((Integer)hitPlayerMap.get(key)).intValue();
                    continue;
                }
                if (!key.contains(BigAttribute.blockBreakerL)) continue;
                noBlock += (double)((Integer)hitPlayerMap.get(key)).intValue();
            }
        }
        if (breaker > (double)BigAttribute.armorBreakX) {
            breaker = BigAttribute.armorBreakX;
        }
        breaker += unsafeBreaker;
        if (noDodge > (double)BigAttribute.dodgeBreakerX) {
            noDodge = BigAttribute.dodgeBreakerX;
        }
        noDodge += unsafeNoDodge;
        if (noBlock > (double)BigAttribute.blockBreakerX) {
            noBlock = BigAttribute.blockBreakerX;
        }
        int random = (int)(Math.random() * 101.0);
        int random2 = (int)(Math.random() * 101.0);
        int random3 = (int)(Math.random() * 101.0);
        block = (int)((double)block - (noBlock += unsafeNoBlock));
        dodge = (int)((double)dodge - noDodge);
        if (random > 0 && dodge >= random) {
            event.setCancelled(true);
            isDodge = true;
        }
        if (random2 > 0 && block >= random2) {
            event.setDamage(0.0);
            player.sendMessage(BigAttribute.blockMessage);
            return;
        }
        armor = (int)((double)armor - (double)armor * breaker / 100.0);
        if (BigAttribute.armorX > 0 && armor > BigAttribute.armorX) {
            armor = BigAttribute.armorX;
        }
        damageSum -= damageSum * (double)armor / 100.0;
        event.setDamage(damageSum);
        if (damagerPlayer != null && random3 > 0 && injury >= random3) {
            int injuryDamage = (int)(damageSum / 3.0);
            if (!damagerPlayer.isDead() && damageSum < 3000.0) {
                if (damagerPlayer.getHealth() > (double)injuryDamage) {
                    damagerPlayer.setHealth(damagerPlayer.getHealth() - (double)injuryDamage);
                } else {
                    damagerPlayer.setHealth(0.001);
                    damagerPlayer.damage(100.0, (Entity)player);
                }
                isInjury = true;
            }
        }
        if (isDodge) {
            player.sendMessage(BigAttribute.dodgeMessage.replaceAll("<number>", (int)damageSum + ""));
            if (null != damagerPlayer) {
                damagerPlayer.sendMessage(BigAttribute.dodgeMessage2.replaceAll("<number>", (int)damageSum + ""));
            }
        }
        if (isInjury) {
            player.sendMessage(BigAttribute.injuryMessage);
            damagerPlayer.sendMessage(BigAttribute.injuryMessage2);
        }
    }
}

