/*
 * Decompiled with CFR 0.152.
 */
package com.killercraft.jimy.BAListener;

import com.killercraft.jimy.BAAPI.AttributeSupplier;
import com.killercraft.jimy.BAAPI.AttributeSupplierManager;
import com.killercraft.jimy.BAManager.AttackAtr;
import com.killercraft.jimy.BAUtils.BAGetArmourAttributeUtil;
import com.killercraft.jimy.BAUtils.BAGetHasUtil;
import com.killercraft.jimy.BAUtils.BAGetSuitAttributeUtil;
import com.killercraft.jimy.BigAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class BAPlayerAttackListener
implements Listener {
    public static List<Entity> noDamageList = new ArrayList<Entity>();

    @EventHandler
    public void onAttackDamage(PlayerInteractEvent event) {
        Action ac = event.getAction();
        if (ac == Action.LEFT_CLICK_AIR) {
            Player player = event.getPlayer();
            ItemStack stack = player.getItemInHand();
            if (!BigAttribute.attackSpeedMap.containsKey(player)) {
                BigAttribute.noDmgSet.remove(player);
                int range = BAPlayerAttackListener.checkItemAttackRange(stack);
                if (range > 1) {
                    BAPlayerAttackListener.interactDamage(player, range + 4);
                }
                BigAttribute.noDmgSet.add(player);
            }
        }
    }

    private static int checkItemAttackRange(ItemStack stack) {
        if (stack == null || !stack.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = stack.getItemMeta();
        if (!meta.hasLore()) {
            return 0;
        }
        for (String lore : meta.getLore()) {
            if (!lore.contains(BigAttribute.attackRangeL)) continue;
            return (int)BAGetHasUtil.getHas(lore);
        }
        return 0;
    }

    public static void interactDamage(Player player, int r) {
        List ents = player.getNearbyEntities((double)r, (double)r, (double)r);
        ArrayList<LivingEntity> livs = new ArrayList<LivingEntity>();
        for (Entity ent : ents) {
            if (!(ent instanceof LivingEntity)) continue;
            livs.add((LivingEntity)ent);
        }
        Location loc = player.getEyeLocation();
        Vector v = new Vector(2.0, (double)(0.0f - loc.getPitch()) * 0.03, 0.0);
        Vector a = player.getLocation().getDirection();
        Vector vc = BAPlayerAttackListener.rotateXZ(v, a);
        for (int i = 1; i < r; ++i) {
            for (LivingEntity lic : livs) {
                if (!BAPlayerAttackListener.isInLoc(loc, lic.getLocation())) continue;
                lic.setNoDamageTicks(0);
                lic.damage(1.0, (Entity)player);
                lic.setNoDamageTicks(12);
                return;
            }
            loc.add(vc);
        }
    }

    private static boolean isInLoc(Location loc1, Location loc2) {
        int x1 = loc1.getBlockX() - loc2.getBlockX();
        int z1 = loc1.getBlockZ() - loc2.getBlockZ();
        int y1 = loc1.getBlockY() - loc2.getBlockY();
        if (y1 < 0) {
            y1 = 0 - y1;
        }
        if (x1 < 0) {
            x1 = 0 - x1;
        }
        if (z1 < 0) {
            z1 = 0 - z1;
        }
        return x1 <= 1 && z1 <= 1 && y1 <= 2;
    }

    private static Vector rotateXZ(Vector origin, Vector direction) {
        double x = origin.getX() * direction.getX() - origin.getZ() * direction.getZ();
        double y = origin.getY();
        double z = origin.getX() * direction.getZ() + origin.getZ() * direction.getX();
        return new Vector(x, y, z);
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (noDamageList.contains(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        AttackAtr atr = new AttackAtr();
        Player player = damager instanceof Player ? (Player)event.getDamager() : null;
        if (player != null) {
            ItemStack ahStack;
            int range;
            if (BigAttribute.noDmgSet.contains(player) && (range = BAPlayerAttackListener.checkItemAttackRange(ahStack = player.getItemInHand())) > 1) {
                event.setCancelled(true);
            }
            if (BigAttribute.damageMap.containsKey(player)) {
                event.setCancelled(true);
                return;
            }
            ItemStack stack = player.getItemInHand();
            if (!(entity instanceof Player)) {
                atr.setMob(true);
            }
            int critArmor = 0;
            BAGetArmourAttributeUtil.checkItem(stack, atr);
            BAGetArmourAttributeUtil.checkItemAOE(stack, atr);
            stack = player.getInventory().getHelmet();
            BAGetArmourAttributeUtil.checkItem(stack, atr);
            stack = player.getInventory().getChestplate();
            BAGetArmourAttributeUtil.checkItem(stack, atr);
            stack = player.getInventory().getLeggings();
            BAGetArmourAttributeUtil.checkItem(stack, atr);
            stack = player.getInventory().getBoots();
            BAGetArmourAttributeUtil.checkItem(stack, atr);
            BAGetSuitAttributeUtil.checkSuit(atr, player);
            HashMap<String, AttributeSupplier> managers = AttributeSupplierManager.getAtrManager();
            for (String pluginName : managers.keySet()) {
                AttributeSupplier supplier = managers.get(pluginName);
                try {
                    BAGetArmourAttributeUtil.checkLore(supplier.getAttackAtr(player), atr);
                }
                catch (Throwable e) {
                    System.out.println("[" + pluginName + "]Check Attack Atr Error!");
                }
            }
            atr.formatAtr();
            double heal = atr.getHeal();
            if (heal > 0.0) {
                double pHealth = player.getHealth();
                double maxHealth = player.getMaxHealth();
                if (pHealth > 0.0) {
                    if (stack != null && stack.getType() != Material.AIR) {
                        if (!BigAttribute.healCdMap.containsKey(player)) {
                            if (pHealth + heal >= maxHealth) {
                                player.setHealth(maxHealth);
                            } else {
                                player.setHealth(pHealth + heal);
                            }
                            BigAttribute.healCdMap.put(player, 5);
                        }
                    } else if (pHealth + heal >= maxHealth) {
                        player.setHealth(maxHealth);
                    } else {
                        player.setHealth(pHealth + heal);
                    }
                }
            }
            int random = (int)(Math.random() * 101.0);
            double damageSum = atr.getDamageSum();
            double damageLevel = atr.getDamageLevel();
            double sumMobDamageLevel = atr.getMobDamageLevel();
            double finalDamage = atr.getFinalDamage();
            double finalTrueDamage = atr.getFinalTrueDamage();
            boolean isCrit = false;
            double atCrit = atr.getCrit();
            double atCritDamage = atr.getCritDamage();
            if (entity instanceof Player) {
                Player ePlayer = (Player)entity;
                PlayerInventory pInve = ePlayer.getInventory();
                ItemStack aStack = pInve.getHelmet();
                critArmor += BAGetArmourAttributeUtil.checkItemCritArmor(aStack);
                aStack = pInve.getChestplate();
                critArmor += BAGetArmourAttributeUtil.checkItemCritArmor(aStack);
                aStack = pInve.getLeggings();
                critArmor += BAGetArmourAttributeUtil.checkItemCritArmor(aStack);
                aStack = pInve.getBoots();
                if (BigAttribute.critArmorX > 0 && (critArmor += BAGetArmourAttributeUtil.checkItemCritArmor(aStack)) > BigAttribute.critArmorX) {
                    critArmor = BigAttribute.critArmorX;
                }
            }
            if ((atCritDamage -= (double)critArmor) < 0.0) {
                atCritDamage = 0.0;
            }
            if (random > 0 && atCrit >= (double)random) {
                damageSum += damageSum * atCritDamage / 100.0;
                isCrit = true;
            }
            if ((damageSum += damageSum * damageLevel / 100.0) < 1.0) {
                damageSum = 1.3;
            }
            if (entity instanceof Damageable) {
                Damageable dmgE = (Damageable)entity;
                double dmgEMaxHealth = dmgE.getMaxHealth();
                if (finalDamage > 0.0) {
                    double finalDamageSum = dmgEMaxHealth * finalDamage / 100.0;
                    if (!(entity instanceof Player) && finalDamageSum >= (double)BigAttribute.mobFinalLimit) {
                        finalDamageSum = BigAttribute.mobFinalLimit;
                    }
                    damageSum += finalDamageSum;
                }
                if (!event.isCancelled() && !BigAttribute.noTrueDamageWords.contains(player.getWorld().getName())) {
                    double trueD = atr.getTrueDamage();
                    double thisTrueDamage = dmgEMaxHealth * finalTrueDamage / 100.0;
                    if (!(entity instanceof Player) && thisTrueDamage >= (double)BigAttribute.mobFinalLimit) {
                        thisTrueDamage = BigAttribute.mobFinalLimit;
                    }
                    thisTrueDamage += trueD;
                    if (dmgE.getHealth() <= thisTrueDamage) {
                        dmgE.setHealth(0.001);
                        damageSum += 100.0;
                    } else {
                        dmgE.setHealth(dmgE.getHealth() - thisTrueDamage);
                    }
                }
                if (!(dmgE instanceof Player)) {
                    damageSum += damageSum * sumMobDamageLevel / 100.0;
                }
            }
            event.setDamage(damageSum);
            if (isCrit) {
                player.sendMessage(BigAttribute.critMessage.replaceAll("<number>", (int)damageSum + ""));
            }
            int aoer = atr.getAoer();
            double aoed = atr.getAoed();
            if (aoer > 0 && aoed > 0.0) {
                List entityList = entity.getNearbyEntities((double)aoer, (double)aoer, (double)aoer);
                for (Entity ent : entityList) {
                    if (ent == player || !(ent instanceof LivingEntity)) continue;
                    noDamageList.add(ent);
                    LivingEntity dgb = (LivingEntity)ent;
                    dgb.setNoDamageTicks(0);
                    dgb.damage(damageSum * aoed / 100.0, (Entity)player);
                    dgb.setNoDamageTicks(13);
                    noDamageList.remove(ent);
                }
            }
            if (!BigAttribute.attackSpeedMap.containsKey(player)) {
                double has = 0 - atr.getAttackSpeed() / 100;
                if ((has = 12.0 + 7.0 * has) <= 0.0) {
                    has = 1.0;
                }
                BigAttribute.attackSpeedMap.put(player, (int)has);
            }
        }
    }
}

