/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicvfx.client.photon.gameobject.particle.ef_trail;

import com.dfdyz.epicvfx.client.photon.fx.EFTrailExecutor;
import com.dfdyz.epicvfx.client.photon.gameobject.emitter.ef_trail.EFTrailConfig;
import com.dfdyz.epicvfx.mixins.accessor.AraTrailParticleAccessor;
import com.lowdragmc.photon.client.fx.IEffectExecutor;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.aratrail.AraTrailConfig;
import com.lowdragmc.photon.client.gameobject.particle.aratrail.AraTrailParticle;
import com.lowdragmc.photon.client.gameobject.particle.aratrail.ElasticArray;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.property.TrailInfo;

public class EFTrailParticle
extends AraTrailParticle {
    public EFTrailExecutor efTrailExecutor;
    public final AraTrailParticleAccessor THIS;
    boolean shouldRemove = false;
    int age = 0;
    int lifeTick;

    public EFTrailParticle(IParticleEmitter emitter, EFTrailConfig config) {
        super(emitter, (AraTrailConfig)config);
        IEffectExecutor iEffectExecutor = emitter.getEffectExecutor();
        if (iEffectExecutor instanceof EFTrailExecutor) {
            EFTrailExecutor patchExecutor;
            this.efTrailExecutor = patchExecutor = (EFTrailExecutor)iEffectExecutor;
            if (config.useEFLifetime()) {
                this.setLifetimeSupplier(this::getLiftTimeEF);
            }
            this.lifeTick = this.efTrailExecutor.trailInfo.trailLifetime();
        }
        this.THIS = (AraTrailParticleAccessor)((Object)this);
    }

    private float getLiftTimeEF() {
        if (this.efTrailExecutor != null) {
            return (float)this.efTrailExecutor.trailInfo.trailLifetime() / 20.0f;
        }
        return this.config.time;
    }

    public void updateTick() {
        super.updateTick();
        if (this.efTrailExecutor != null) {
            if (this.shouldRemove) {
                if (!this.isRemoved && (float)this.age >= this.getLifeTime()) {
                    this.setRemoved(true);
                }
            } else if (!this.efTrailExecutor.canContinue()) {
                this.shouldRemove = true;
                this.lifeTick = this.age + this.efTrailExecutor.trailInfo.trailLifetime();
            }
            ++this.age;
        }
    }

    private float getDeltaTime() {
        return this.emitter.getDeltaTime() / 20.0f;
    }

    private boolean started(float partialTicks) {
        if (this.efTrailExecutor != null) {
            float pet;
            AnimationPlayer animPlayer = this.efTrailExecutor.entityPatch.getAnimator().getPlayerFor(this.efTrailExecutor.animation);
            TrailInfo tInfo = this.efTrailExecutor.trailInfo;
            float cet = animPlayer.getElapsedTime();
            float ret = (cet - (pet = animPlayer.getPrevElapsedTime())) * partialTicks + pet;
            if (ret <= tInfo.startTime() - 0.02f) {
                return false;
            }
        }
        return true;
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        float deltaTime = this.getDeltaTime();
        this.THIS.I_updateDynamicData(partialTicks);
        boolean removed = false;
        if (this.efTrailExecutor != null && !this.efTrailExecutor.canContinue(partialTicks)) {
            removed = true;
        }
        if (deltaTime > 1.0E-5f) {
            this.THIS.I_updateVelocity(deltaTime);
            if (!removed && this.started(partialTicks)) {
                this.THIS.I_emissionStep(deltaTime);
            }
            this.THIS.I_snapLastPointToTransform();
            this.THIS.I_updatePointsLifecycle(deltaTime);
        }
        ElasticArray<AraTrailParticle.Point> points = this.THIS.A_points();
        IntList discontinuities = this.THIS.A_discontinuities();
        this.THIS.I_clearMeshData();
        if (points.size() > 1) {
            int start;
            Matrix4f worldToTrail = this.getWorldToTrail();
            Vector3f localCamPosition = worldToTrail.transformPosition(camera.getPosition().toVector3f());
            discontinuities.clear();
            for (start = 0; start < points.size(); ++start) {
                if (!((AraTrailParticle.Point)points.get((int)start)).discontinuous && start != points.size() - 1) continue;
                discontinuities.add(start);
            }
            start = 0;
            for (int i = 0; i < discontinuities.size(); ++i) {
                this.THIS.I_updateSegmentMesh(start, discontinuities.getInt(i), localCamPosition, partialTicks);
                start = discontinuities.getInt(i) + 1;
            }
            this.renderMesh(buffer, camera, partialTicks);
        }
    }

    private float getFading(float pt) {
        if (this.efTrailExecutor == null) {
            return 1.0f;
        }
        float fading = 1.0f;
        if (this.shouldRemove) {
            fading = TrailInfo.isValidTime((float)this.efTrailExecutor.trailInfo.fadeTime()) ? (float)(this.lifeTick - this.age) / (float)this.efTrailExecutor.trailInfo.trailLifetime() : Mth.clamp((float)(((float)(this.lifeTick - this.age) + (1.0f - pt)) / (float)this.efTrailExecutor.trailInfo.trailLifetime()), (float)0.0f, (float)1.0f);
        }
        return fading;
    }

    private void renderMesh(VertexConsumer buffer, Camera cam, float pt) {
        IntList tris = this.THIS.A_tris();
        if (!this.THIS.A_vertices().isEmpty() && !tris.isEmpty()) {
            Matrix4f renderMatrix = this.getWorldToTrail().invert(new Matrix4f()).translateLocal((Vector3fc)cam.getPosition().toVector3f().negate());
            float fading = this.getFading(pt);
            for (int i = 0; i < tris.size(); i += 3) {
                int i0 = tris.getInt(i);
                int i1 = tris.getInt(i + 1);
                int i2 = tris.getInt(i + 2);
                this.renderVertex(buffer, renderMatrix, i0, fading);
                this.renderVertex(buffer, renderMatrix, i1, fading);
                this.renderVertex(buffer, renderMatrix, i2, fading);
            }
        }
    }

    private void renderVertex(VertexConsumer buffer, Matrix4f renderMatrix, int vertexIndex, float fading) {
        List<Vector3f> vertices = this.THIS.A_vertices();
        List<Vector3f> normals = this.THIS.A_normals();
        List<Vector2f> uvs = this.THIS.A_uvs();
        List<Vector4f> vertColors = this.THIS.A_vertColors();
        if (vertexIndex < vertices.size()) {
            Vector3f pos = new Vector3f((Vector3fc)vertices.get(vertexIndex));
            renderMatrix.transformPosition(pos);
            Vector3f normal = vertexIndex < normals.size() ? new Vector3f((Vector3fc)normals.get(vertexIndex)) : new Vector3f(0.0f, 1.0f, 0.0f);
            renderMatrix.transformDirection(normal);
            Vector2f uv = vertexIndex < uvs.size() ? new Vector2f((Vector2fc)uvs.get(vertexIndex)) : new Vector2f(0.0f);
            Vector4f color = vertexIndex < vertColors.size() ? vertColors.get(vertexIndex) : new Vector4f(1.0f);
            buffer.addVertex(pos.x, pos.y, pos.z).setUv(uv.x, uv.y).setColor(color.x, color.y, color.z, color.w * fading).setLight(0xF000F0).setNormal(normal.x, normal.y, normal.z);
        }
    }
}

