/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicvfx.client.photon.gameobject.emitter.ef_trail;

import com.dfdyz.epicvfx.client.photon.fx.EFPatchExecutor;
import com.dfdyz.epicvfx.client.photon.fx.EFTrailExecutor;
import com.dfdyz.epicvfx.client.photon.gameobject.emitter.ef_trail.EFTrailConfig;
import com.dfdyz.epicvfx.client.photon.gameobject.particle.ef_trail.EFTrailParticle;
import com.lowdragmc.lowdraglib2.configurator.ui.ConfiguratorGroup;
import com.lowdragmc.lowdraglib2.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib2.gui.texture.Icons;
import com.lowdragmc.lowdraglib2.registry.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib2.syncdata.annotation.Persisted;
import com.lowdragmc.photon.client.fx.IEffectExecutor;
import com.lowdragmc.photon.client.gameobject.emitter.Emitter;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.data.RendererSetting;
import com.lowdragmc.photon.client.gameobject.emitter.renderpipeline.RenderPassPipeline;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.property.TrailInfo;

@ParametersAreNonnullByDefault
@LDLRegisterClient(name="ef_trail_emitter", registry="photon:fx_object")
public class EFTrailEmitter
extends Emitter {
    public static final IGuiTexture ICON = Icons.icon((String)"photon", (String)"trail");
    public static int VERSION = 2;
    @Persisted(subPersisted=true)
    public final EFTrailConfig config;
    protected EFTrailParticle trailParticle;

    public EFTrailEmitter() {
        this(new EFTrailConfig());
    }

    public EFTrailEmitter(EFTrailConfig config) {
        this.config = config;
    }

    public IGuiTexture getIcon() {
        return ICON;
    }

    public EFTrailEmitter shallowCopy() {
        return new EFTrailEmitter(this.config);
    }

    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.putInt("_version", VERSION);
        return tag;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        this.config.buildConfigurator(father);
    }

    public int getLifetime() {
        return this.config.getDuration();
    }

    public int getDelay() {
        return super.getDelay();
    }

    protected void updateOrigin() {
        super.updateOrigin();
        this.setLifetime(this.config.getDuration());
    }

    public boolean isLooping() {
        if (this.effectExecutor instanceof EFPatchExecutor) {
            return false;
        }
        return this.config.isLooping();
    }

    public int getParticleAmount() {
        return this.trailParticle.isAlive() ? 1 : 0;
    }

    protected void update() {
        IEffectExecutor iEffectExecutor = this.effectExecutor;
        if (iEffectExecutor instanceof EFTrailExecutor) {
            EFTrailExecutor efTrailExecutor = (EFTrailExecutor)iEffectExecutor;
            if (this.trailParticle.isAlive()) {
                this.trailParticle.updateTick();
            } else {
                this.remove();
            }
            AnimationPlayer animPlayer = efTrailExecutor.entityPatch.getAnimator().getPlayerFor(efTrailExecutor.animation);
            TrailInfo tInfo = efTrailExecutor.trailInfo;
            this.t = Math.clamp((animPlayer.getElapsedTime() - tInfo.startTime()) / (tInfo.endTime() - tInfo.startTime()), 0.0f, 1.0f);
        } else {
            if (this.trailParticle.isAlive()) {
                this.trailParticle.updateTick();
            } else {
                this.remove();
            }
            super.update();
        }
    }

    public void reset() {
        super.reset();
        this.trailParticle = new EFTrailParticle((IParticleEmitter)this, this.config);
    }

    public boolean useTranslucentPipeline() {
        return this.config.renderer.getLayer() == RendererSetting.Layer.Translucent;
    }

    public void prepareRenderPass(RenderPassPipeline buffer) {
        if (this.isVisible()) {
            buffer.pipeQueue(this.trailParticle.getRenderType(), Collections.singleton(this.trailParticle));
        }
    }

    @Nullable
    public AABB getCullBox(float partialTicks) {
        return this.config.renderer.getCull().isEnable() ? this.config.renderer.getCull().getCullAABB((Emitter)this, partialTicks) : null;
    }

    public void remove(boolean force) {
        IEffectExecutor iEffectExecutor;
        this.trailParticle.setRemoved(true);
        super.remove(force);
        if (force) {
            this.trailParticle.clear();
        }
        if (this.config.isDestroyRootOnDeath() && (iEffectExecutor = this.effectExecutor) instanceof EFPatchExecutor) {
            EFPatchExecutor efPatchExecutor = (EFPatchExecutor)iEffectExecutor;
            efPatchExecutor.destroy();
        }
    }
}

