/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicvfx.client.photon.fx;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXEffectExecutor;
import com.lowdragmc.photon.client.fx.IEffectExecutor;
import com.lowdragmc.photon.client.gameobject.FXObject;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class EFPatchExecutor
extends FXEffectExecutor {
    public static Map<LivingEntityPatch<?>, List<EFPatchExecutor>> CACHE = new HashMap();
    public final LivingEntityPatch<?> entityPatch;
    public final JointPoseGetter poseGetter;
    private boolean destroyed = false;

    public EFPatchExecutor(FX fx, Level level, LivingEntityPatch<?> entityPatch, JointPoseGetter poseGetter) {
        super(fx, level);
        this.entityPatch = entityPatch;
        this.poseGetter = poseGetter;
        this.setAllowMulti(true);
        this.setForcedDeath(true);
    }

    public void updateFXObjectTick(IFXObject fxObject) {
        if (this.runtime != null && fxObject == this.runtime.root) {
            if (!((LivingEntity)this.entityPatch.getOriginal()).isAlive()) {
                this.destroy();
            }
            boolean isAlive = false;
            for (IFXObject sceneObject : this.runtime.getObjects().values()) {
                if (sceneObject == this.runtime.root || !(sceneObject instanceof FXObject)) continue;
                FXObject fxO = (FXObject)sceneObject;
                isAlive = isAlive || fxO.isAlive();
            }
            if (!isAlive) {
                this.destroy();
            }
        }
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.runtime.destroy(this.forcedDeath);
        CACHE.computeIfAbsent(this.entityPatch, p -> new ArrayList()).remove((Object)this);
        if (CACHE.get(this.entityPatch).isEmpty()) {
            CACHE.remove(this.entityPatch);
        }
    }

    public static JointPoseGetter GetJointHandler(Joint joint) {
        return (entitypatch, partialTicks) -> {
            Animator animator = entitypatch.getAnimator();
            Pose pose = animator.getPose(partialTicks);
            OpenMatrix4f JointTf = new OpenMatrix4f(entitypatch.getArmature().getBoundTransformFor(pose, joint));
            return JointTf;
        };
    }

    public void updateFXObjectFrame(IFXObject fxObject, float partialTicks) {
        if (this.runtime != null && fxObject == this.runtime.root) {
            this.updateRoot(partialTicks);
        }
    }

    private void printAngle(String title, Vector3f v) {
        v.x = (float)Math.toDegrees((double)v.x);
        v.y = (float)Math.toDegrees((double)v.y);
        v.z = (float)Math.toDegrees((double)v.z);
        System.out.println(title + "(%.1f, %.1f, %.1f)".formatted(Float.valueOf(v.x), Float.valueOf(v.y), Float.valueOf(v.z)));
    }

    protected void updateRoot(float partialTicks) {
        Vec3 pos = ((LivingEntity)this.entityPatch.getOriginal()).getPosition(partialTicks);
        OpenMatrix4f modelTf = OpenMatrix4f.createTranslation((float)((float)pos.x), (float)((float)pos.y), (float)((float)pos.z)).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(this.entityPatch.getModelMatrix(partialTicks));
        OpenMatrix4f finalTf = this.poseGetter.handle(this.entityPatch, partialTicks).mulFront(modelTf);
        Vector3f euler = finalTf.toQuaternion().getEulerAnglesZXY(new Vector3f());
        this.runtime.root.updatePos(OpenMatrix4f.transform((OpenMatrix4f)finalTf, (Vec3)Vec3.ZERO).toVector3f());
        this.runtime.root.updateRotation(new Quaternionf().rotateX(-euler.x).rotateZ(-euler.z).rotateLocalY(-euler.y));
        this.runtime.root.updateScale(finalTf.toScaleVector().toMojangVector());
    }

    public void start() {
        if (!((LivingEntity)this.entityPatch.getOriginal()).isAlive()) {
            return;
        }
        List effects = CACHE.computeIfAbsent(this.entityPatch, p -> new ArrayList());
        if (!this.allowMulti) {
            Iterator iter = effects.iterator();
            while (iter.hasNext()) {
                EFPatchExecutor effect = (EFPatchExecutor)((Object)iter.next());
                boolean removed = false;
                if (effect.runtime != null && !effect.runtime.isAlive()) {
                    iter.remove();
                    removed = true;
                }
                if (!effect.fx.equals(this.fx) && !Objects.equals(effect.fx.getFxLocation(), this.fx.getFxLocation()) || removed) continue;
                return;
            }
        }
        this.runtime = this.fx.createRuntime();
        this.updateRoot(1.0f);
        this.runtime.emmit((IEffectExecutor)this, this.delay);
        effects.add(this);
    }

    @FunctionalInterface
    public static interface JointPoseGetter {
        public OpenMatrix4f handle(LivingEntityPatch<?> var1, float var2);
    }
}

