/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicvfx.client.particle;

import com.dfdyz.epicvfx.EpicVFX;
import com.dfdyz.epicvfx.client.photon.fx.EFTrailExecutor;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class EmitterProxy {

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            int eid = (int)Double.doubleToRawLongBits(x);
            int animid = (int)Double.doubleToRawLongBits(z);
            int jointId = (int)Double.doubleToRawLongBits(xSpeed);
            int idx = (int)Double.doubleToRawLongBits(ySpeed);
            Entity entity = level.getEntity(eid);
            if (entity == null) {
                return null;
            }
            LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
            if (entitypatch == null) {
                return null;
            }
            AnimationManager.AnimationAccessor animation = AnimationManager.byId((int)animid);
            if (animation == null) {
                return null;
            }
            Optional trailInfo = ((StaticAnimation)animation.get()).getProperty((AnimationProperty)ClientAnimationProperties.TRAIL_EFFECT);
            if (trailInfo.isEmpty()) {
                return null;
            }
            TrailInfo result = (TrailInfo)((List)trailInfo.get()).get(idx);
            if (result.hand() != null) {
                ItemStack stack = ((LivingEntity)entitypatch.getOriginal()).getItemInHand(result.hand());
                RenderItemBase renderItemBase = RenderEngine.getInstance().getItemRenderer(stack);
                if (renderItemBase != null && renderItemBase.trailInfo() != null) {
                    result = renderItemBase.trailInfo().overwrite(result);
                }
            }
            if (result.playable()) {
                Joint jt = entitypatch.getArmature().searchJointById(jointId);
                FX fx = FXHelper.getFX((ResourceLocation)result.texturePath());
                if (fx == null) {
                    EpicVFX.LOGGER.error("No FX named: " + String.valueOf(result.texturePath()));
                    return null;
                }
                EFTrailExecutor exe = new EFTrailExecutor(fx, level, entitypatch, jt, (AssetAccessor<? extends StaticAnimation>)animation, result);
                exe.start();
            }
            return null;
        }
    }
}

