/*
 * Decompiled with CFR 0.152.
 */
package net.m3tte.tactical_imbuements.procedures;

import java.util.LinkedList;
import net.m3tte.tactical_imbuements.EpicFight.ImbuementAnims;
import net.m3tte.tactical_imbuements.entity.FireflaskthrowableEntity;
import net.m3tte.tactical_imbuements.entity.FreezeFlaskThrowableEntity;
import net.m3tte.tactical_imbuements.entity.SparkFlaskThrowableEntity;
import net.m3tte.tactical_imbuements.entity.VenomFlaskThrowableEntity;
import net.m3tte.tactical_imbuements.init.TacticalImbuementsModEntities;
import net.m3tte.tactical_imbuements.init.TacticalImbuementsModItems;
import net.m3tte.tactical_imbuements.procedures.TickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class UseImbueFlasks {
    private static void throwFlask(final AbstractArrow arrow, Player player, Level world) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        entitypatch.playAnimationSynchronized(ImbuementAnims.THROW_FLASK, 0.0f);
        if (!world.m_5776_()) {
            world.m_5594_(null, BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_()), SoundEvents.f_12437_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        Projectile _entityToSpawn = new Object(){

            public Projectile getArrow(Level level, Entity shooter, float damage, int knockback) {
                arrow.m_5602_(shooter);
                arrow.m_36781_((double)damage);
                arrow.m_36735_(knockback);
                arrow.m_20225_(true);
                return arrow;
            }
        }.getArrow(world, (Entity)player, 8.0f, 1);
        _entityToSpawn.m_6034_(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_());
        _entityToSpawn.m_6686_(player.m_20154_().f_82479_, player.m_20154_().f_82480_, player.m_20154_().f_82481_, 1.0f, 0.1f);
        world.m_7967_((Entity)_entityToSpawn);
    }

    private static void applyImbuement(Level world, Player player, String imbueType, int time, String applySound, ItemStack potion, ItemStack weapon) {
        weapon.m_41784_().m_128359_("imbueType", imbueType);
        Player clplayer = player;
        weapon.m_41784_().m_128347_("imbueCounter", (double)(clplayer.f_19797_ + TickProcedure.defaultMaxTime));
        weapon.m_41784_().m_128347_("maxImbueTime", (double)TickProcedure.defaultMaxTime);
        potion.m_41774_(1);
        player.m_36356_(((Item)TacticalImbuementsModItems.FLASK.get()).m_7968_());
        world.m_5594_(null, BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(applySound)), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public static void useImbuementFlask(Level world, String flaskType, Player player, InteractionHand useHand) {
        ItemStack itemStack = player.m_21120_(useHand);
        InteractionHand weaponHand = useHand == InteractionHand.OFF_HAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack weaponItem = player.m_21120_(weaponHand);
        if (weaponItem.m_41619_() && !world.m_5776_()) {
            itemStack.m_41774_(1);
            player.m_36335_().m_41524_(itemStack.m_41720_(), 40);
            AbstractArrow flask = null;
            switch (flaskType) {
                default: {
                    flask = new FireflaskthrowableEntity((EntityType<? extends FireflaskthrowableEntity>)((EntityType)TacticalImbuementsModEntities.FIREFLASKTHROWABLE.get()), world);
                    break;
                }
                case "venom": {
                    flask = new VenomFlaskThrowableEntity((EntityType<? extends VenomFlaskThrowableEntity>)((EntityType)TacticalImbuementsModEntities.VENOMFLASKTHROWABLE.get()), world);
                    break;
                }
                case "freeze": {
                    flask = new FreezeFlaskThrowableEntity((EntityType<? extends FreezeFlaskThrowableEntity>)((EntityType)TacticalImbuementsModEntities.FREEZEFLASKTHROWABLE.get()), world);
                    break;
                }
                case "spark": {
                    flask = new SparkFlaskThrowableEntity((EntityType<? extends SparkFlaskThrowableEntity>)((EntityType)TacticalImbuementsModEntities.SPARKFLASKTHROWABLE.get()), world);
                }
            }
            UseImbueFlasks.throwFlask(flask, player, world);
        } else if (weaponItem.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("tactical_imbuements:applicable")))) {
            player.m_36335_().m_41524_(itemStack.m_41720_(), 200);
            LivingEntityPatch entitypatch = (LivingEntityPatch)player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            entitypatch.playAnimationSynchronized(ImbuementAnims.APPLY_IMBUEMENT, 0.0f);
        }
    }

    public static void calculateImbuementUsage(Level world, Player player) {
        InteractionHand flaskHand;
        InteractionHand weaponHand;
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("tactical_imbuements:applicable")))) {
            weaponHand = InteractionHand.MAIN_HAND;
            flaskHand = InteractionHand.OFF_HAND;
        } else if (player.m_21120_(InteractionHand.OFF_HAND).m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("tactical_imbuements:applicable")))) {
            weaponHand = InteractionHand.OFF_HAND;
            flaskHand = InteractionHand.MAIN_HAND;
        } else {
            return;
        }
        ItemStack weaponItem = player.m_21120_(weaponHand);
        ItemStack itemStack = player.m_21120_(flaskHand);
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (resourceLocation != null) {
            switch (resourceLocation.m_135815_()) {
                default: {
                    UseImbueFlasks.applyImbuement(world, player, "flame", TickProcedure.defaultMaxTime, "item.firecharge.use", itemStack, weaponItem);
                    break;
                }
                case "flask_of_venom": {
                    UseImbueFlasks.applyImbuement(world, player, "venom", TickProcedure.defaultMaxTime, "item.firecharge.use", itemStack, weaponItem);
                    break;
                }
                case "flask_of_ice": {
                    UseImbueFlasks.applyImbuement(world, player, "freeze", TickProcedure.defaultMaxTime, "item.firecharge.use", itemStack, weaponItem);
                    break;
                }
                case "flask_of_sparks": {
                    UseImbueFlasks.applyImbuement(world, player, "spark", TickProcedure.defaultMaxTime, "item.firecharge.use", itemStack, weaponItem);
                }
            }
        }
    }

    public static LinkedList<String> getImbuements(LivingEntity entity) {
        LinkedList<String> imbuements = new LinkedList<String>();
        if (entity != null) {
            imbuements.add(entity.m_21205_().m_41784_().m_128461_("imbueType"));
            imbuements.add(entity.m_21206_().m_41784_().m_128461_("imbueType"));
        }
        return imbuements;
    }
}

