package net.m3tte.tactical_imbuements.renderer;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat.Mode;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderStateShard.ShaderStateShard;
import net.minecraft.resources.ResourceLocation;

public class GlintRenderers extends RenderType {

   public static final ResourceLocation FIRE_GLINT_LOCATION;
   public static final ResourceLocation VENOM_GLINT_LOCATION;
   public static final ResourceLocation FREEZE_GLINT_LOCATION;
   public static final ResourceLocation SPARK_GLINT_LOCATION;
   protected static final ShaderStateShard RENDERTYPE_FIRE_GLINT_DIRECT_SHADER;
   private static final RenderType FIRE_GLINT;
   private static final RenderType FIRE_GLINT_DIRECT;
   private static final RenderType FIRE_ENTITY_GLINT_DIRECT;
   private static final RenderType VENOM_GLINT;
   private static final RenderType VENOM_GLINT_DIRECT;
   private static final RenderType VENOM_ENTITY_GLINT_DIRECT;
   private static final RenderType FREEZE_GLINT_DIRECT;
   private static final RenderType FREEZE_ENTITY_GLINT_DIRECT;
   private static final RenderType SPARK_GLINT_DIRECT;
   private static final RenderType SPARK_ENTITY_GLINT_DIRECT;


   public GlintRenderers(String p_173178_, VertexFormat p_173179_, Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
      super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
   }

   public static RenderType getDirectGlintRender(String preset) {
      byte var2 = -1;
      switch(preset.hashCode()) {
      case -1266402665:
         if(preset.equals("freeze")) {
            var2 = 3;
         }
         break;
      case 97513267:
         if(preset.equals("flame")) {
            var2 = 1;
         }
         break;
      case 109638365:
         if(preset.equals("spark")) {
            var2 = 4;
         }
         break;
      case 112093629:
         if(preset.equals("venom")) {
            var2 = 2;
         }
      }

      switch(var2) {
      case 1:
         return getFireGlintDirect();
      case 2:
         return getVenomGlintDirect();
      case 3:
         return getFreezeGlintDirect();
      case 4:
         return getSparkGlintDirect();
      default:
         return RenderType.m_110493_();
      }
   }

   public static RenderType getEntityGlintDirect(String preset) {
      byte var2 = -1;
      switch(preset.hashCode()) {
      case -1266402665:
         if(preset.equals("freeze")) {
            var2 = 3;
         }
         break;
      case 97513267:
         if(preset.equals("flame")) {
            var2 = 1;
         }
         break;
      case 109638365:
         if(preset.equals("spark")) {
            var2 = 4;
         }
         break;
      case 112093629:
         if(preset.equals("venom")) {
            var2 = 2;
         }
      }

      switch(var2) {
      case 1:
         return getFireEntityGlintDirect();
      case 2:
         return getVenomEntityGlintDirect();
      case 3:
         return getFreezeEntityGlintDirect();
      case 4:
         return getSparkEntityGlintDirect();
      default:
         return RenderType.m_110499_();
      }
   }

   public static RenderType getFireEntityGlintDirect() {
      return FIRE_ENTITY_GLINT_DIRECT;
   }

   public static RenderType getFireGlintDirect() {
      return FIRE_GLINT_DIRECT;
   }

   public static RenderType getVenomEntityGlintDirect() {
      return VENOM_ENTITY_GLINT_DIRECT;
   }

   public static RenderType getVenomGlintDirect() {
      return VENOM_GLINT_DIRECT;
   }

   public static RenderType getFreezeEntityGlintDirect() {
      return FREEZE_ENTITY_GLINT_DIRECT;
   }

   public static RenderType getFreezeGlintDirect() {
      return FREEZE_GLINT_DIRECT;
   }

   public static RenderType getSparkEntityGlintDirect() {
      return SPARK_ENTITY_GLINT_DIRECT;
   }

   public static RenderType getSparkGlintDirect() {
      return SPARK_GLINT_DIRECT;
   }

   public static RenderType getGlintRender(String preset) {
      byte var2 = -1;
      switch(preset.hashCode()) {
      case 97513267:
         if(preset.equals("flame")) {
            var2 = 1;
         }
      default:
         switch(var2) {
         case 1:
            return FIRE_GLINT;
         default:
            return RenderType.m_110490_();
         }
      }
   }

   static {
      // $FF: Couldn't be decompiled
   }
}
