package net.m3tte.tactical_imbuements.mixin;

import net.m3tte.tactical_imbuements.definitions.ImbuementDefinitions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.client.particle.TrailParticle;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Mixin(
   value = {TrailParticle.class},
   remap = false
)
public class TrailParticleMixin {

   @Inject(
      at = {         @At("TAIL")},
      method = {"<init>(Lnet/minecraft/client/multiplayer/ClientLevel;Lyesman/epicfight/world/capabilities/entitypatch/LivingEntityPatch;Lyesman/epicfight/api/animation/Joint;Lyesman/epicfight/api/animation/types/StaticAnimation;Lyesman/epicfight/api/client/animation/property/TrailInfo;Lnet/minecraft/client/particle/SpriteSet;)V"},
      cancellable = true
   )
   private void injectTrailParticle(ClientLevel level, LivingEntityPatch entitypatch, Joint joint, StaticAnimation animation, TrailInfo trailInfo, SpriteSet spriteSet, CallbackInfo cbk) {
      TrailParticle trailParticle = (TrailParticle)this;
      ItemStack item = entitypatch.getValidItemInHand(trailInfo.hand);
      if(item.m_41783_() != null) {
         String type = item.m_41784_().m_128461_("imbueType");
         byte var12 = -1;
         switch(type.hashCode()) {
         case -1266402665:
            if(type.equals("freeze")) {
               var12 = 2;
            }
            break;
         case 97513267:
            if(type.equals("flame")) {
               var12 = 0;
            }
            break;
         case 109638365:
            if(type.equals("spark")) {
               var12 = 3;
            }
            break;
         case 112093629:
            if(type.equals("venom")) {
               var12 = 1;
            }
         }

         switch(var12) {
         case 0:
            trailParticle.m_107253_(ImbuementDefinitions.FLAME.getrCol(), ImbuementDefinitions.FLAME.getgCol(), ImbuementDefinitions.FLAME.getbCol());
            break;
         case 1:
            trailParticle.m_107253_(ImbuementDefinitions.VENOM.getrCol(), ImbuementDefinitions.VENOM.getgCol(), ImbuementDefinitions.VENOM.getbCol());
            break;
         case 2:
            trailParticle.m_107253_(ImbuementDefinitions.FREEZE.getrCol(), ImbuementDefinitions.FREEZE.getgCol(), ImbuementDefinitions.FREEZE.getbCol());
            break;
         case 3:
            trailParticle.m_107253_(ImbuementDefinitions.SPARK.getrCol(), ImbuementDefinitions.SPARK.getgCol(), ImbuementDefinitions.SPARK.getbCol());
         }

      }
   }
}
