package net.m3tte.tactical_imbuements.mixin;

import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.SortedMap;
import net.m3tte.tactical_imbuements.mixin.renderBufferInterface;
import net.m3tte.tactical_imbuements.renderer.GlintRenderers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.MultiBufferSource.BufferSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin({RenderBuffers.class})
public class RenderBuffersMixin {

   private static BufferSource savedBufferSource = null;
   private static OutlineBufferSource savedOutlineBuffers = null;
   private static boolean hasRendered = false;


   @Inject(
      at = {         @At("TAIL")},
      method = {"bufferSource"},
      cancellable = true
   )
   private void injectBufferSource(CallbackInfoReturnable cbk) {
      if(savedBufferSource == null) {
         System.out.println("First Override");
         RenderBuffers renderBuffers = (RenderBuffers)this;
         SortedMap fixedBuffers = ((renderBufferInterface)renderBuffers).getFixedBuffers();
         put(fixedBuffers, GlintRenderers.getFireGlintDirect());
         put(fixedBuffers, GlintRenderers.getFireEntityGlintDirect());
         put(fixedBuffers, GlintRenderers.getVenomGlintDirect());
         put(fixedBuffers, GlintRenderers.getVenomEntityGlintDirect());
         put(fixedBuffers, GlintRenderers.getSparkGlintDirect());
         put(fixedBuffers, GlintRenderers.getSparkEntityGlintDirect());
         put(fixedBuffers, GlintRenderers.getFreezeGlintDirect());
         put(fixedBuffers, GlintRenderers.getFreezeEntityGlintDirect());
         savedBufferSource = MultiBufferSource.m_109900_(fixedBuffers, new BufferBuilder(256));
      }

      cbk.setReturnValue(savedBufferSource);
   }

   @Inject(
      at = {         @At("TAIL")},
      method = {"outlineBufferSource"},
      cancellable = true
   )
   private void injectOutlineBuffer(CallbackInfoReturnable cbk) {
      if(savedOutlineBuffers != null) {
         cbk.setReturnValue(savedOutlineBuffers);
      }

   }

   private static void put(SortedMap p_110102_, RenderType p_110103_) {
      p_110102_.put(p_110103_, new BufferBuilder(p_110103_.m_110507_()));
   }

}
