package net.m3tte.tactical_imbuements.mixin;

import java.util.LinkedList;
import java.util.function.Consumer;
import net.m3tte.tactical_imbuements.EpicFight.ImbuementAnims;
import net.m3tte.tactical_imbuements.init.TacticalImbuementsModParticleTypes;
import net.m3tte.tactical_imbuements.procedures.UseImbueFlasks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.HurtEvent.Pre;

@Mixin({GuardSkill.class})
public class ParryingSkillMixin {

   @Inject(
      at = {         @At("TAIL")},
      method = {"dealEvent"},
      cancellable = true,
      remap = false
   )
   public void guardInject(PlayerPatch playerpatch, Pre event, boolean advanced, CallbackInfo cbk) {
      Player player = (Player)playerpatch.getOriginal();
      Level level = player.m_9236_();
      LinkedList imbuements = UseImbueFlasks.getImbuements(player);
      if(event.isParried()) {
         LivingEntityPatch attackerpatch;
         if(imbuements.contains("spark") && ((DamageSource)event.getDamageSource()).m_7640_() != null) {
            EntityPatch attacker = (EntityPatch)((DamageSource)event.getDamageSource()).m_7640_().getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, (Direction)null).orElse((Object)null);
            if(attacker instanceof LivingEntityPatch) {
               attackerpatch = (LivingEntityPatch)attacker;
               if(attackerpatch.getArmature() instanceof HumanoidArmature && !level.m_5776_()) {
                  attackerpatch.playAnimationSynchronized(ImbuementAnims.ZAP, 0.0F);
                  if(!level.m_5776_()) {
                     level.m_5594_((Player)null, BlockPos.m_274561_(player.m_20185_(), player.m_20186_() + 1.0D, player.m_20189_()), SoundEvents.f_12511_, SoundSource.NEUTRAL, 1.0F, 1.2F);
                     ((ServerLevel)level).m_8767_((SimpleParticleType)TacticalImbuementsModParticleTypes.SPARK_PARTICLE.get(), attacker.getOriginal().m_20185_(), attacker.getOriginal().m_20186_() + 1.0D, attacker.getOriginal().m_20189_(), 10, 0.2D, 0.4D, 0.2D, 0.2D);
                  }
               }
            }
         }

         if(imbuements.contains("venom") && ((DamageSource)event.getDamageSource()).m_7640_() != null) {
            Entity attackerpatch1 = ((DamageSource)event.getDamageSource()).m_7640_();
            if(attackerpatch1 instanceof LivingEntity) {
               LivingEntity attacker1 = (LivingEntity)attackerpatch1;
               attackerpatch = (LivingEntityPatch)attacker1.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, (Direction)null).orElse((Object)null);
               RandomSource r = attacker1.m_217043_();
               oncePerHand(attackerpatch);
            }
         }
      }

      if(imbuements.contains("flame") && !event.isParried()) {
         oncePerHand(player);
         this.flameKnockdown((LivingEntity)playerpatch.getOriginal(), playerpatch);
      }

   }

   private static void oncePerHand(Consumer c) {
      c.accept(InteractionHand.MAIN_HAND);
      c.accept(InteractionHand.OFF_HAND);
   }

   private void flameKnockdown(LivingEntity param1, LivingEntityPatch param2) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static double lambda$flameKnockdown$3(LivingEntity ignore, Entity _entcnd) {
      return _entcnd.m_20238_(ignore.m_20182_());
   }

   // $FF: synthetic method
   private static boolean lambda$flameKnockdown$2(Entity e) {
      return true;
   }

   // $FF: synthetic method
   private static void lambda$guardInject$1(Player player, InteractionHand hand) {
      ItemStack item = player.m_21120_(hand);
      if(item.m_41783_() != null) {
         if(item.m_41784_().m_128461_("imbueType").equals("flame")) {
            item.m_41784_().m_128347_("imbueCounter", (double)player.f_19797_);
            if(player instanceof ServerPlayer) {
               ServerPlayer serverPlayer = (ServerPlayer)player;
               item.m_220157_(60, serverPlayer.m_217043_(), serverPlayer);
            }
         }

      }
   }

   // $FF: synthetic method
   private static void lambda$guardInject$0(LivingEntity attacker, RandomSource r, Level level, LivingEntityPatch attackerpatch, InteractionHand hand) {
      ItemStack i = attacker.m_21120_(hand);
      if(i != null) {
         i.m_220157_((int)((float)i.m_41776_() * 0.01F + 5.0F), r, (ServerPlayer)null);
         if(i.m_41773_() > i.m_41776_()) {
            if(!level.m_5776_()) {
               level.m_5594_((Player)null, BlockPos.m_274561_(attacker.m_20185_(), attacker.m_20186_() + 1.0D, attacker.m_20189_()), SoundEvents.f_12018_, SoundSource.NEUTRAL, 1.0F, 1.0F);
               level.m_5594_((Player)null, BlockPos.m_274561_(attacker.m_20185_(), attacker.m_20186_() + 1.0D, attacker.m_20189_()), SoundEvents.f_144060_, SoundSource.NEUTRAL, 1.0F, 1.0F);
               ((ServerLevel)level).m_8767_((SimpleParticleType)TacticalImbuementsModParticleTypes.VENOM_PARTICLE.get(), ((LivingEntity)attackerpatch.getOriginal()).m_20185_(), ((LivingEntity)attackerpatch.getOriginal()).m_20186_() + 1.0D, ((LivingEntity)attackerpatch.getOriginal()).m_20189_(), 10, 0.2D, 0.4D, 0.2D, 0.0D);
            }

            i.m_41774_(1);
         }

         if(!level.m_5776_()) {
            level.m_5594_((Player)null, BlockPos.m_274561_(attacker.m_20185_(), attacker.m_20186_() + 1.0D, attacker.m_20189_()), SoundEvents.f_12018_, SoundSource.NEUTRAL, 1.0F, 1.6F);
            ((ServerLevel)level).m_8767_((SimpleParticleType)TacticalImbuementsModParticleTypes.VENOM_PARTICLE.get(), ((LivingEntity)attackerpatch.getOriginal()).m_20185_(), ((LivingEntity)attackerpatch.getOriginal()).m_20186_() + 1.0D, ((LivingEntity)attackerpatch.getOriginal()).m_20189_(), 10, 0.2D, 0.4D, 0.2D, 0.2D);
         }
      }

   }
}
