package net.m3tte.tactical_imbuements.item;

import java.util.List;
import net.m3tte.tactical_imbuements.procedures.UseImbueFlasks;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Item.Properties;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class SparksFlask extends Item {

   public SparksFlask() {
      super((new Properties()).m_41487_(4).m_41497_(Rarity.UNCOMMON));
   }

   public UseAnim m_6164_(ItemStack itemstack) {
      return UseAnim.BOW;
   }

   public void m_7373_(ItemStack itemstack, Level world, List list, TooltipFlag flag) {
      super.m_7373_(itemstack, world, list, flag);
      list.add(Component.m_237113_("[On Use] ").m_130940_(ChatFormatting.YELLOW).m_7220_(Component.m_237113_("Applies electricity to your weapon for 30 seconds.").m_130940_(ChatFormatting.GRAY)));
      list.add(Component.m_237113_("[On Impact] ").m_130940_(ChatFormatting.YELLOW).m_7220_(Component.m_237113_("Zap nearby enemies").m_130940_(ChatFormatting.GRAY)));
      list.add(Component.m_237113_("[Sparks] ").m_130940_(ChatFormatting.DARK_AQUA).m_7220_(Component.m_237113_("Parries stun, part of damage bypasses armor.").m_130940_(ChatFormatting.AQUA)));
      list.add(Component.m_237113_("The dance of lightning is one not many individuals can claim to survive. None shall prevail against your lightning fast strikes.").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
   }

   public InteractionResultHolder m_7203_(Level world, Player entity, InteractionHand hand) {
      InteractionResultHolder ar = super.m_7203_(world, entity, hand);
      UseImbueFlasks.useImbuementFlask(world, "spark", entity, hand);
      return ar;
   }

   public InteractionResult m_6225_(UseOnContext context) {
      super.m_6225_(context);
      UseImbueFlasks.useImbuementFlask(context.m_43725_(), "spark", context.m_43723_(), context.m_43724_());
      return InteractionResult.SUCCESS;
   }
}
