package net.m3tte.tactical_imbuements.entity;

import java.util.Random;
import net.m3tte.tactical_imbuements.init.TacticalImbuementsModEntities;
import net.m3tte.tactical_imbuements.procedures.FlaskImpact;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages.SpawnEntity;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(
   value = Dist.CLIENT,
   _interface = ItemSupplier.class
)
public class FireflaskthrowableEntity extends AbstractArrow implements ItemSupplier {

   public FireflaskthrowableEntity(SpawnEntity packet, Level world) {
      super((EntityType)TacticalImbuementsModEntities.FIREFLASKTHROWABLE.get(), world);
   }

   public FireflaskthrowableEntity(EntityType type, Level world) {
      super(type, world);
   }

   public FireflaskthrowableEntity(EntityType type, double x, double y, double z, Level world) {
      super(type, x, y, z, world);
   }

   public FireflaskthrowableEntity(EntityType type, LivingEntity entity, Level world) {
      super(type, entity, world);
   }

   public Packet m_5654_() {
      return NetworkHooks.getEntitySpawningPacket(this);
   }

   @OnlyIn(Dist.CLIENT)
   public ItemStack m_7846_() {
      return ItemStack.f_41583_;
   }

   protected ItemStack m_7941_() {
      return ItemStack.f_41583_;
   }

   protected void m_7761_(LivingEntity entity) {
      super.m_7761_(entity);
      entity.m_21317_(entity.m_21234_() - 1);
   }

   public void m_5790_(EntityHitResult entityHitResult) {
      super.m_5790_(entityHitResult);
      FlaskImpact.fireImpact(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
      if(!this.m_213877_()) {
         this.m_146870_();
      }

   }

   public void m_8060_(BlockHitResult blockHitResult) {
      super.m_8060_(blockHitResult);
      FlaskImpact.fireImpact(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
   }

   public void m_8119_() {
      super.m_8119_();
      if(this.f_36703_) {
         this.m_146870_();
      }

   }

   public static FireflaskthrowableEntity shoot(Level world, LivingEntity entity, Random random, float power, double damage, int knockback) {
      FireflaskthrowableEntity entityarrow = new FireflaskthrowableEntity((EntityType)TacticalImbuementsModEntities.FIREFLASKTHROWABLE.get(), entity, world);
      entityarrow.m_6686_(entity.m_20252_(1.0F).f_82479_, entity.m_20252_(1.0F).f_82480_, entity.m_20252_(1.0F).f_82481_, power * 2.0F, 0.0F);
      entityarrow.m_20225_(true);
      entityarrow.m_36762_(false);
      entityarrow.m_36781_(damage);
      entityarrow.m_36735_(knockback);
      world.m_7967_(entityarrow);
      world.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0F, 1.0F / (random.nextFloat() * 0.5F + 1.0F) + power / 2.0F);
      return entityarrow;
   }

   public static FireflaskthrowableEntity shoot(LivingEntity entity, LivingEntity target) {
      FireflaskthrowableEntity entityarrow = new FireflaskthrowableEntity((EntityType)TacticalImbuementsModEntities.FIREFLASKTHROWABLE.get(), entity, entity.m_9236_());
      double dx = target.m_20185_() - entity.m_20185_();
      double dy = target.m_20186_() + (double)target.m_20192_() - 1.1D;
      double dz = target.m_20189_() - entity.m_20189_();
      entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * 0.20000000298023224D, dz, 0.2F, 12.0F);
      entityarrow.m_20225_(true);
      entityarrow.m_36781_(5.0D);
      entityarrow.m_36735_(1);
      entityarrow.m_36762_(false);
      entity.m_9236_().m_7967_(entityarrow);
      entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0F, 1.0F / ((new Random()).nextFloat() * 0.5F + 1.0F));
      return entityarrow;
   }
}
