/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  javax.servlet.ServletException
 *  javax.servlet.http.HttpServletRequest
 *  javax.servlet.http.HttpServletResponse
 *  org.eclipse.jetty.io.ByteBufferPool
 *  org.eclipse.jetty.io.MappedByteBufferPool
 *  org.eclipse.jetty.server.Request
 *  org.eclipse.jetty.server.handler.HandlerWrapper
 *  org.eclipse.jetty.websocket.server.pathmap.PathMappings
 *  org.eclipse.jetty.websocket.server.pathmap.PathMappings$MappedResource
 *  org.eclipse.jetty.websocket.server.pathmap.PathSpec
 *  org.eclipse.jetty.websocket.servlet.WebSocketCreator
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.server.pathmap.PathMappings;
import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class WebSocketUpgradeHandlerWrapper
extends HandlerWrapper
implements MappedWebSocketCreator {
    private PathMappings<WebSocketCreator> pathmap = new PathMappings();
    private final WebSocketServerFactory factory;

    public WebSocketUpgradeHandlerWrapper() {
        this((ByteBufferPool)new MappedByteBufferPool());
    }

    public WebSocketUpgradeHandlerWrapper(ByteBufferPool bufferPool) {
        this.factory = new WebSocketServerFactory(bufferPool);
    }

    @Override
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.pathmap.put(spec, (Object)creator);
    }

    @Override
    public PathMappings<WebSocketCreator> getMappings() {
        return this.pathmap;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.factory.isUpgradeRequest(request, response)) {
            PathMappings.MappedResource resource = this.pathmap.getMatch(target);
            if (resource == null) {
                response.sendError(404, "No websocket endpoint matching path: " + target);
                return;
            }
            WebSocketCreator creator = (WebSocketCreator)resource.getResource();
            request.setAttribute(PathSpec.class.getName(), (Object)resource);
            if (this.factory.acceptWebSocket(creator, request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }
}

