/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  org.eclipse.jetty.websocket.api.BadPayloadException
 *  org.eclipse.jetty.websocket.api.extensions.Frame
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.util.zip.DataFormatException;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;

public class DeflateFrameExtension
extends CompressExtension {
    public String getName() {
        return "deflate-frame";
    }

    @Override
    int getRsvUseMode() {
        return 0;
    }

    @Override
    int getTailDropMode() {
        return 1;
    }

    public void incomingFrame(Frame frame) {
        if (frame.getType().isControl() || !frame.isRsv1() || !frame.hasPayload()) {
            this.nextIncomingFrame(frame);
            return;
        }
        try {
            ByteAccumulator accumulator = this.newByteAccumulator();
            this.decompress(accumulator, frame.getPayload());
            this.decompress(accumulator, TAIL_BYTES_BUF.slice());
            this.forwardIncoming(frame, accumulator);
        }
        catch (DataFormatException e) {
            throw new BadPayloadException((Throwable)e);
        }
    }
}

