/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  org.eclipse.jetty.util.log.Log
 *  org.eclipse.jetty.util.log.Logger
 *  org.eclipse.jetty.util.thread.ExecutionStrategy
 *  org.eclipse.jetty.util.thread.ExecutionStrategy$Producer
 *  org.eclipse.jetty.util.thread.Locker
 *  org.eclipse.jetty.util.thread.Locker$Lock
 *  org.eclipse.jetty.util.thread.ThreadPool
 */
package org.eclipse.jetty.util.thread.strategy;

import java.util.concurrent.Executor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.strategy.ProduceExecuteConsume;

public class ExecuteProduceConsume
implements ExecutionStrategy,
Runnable {
    private static final Logger LOG = Log.getLogger(ExecuteProduceConsume.class);
    private final Locker _locker = new Locker();
    private final Runnable _runExecute = new RunExecute();
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;
    private boolean _idle = true;
    private boolean _execute;
    private boolean _producing;
    private boolean _pending;
    private final ThreadPool _threadpool;
    private final ExecutionStrategy _lowresources;

    public ExecuteProduceConsume(ExecutionStrategy.Producer producer, Executor executor) {
        this(producer, executor, executor instanceof ThreadPool ? new ProduceExecuteConsume(producer, executor) : null);
    }

    public ExecuteProduceConsume(ExecutionStrategy.Producer producer, Executor executor, ExecutionStrategy lowResourceStrategy) {
        this._producer = producer;
        this._executor = executor;
        this._threadpool = executor instanceof ThreadPool ? (ThreadPool)executor : null;
        this._lowresources = this._threadpool == null ? null : lowResourceStrategy;
    }

    public void execute() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} execute", new Object[]{this});
        }
        boolean produce = false;
        try (Locker.Lock locked = this._locker.lock();){
            if (this._idle) {
                if (this._producing) {
                    throw new IllegalStateException();
                }
                this._producing = true;
                produce = true;
                this._idle = false;
            } else {
                this._execute = true;
            }
        }
        if (produce) {
            this.produceAndRun();
        }
    }

    public void dispatch() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} spawning", new Object[]{this});
        }
        boolean dispatch = false;
        try (Locker.Lock locked = this._locker.lock();){
            if (this._idle) {
                dispatch = true;
            } else {
                this._execute = true;
            }
        }
        if (dispatch) {
            this._executor.execute(this._runExecute);
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} run", new Object[]{this});
        }
        boolean produce = false;
        try (Locker.Lock locked = this._locker.lock();){
            this._pending = false;
            if (!this._idle && !this._producing) {
                this._producing = true;
                produce = true;
            }
        }
        if (produce) {
            while (this._threadpool != null && this._threadpool.isLowOnThreads()) {
                LOG.debug("EWYK low resources {}", new Object[]{this});
                this._lowresources.execute();
            }
            this.produceAndRun();
        }
    }

    private void produceAndRun() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} produce enter", new Object[]{this});
        }
        while (true) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} producing", new Object[]{this});
            }
            Runnable task = this._producer.produce();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} produced {}", new Object[]{this, task});
            }
            boolean dispatch = false;
            Locker.Lock locked = this._locker.lock();
            Throwable throwable = null;
            try {
                this._producing = false;
                if (task == null) {
                    if (this._execute) {
                        this._idle = false;
                        this._producing = true;
                        this._execute = false;
                        continue;
                    }
                    this._idle = true;
                    break;
                }
                if (!this._pending) {
                    this._pending = true;
                    dispatch = true;
                }
                this._execute = false;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (locked == null) continue;
                if (throwable != null) {
                    try {
                        locked.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                locked.close();
                continue;
            }
            if (dispatch) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} dispatch", new Object[]{this});
                }
                this._executor.execute(this);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} run {}", new Object[]{this, task});
            }
            task.run();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} ran {}", new Object[]{this, task});
            }
            locked = this._locker.lock();
            throwable = null;
            try {
                if (this._producing || this._idle) break;
                this._producing = true;
                continue;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (locked == null) continue;
                if (throwable != null) {
                    try {
                        locked.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                locked.close();
                continue;
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} produce exit", new Object[]{this});
        }
    }

    public Boolean isIdle() {
        try (Locker.Lock locked = this._locker.lock();){
            Boolean bl = this._idle;
            return bl;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EPR ");
        try (Locker.Lock locked = this._locker.lock();){
            builder.append(this._idle ? "Idle/" : "");
            builder.append(this._producing ? "Prod/" : "");
            builder.append(this._pending ? "Pend/" : "");
            builder.append(this._execute ? "Exec/" : "");
        }
        builder.append(this._producer);
        return builder.toString();
    }

    private class RunExecute
    implements Runnable {
        private RunExecute() {
        }

        @Override
        public void run() {
            ExecuteProduceConsume.this.execute();
        }
    }
}

