/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  org.eclipse.jetty.util.Atomics
 */
package org.eclipse.jetty.util.statistic;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.Atomics;

public class CounterStatistic {
    protected final AtomicLong _max = new AtomicLong();
    protected final AtomicLong _curr = new AtomicLong();
    protected final AtomicLong _total = new AtomicLong();

    public void reset() {
        this._total.set(0L);
        this._max.set(0L);
        long current = this._curr.get();
        this._total.addAndGet(current);
        Atomics.updateMax((AtomicLong)this._max, (long)current);
    }

    public void reset(long value) {
        this._total.set(0L);
        this._max.set(0L);
        this._curr.set(value);
        if (value > 0L) {
            this._total.addAndGet(value);
            Atomics.updateMax((AtomicLong)this._max, (long)value);
        }
    }

    public long add(long delta) {
        long value = this._curr.addAndGet(delta);
        if (delta > 0L) {
            this._total.addAndGet(delta);
            Atomics.updateMax((AtomicLong)this._max, (long)value);
        }
        return value;
    }

    public long increment() {
        return this.add(1L);
    }

    public long decrement() {
        return this.add(-1L);
    }

    public long getMax() {
        return this._max.get();
    }

    public long getCurrent() {
        return this._curr.get();
    }

    public long getTotal() {
        return this._total.get();
    }

    public String toString() {
        return String.format("%s@%x{c=%d,m=%d,t=%d}", this.getClass().getSimpleName(), this.hashCode(), this._curr.get(), this._max.get(), this._total.get());
    }
}

