/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  org.eclipse.jetty.http.BadMessageException
 *  org.eclipse.jetty.http.HttpScheme
 *  org.eclipse.jetty.io.ssl.SslConnection
 *  org.eclipse.jetty.io.ssl.SslConnection$DecryptedEndPoint
 *  org.eclipse.jetty.util.TypeUtil
 *  org.eclipse.jetty.util.log.Log
 *  org.eclipse.jetty.util.log.Logger
 *  org.eclipse.jetty.util.ssl.SslContextFactory
 *  org.eclipse.jetty.util.ssl.X509
 */
package org.eclipse.jetty.server;

import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.ssl.X509;

public class SecureRequestCustomizer
implements HttpConfiguration.Customizer {
    private static final Logger LOG = Log.getLogger(SecureRequestCustomizer.class);
    public static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    private boolean _sniHostCheck;

    public SecureRequestCustomizer() {
        this(true);
    }

    public SecureRequestCustomizer(boolean sniHostCheck) {
        this._sniHostCheck = sniHostCheck;
    }

    @Override
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        if (request.getHttpChannel().getEndPoint() instanceof SslConnection.DecryptedEndPoint) {
            request.setSecure(true);
            if (request.getHttpURI().getScheme() == null) {
                request.setScheme(HttpScheme.HTTPS.asString());
            }
            SslConnection.DecryptedEndPoint ssl_endp = (SslConnection.DecryptedEndPoint)request.getHttpChannel().getEndPoint();
            SslConnection sslConnection = ssl_endp.getSslConnection();
            SSLEngine sslEngine = sslConnection.getSSLEngine();
            this.customize(sslEngine, request);
        }
    }

    public void customize(SSLEngine sslEngine, Request request) {
        request.setScheme(HttpScheme.HTTPS.asString());
        SSLSession sslSession = sslEngine.getSession();
        if (this._sniHostCheck) {
            String name = request.getServerName();
            X509 x509 = (X509)sslSession.getValue("org.eclipse.jetty.util.ssl.snix509");
            if (x509 != null && !x509.matches(name)) {
                LOG.warn("Host {} does not match SNI {}", new Object[]{name, x509});
                throw new BadMessageException(400, "Host does not match SNI");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host {} matched SNI {}", new Object[]{name, x509});
            }
        }
        try {
            String idStr;
            X509Certificate[] certs;
            Integer keySize;
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
                idStr = cachedInfo.getIdStr();
            } else {
                keySize = SslContextFactory.deduceKeyLength((String)cipherSuite);
                certs = SslContextFactory.getCertChain((SSLSession)sslSession);
                byte[] bytes = sslSession.getId();
                idStr = TypeUtil.toHexString((byte[])bytes);
                cachedInfo = new CachedInfo(keySize, certs, idStr);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            }
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", keySize);
            request.setAttribute("javax.servlet.request.ssl_session_id", idStr);
        }
        catch (Exception e) {
            LOG.warn("EXCEPTION ", (Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    private static class CachedInfo {
        private final X509Certificate[] _certs;
        private final Integer _keySize;
        private final String _idStr;

        CachedInfo(Integer keySize, X509Certificate[] certs, String idStr) {
            this._keySize = keySize;
            this._certs = certs;
            this._idStr = idStr;
        }

        X509Certificate[] getCerts() {
            return this._certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        String getIdStr() {
            return this._idStr;
        }
    }
}

