/*
 * Decompiled with CFR 0.152.
 * 
 * Could not load the following classes:
 *  javax.servlet.ServletRequest
 *  org.eclipse.jetty.server.UserIdentity
 *  org.eclipse.jetty.util.Loader
 *  org.eclipse.jetty.util.log.Log
 *  org.eclipse.jetty.util.log.Logger
 *  org.eclipse.jetty.util.resource.Resource
 *  org.eclipse.jetty.util.security.Credential
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class JDBCLoginService
extends MappedLoginService {
    private static final Logger LOG = Log.getLogger(JDBCLoginService.class);
    protected String _config;
    protected String _jdbcDriver;
    protected String _url;
    protected String _userName;
    protected String _password;
    protected String _userTableKey;
    protected String _userTablePasswordField;
    protected String _roleTableRoleField;
    protected int _cacheTime;
    protected long _lastHashPurge;
    protected Connection _con;
    protected String _userSql;
    protected String _roleSql;

    public JDBCLoginService() throws IOException {
    }

    public JDBCLoginService(String name) throws IOException {
        this.setName(name);
    }

    public JDBCLoginService(String name, String config) throws IOException {
        this.setName(name);
        this.setConfig(config);
    }

    public JDBCLoginService(String name, IdentityService identityService, String config) throws IOException {
        this.setName(name);
        this.setIdentityService(identityService);
        this.setConfig(config);
    }

    @Override
    protected void doStart() throws Exception {
        Properties properties = new Properties();
        Resource resource = Resource.newResource((String)this._config);
        try (InputStream in = resource.getInputStream();){
            properties.load(in);
        }
        this._jdbcDriver = properties.getProperty("jdbcdriver");
        this._url = properties.getProperty("url");
        this._userName = properties.getProperty("username");
        this._password = properties.getProperty("password");
        String _userTable = properties.getProperty("usertable");
        this._userTableKey = properties.getProperty("usertablekey");
        String _userTableUserField = properties.getProperty("usertableuserfield");
        this._userTablePasswordField = properties.getProperty("usertablepasswordfield");
        String _roleTable = properties.getProperty("roletable");
        String _roleTableKey = properties.getProperty("roletablekey");
        this._roleTableRoleField = properties.getProperty("roletablerolefield");
        String _userRoleTable = properties.getProperty("userroletable");
        String _userRoleTableUserKey = properties.getProperty("userroletableuserkey");
        String _userRoleTableRoleKey = properties.getProperty("userroletablerolekey");
        this._cacheTime = new Integer(properties.getProperty("cachetime"));
        if (this._jdbcDriver == null || this._jdbcDriver.equals("") || this._url == null || this._url.equals("") || this._userName == null || this._userName.equals("") || this._password == null || this._cacheTime < 0) {
            LOG.warn("UserRealm " + this.getName() + " has not been properly configured", new Object[0]);
        }
        this._cacheTime *= 1000;
        this._lastHashPurge = 0L;
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + _userTable + " where " + _userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + _roleTable + " r, " + _userRoleTable + " u where u." + _userRoleTableUserKey + " = ?" + " and r." + _roleTableKey + " = u." + _userRoleTableRoleKey;
        Loader.loadClass(this.getClass(), (String)this._jdbcDriver).newInstance();
        super.doStart();
    }

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String config) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._config = config;
    }

    public void connectDatabase() {
        try {
            Class.forName(this._jdbcDriver);
            this._con = DriverManager.getConnection(this._url, this._userName, this._password);
        }
        catch (SQLException e) {
            LOG.warn("UserRealm " + this.getName() + " could not connect to database; will try later", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("UserRealm " + this.getName() + " could not connect to database; will try later", (Throwable)e);
        }
    }

    @Override
    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        long now = System.currentTimeMillis();
        if (now - this._lastHashPurge > (long)this._cacheTime || this._cacheTime == 0) {
            this._users.clear();
            this._lastHashPurge = now;
            this.closeConnection();
        }
        return super.login(username, credentials, request);
    }

    @Override
    protected void loadUsers() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected UserIdentity loadUser(String username) {
        try {
            if (null == this._con) {
                this.connectDatabase();
            }
            if (null == this._con) {
                throw new SQLException("Can't connect to database");
            }
            try (PreparedStatement stat1 = this._con.prepareStatement(this._userSql);){
                stat1.setObject(1, username);
                try (ResultSet rs1 = stat1.executeQuery();){
                    if (!rs1.next()) return null;
                    int key = rs1.getInt(this._userTableKey);
                    String credentials = rs1.getString(this._userTablePasswordField);
                    ArrayList<String> roles = new ArrayList<String>();
                    try (PreparedStatement stat2 = this._con.prepareStatement(this._roleSql);){
                        stat2.setInt(1, key);
                        try (ResultSet rs2 = stat2.executeQuery();){
                            while (rs2.next()) {
                                roles.add(rs2.getString(this._roleTableRoleField));
                            }
                        }
                    }
                    UserIdentity userIdentity = this.putUser(username, credentials, roles.toArray(new String[roles.size()]));
                    return userIdentity;
                }
            }
        }
        catch (SQLException e) {
            LOG.warn("UserRealm " + this.getName() + " could not load user information from database", (Throwable)e);
            this.closeConnection();
        }
        return null;
    }

    protected UserIdentity putUser(String username, String credentials, String[] roles) {
        return this.putUser(username, Credential.getCredential((String)credentials), roles);
    }

    private void closeConnection() {
        if (this._con != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing db connection for JDBCUserRealm", new Object[0]);
            }
            try {
                this._con.close();
            }
            catch (Exception e) {
                LOG.ignore((Throwable)e);
            }
        }
        this._con = null;
    }
}

