/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sqt.utils;

import com.meituan.sqt.model.HttpResponse;
import com.meituan.sqt.utils.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import meituan.apache.http.Header;
import meituan.apache.http.HttpEntity;
import meituan.apache.http.NoHttpResponseException;
import meituan.apache.http.client.HttpRequestRetryHandler;
import meituan.apache.http.client.config.RequestConfig;
import meituan.apache.http.client.entity.UrlEncodedFormEntity;
import meituan.apache.http.client.methods.CloseableHttpResponse;
import meituan.apache.http.client.methods.HttpPost;
import meituan.apache.http.client.methods.HttpRequestBase;
import meituan.apache.http.client.methods.HttpUriRequest;
import meituan.apache.http.client.utils.URIBuilder;
import meituan.apache.http.config.ConnectionConfig;
import meituan.apache.http.config.RegistryBuilder;
import meituan.apache.http.conn.HttpClientConnectionManager;
import meituan.apache.http.conn.socket.PlainConnectionSocketFactory;
import meituan.apache.http.conn.ssl.SSLConnectionSocketFactory;
import meituan.apache.http.conn.ssl.TrustAllStrategy;
import meituan.apache.http.entity.StringEntity;
import meituan.apache.http.impl.client.CloseableHttpClient;
import meituan.apache.http.impl.client.HttpClientBuilder;
import meituan.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import meituan.apache.http.message.BasicNameValuePair;
import meituan.apache.http.protocol.HttpContext;
import meituan.apache.http.ssl.SSLContextBuilder;
import meituan.apache.http.ssl.TrustStrategy;
import meituan.apache.http.util.EntityUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger LOGGER;
    private static PoolingHttpClientConnectionManager httpClientConnectionManager;
    private static CloseableHttpClient httpClient;
    private static CloseableHttpClient httpsClient;
    private static HttpConfig httpConfig;
    private static ConnectionConfig connectionConfig;
    private static final String HTTP_CONF_FILE_NAME = "httpConfig.properties";
    private static final String MAX_TOTAL_CONN_NAME = "max_total_connection";
    private static final String MAX_PER_ROUTE_NAME = "max_per_route";
    private static final int MAX_TOTAL_CONNECTION = 1000;
    private static final int MAX_PER_ROUTE = 200;
    private static final int RETRY_COUNT = 0;
    private static String UTF_8;
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int CONNECT_BUFFER_SIZE = 8192;
    public static final int CONNECT_FRAGMENT_SIZE_HINT = 8192;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 500;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    private HttpClientUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConf() {
        if (httpConfig == null) {
            httpConfig = new HttpConfig();
        }
        Properties properties = new Properties();
        InputStream inputStream = HttpClientUtil.class.getClassLoader().getResourceAsStream(HTTP_CONF_FILE_NAME);
        try {
            if (inputStream == null) {
                LOGGER.warn("httpConfig file={} does not exist", (Object)HTTP_CONF_FILE_NAME);
                httpConfig.setMaxTotalConnection(1000);
                httpConfig.setMaxPerRoute(200);
                return;
            }
            properties.load(inputStream);
            int maxTotalConnection = Integer.parseInt(properties.getProperty(MAX_TOTAL_CONN_NAME));
            int maxPerRoute = Integer.parseInt(properties.getProperty(MAX_PER_ROUTE_NAME));
            String retryProperty = properties.getProperty("retry");
            int retry = 0;
            if (!StringUtils.isEmpty((CharSequence)retryProperty)) {
                retry = Integer.parseInt(retryProperty);
            }
            LOGGER.info("max_total_connection={}, max_per_route={},retry={}", new Object[]{maxTotalConnection, maxPerRoute, retry});
            httpConfig.setMaxTotalConnection(maxTotalConnection);
            httpConfig.setMaxPerRoute(maxPerRoute);
            httpConfig.setRetry(retry);
        }
        catch (Exception e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static HttpResponse invokePost(String url, Map<String, String> headers, Map<String, String> params, Integer conTimeout, Integer socketTimeout) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        HttpPost httpPost = new HttpPost(uriBuilder.build());
        RequestConfig config = HttpClientUtil.buildRequestConfig(conTimeout, socketTimeout);
        httpPost.setConfig(config);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> param : headers.entrySet()) {
                httpPost.addHeader(param.getKey(), param.getValue());
            }
        }
        if (params != null && params.size() > 0) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> param : params.entrySet()) {
                pairs.add(new BasicNameValuePair(param.getKey(), param.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, UTF_8));
        }
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static HttpResponse invokePost2Json(String url, String body, Integer conTimeout, Integer socketTimeout) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        HttpPost httpPost = new HttpPost(uriBuilder.build());
        RequestConfig config = HttpClientUtil.buildRequestConfig(conTimeout, socketTimeout);
        httpPost.setConfig(config);
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        httpPost.setHeader("Accept", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(body, Charset.forName(UTF_8)));
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    private static HttpResponse sendRequest(String url, HttpRequestBase request) throws Exception {
        Header[] headers;
        CloseableHttpClient client = url.startsWith(HTTPS) ? httpsClient : httpClient;
        long st = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        HttpResponse httpResponse = null;
        if (LOGGER.isDebugEnabled() && (headers = request.getAllHeaders()) != null) {
            LOGGER.debug("HttpClient request headers:{}", (Object)JsonUtil.object2Json(headers));
        }
        try {
            response = client.execute((HttpUriRequest)request);
            httpResponse = HttpClientUtil.buildHttpResponse(response);
        }
        catch (Exception e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        finally {
            request.releaseConnection();
            if (response != null) {
                response.close();
            }
        }
        LOGGER.info("HttpClient Success, status:{}, url:{}, allHeaders:{}, use_time:{} ms", new Object[]{httpResponse.getStatus(), request.getURI(), JsonUtil.object2Json(httpResponse.getHeader()), System.currentTimeMillis() - st});
        return httpResponse;
    }

    private static HttpResponse buildHttpResponse(CloseableHttpResponse response) throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(response.getStatusLine().getStatusCode());
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            httpResponse.setBody(EntityUtils.toString((HttpEntity)entity, (String)UTF_8));
        } else {
            httpResponse.setBody("");
        }
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        Header[] headers = response.getAllHeaders();
        if (null != headers && headers.length > 0) {
            Arrays.asList(headers).stream().forEach(t -> {
                ArrayList<String> headerValueList = (ArrayList<String>)headerMap.get(t.getName());
                if (headerValueList == null) {
                    headerValueList = new ArrayList<String>();
                }
                headerValueList.add(t.getValue());
                headerMap.put(t.getName(), headerValueList);
            });
        }
        httpResponse.setHeader(headerMap);
        return httpResponse;
    }

    private static RequestConfig buildRequestConfig(Integer connTimeout, Integer readTimeout) {
        RequestConfig.Builder customReqConf = RequestConfig.custom();
        if (connTimeout != null && connTimeout > 0) {
            customReqConf.setConnectTimeout(connTimeout.intValue());
        } else {
            customReqConf.setConnectTimeout(5000);
        }
        if (readTimeout != null && readTimeout > 0) {
            customReqConf.setSocketTimeout(readTimeout.intValue());
        } else {
            customReqConf.setSocketTimeout(5000);
        }
        customReqConf.setConnectionRequestTimeout(500);
        return customReqConf.build();
    }

    static {
        SSLContext sslContext;
        LOGGER = LoggerFactory.getLogger(HttpClientUtil.class);
        httpClientConnectionManager = null;
        httpClient = null;
        httpsClient = null;
        httpConfig = null;
        UTF_8 = "UTF-8";
        HttpClientUtil.loadConf();
        connectionConfig = ConnectionConfig.custom().setBufferSize(8192).setFragmentSizeHint(8192).build();
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
        }
        catch (Exception e) {
            LOGGER.error("init SSLContext error", (Throwable)e);
            throw new RuntimeException(e);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext);
        httpClientConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register(HTTP, (Object)PlainConnectionSocketFactory.getSocketFactory()).register(HTTPS, (Object)sslConnectionSocketFactory).build());
        httpClientConnectionManager.setMaxTotal(httpConfig.getMaxTotalConnection());
        httpClientConnectionManager.setDefaultMaxPerRoute(httpConfig.getMaxPerRoute());
        httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(httpConfig.getRetry())).build();
        httpsClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        LOGGER.info("HttpClient initialization");
    }

    static class DefaultHttpRequestRetryHandler
    implements HttpRequestRetryHandler {
        private int retry;

        DefaultHttpRequestRetryHandler() {
        }

        DefaultHttpRequestRetryHandler(int retry) {
            this.retry = retry;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (this.retry <= 0) {
                return false;
            }
            if (executionCount > this.retry) {
                return false;
            }
            return exception instanceof NoHttpResponseException;
        }
    }

    static class HttpConfig {
        private int maxTotalConnection = 1000;
        private int maxPerRoute = 200;
        private int retry = 0;

        HttpConfig() {
        }

        public int getMaxTotalConnection() {
            return this.maxTotalConnection;
        }

        public void setMaxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
        }

        public int getMaxPerRoute() {
            return this.maxPerRoute;
        }

        public void setMaxPerRoute(int maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
        }

        public int getRetry() {
            return this.retry;
        }

        public void setRetry(int retry) {
            this.retry = retry;
        }
    }
}

